/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.pkcs;

import java.util.Enumeration;
import org.bouncycastle.asn1.DERConstructedSequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class EncryptedPrivateKeyInfo
implements PKCSObjectIdentifiers,
DEREncodable {
    private AlgorithmIdentifier algId;
    private DEROctetString data;

    public EncryptedPrivateKeyInfo(DERConstructedSequence dERConstructedSequence) {
        Enumeration enumeration = dERConstructedSequence.getObjects();
        this.algId = new AlgorithmIdentifier((DERConstructedSequence)enumeration.nextElement());
        this.data = (DEROctetString)enumeration.nextElement();
    }

    public EncryptedPrivateKeyInfo(AlgorithmIdentifier algorithmIdentifier, byte[] byArray) {
        this.algId = algorithmIdentifier;
        this.data = new DEROctetString(byArray);
    }

    public AlgorithmIdentifier getEncryptionAlgorithm() {
        return this.algId;
    }

    public byte[] getEncryptedData() {
        return this.data.getOctets();
    }

    public DERObject getDERObject() {
        DERConstructedSequence dERConstructedSequence = new DERConstructedSequence();
        dERConstructedSequence.addObject(this.algId);
        dERConstructedSequence.addObject(this.data);
        return dERConstructedSequence;
    }
}

