/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.blusync.service.update;

import com.parablu.epa.common.service.notification.NotificationHelper;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.helper.PropertyHelper;
import com.parablu.epa.service.alarm.BlusyncThreadHelper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkleActivator {
    private static Logger logger = LoggerFactory.getLogger(SparkleActivator.class);
    private boolean updateAtStartup = true;
    private int checkInterval = 3600;

    public void start() throws IOException {
        SparkleActivator.initSparkle(System.getProperty("java.library.path") + "/../Frameworks/Sparkle.framework", this.updateAtStartup, this.checkInterval, this);
    }

    public void notifyTermination() {
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
        File file = new File(System.getProperty("user.dir") + "/" + dateFormat.format(date) + ".test");
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(file));
            out.write("Writing to file");
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (NotificationHelper.isBackUpStarted()) {
            BlusyncThreadHelper.cancelCurrentBackupProcess(true, false, false, false, false);
        }
        SettingHelper.deleteParaBluFolderPathTempFile();
        SettingHelper.deleteUserValidityFilePath();
        SettingHelper.deleteNotSyncedFile();
        System.out.println("goin to start thread and kill agent....");
        Runnable runnable = () -> {
            try {
                System.out.println("Wait time to kill the app from property>>>" + PropertyHelper.WAIT_TIME_SPARKLE_EXIT);
                Thread.sleep(StringUtils.isNotEmpty((String)PropertyHelper.WAIT_TIME_SPARKLE_EXIT) ? Long.valueOf(PropertyHelper.WAIT_TIME_SPARKLE_EXIT) : 1000L);
                System.out.println("Goin to terminate the app....");
                System.exit(0);
            }
            catch (Exception e) {
                System.out.println("Exception in runnable....." + e);
            }
        };
        new Thread(runnable).start();
    }

    private void printAndStopAllThreadsExceptMain(boolean stopThread) {
        Set<Thread> threadSet = Thread.getAllStackTraces().keySet();
        for (Thread thread : threadSet) {
            System.out.println(threadSet.size() + " :size.. Current thread:" + thread.getName());
            if (thread.getName().equalsIgnoreCase("main") || !stopThread) continue;
            System.out.println("Stopping the current thread...");
            thread.stop();
            System.out.println("After Stopping the current thread..." + thread.isAlive());
        }
        threadSet = Thread.getAllStackTraces().keySet();
        if (threadSet.size() > 1) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            System.out.println("After sleep....");
            for (Thread thread : threadSet) {
                System.out.println(threadSet.size() + " :size.. Current thread:" + thread.getName());
                if (!stopThread) continue;
                System.out.println("Stopping the current thread...");
                thread.stop();
                System.out.println("After Stopping the current thread..." + thread.isAlive());
            }
        }
    }

    public static native void initSparkle(String var0, boolean var1, int var2, SparkleActivator var3);

    static {
        try {
            logger.debug("Before Loading Sparkle update libraryyyyy....");
            System.loadLibrary("sparkle_init");
        }
        catch (UnsatisfiedLinkError e) {
            logger.error("Error in load sparkle directory..." + e);
        }
    }
}

