/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.pkcs;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Enumeration;
import org.bouncycastle.asn1.DERConstructedSequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInputStream;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class PrivateKeyInfo
implements PKCSObjectIdentifiers,
DEREncodable {
    private DERObject privKey;
    private AlgorithmIdentifier algId;

    public PrivateKeyInfo(AlgorithmIdentifier algorithmIdentifier, DERObject dERObject) {
        this.privKey = dERObject;
        this.algId = algorithmIdentifier;
    }

    public PrivateKeyInfo(DERConstructedSequence dERConstructedSequence) {
        Enumeration enumeration = dERConstructedSequence.getObjects();
        BigInteger bigInteger = ((DERInteger)enumeration.nextElement()).getValue();
        if (bigInteger.intValue() != 0) {
            throw new IllegalArgumentException("wrong version for private key info");
        }
        this.algId = new AlgorithmIdentifier((DERConstructedSequence)enumeration.nextElement());
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(((DEROctetString)enumeration.nextElement()).getOctets());
            DERInputStream dERInputStream = new DERInputStream(byteArrayInputStream);
            this.privKey = dERInputStream.readObject();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Error recoverying private key from sequence");
        }
    }

    public AlgorithmIdentifier getAlgorithmId() {
        return this.algId;
    }

    public DERObject getPrivateKey() {
        return this.privKey;
    }

    public DERObject getDERObject() {
        DERConstructedSequence dERConstructedSequence = new DERConstructedSequence();
        dERConstructedSequence.addObject(new DERInteger(0));
        dERConstructedSequence.addObject(this.algId);
        dERConstructedSequence.addObject(new DEROctetString(this.privKey));
        return dERConstructedSequence;
    }
}

