/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.service.settings;

import com.parablu.epa.common.service.settings.CipherHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedPreferences {
    private static Logger logger = LoggerFactory.getLogger(SharedPreferences.class);
    public static final String NULL_STRING_REPRESENTATION = "null";
    private File settingsFile;
    private static final String FILE_NOT_FOUND_EXCEPTION = "file not found exception";
    private static final String EXCEPTION_WHILE_SETTINDATATO_SHAREDPREFERENCES = "Exception while setting data to SharedPreferences";

    public SharedPreferences(String uRL) {
        this.settingsFile = new File(uRL);
    }

    public Map<String, String> readAllData() {
        Properties props = new Properties();
        LinkedHashMap<String, String> settingsMap = new LinkedHashMap<String, String>();
        Cipher cipher = null;
        try {
            cipher = CipherHelper.decryptionCipher();
            if (this.settingsFile.exists()) {
                this.readFromFileAndPutIntoMap(props, settingsMap, cipher);
            }
        }
        catch (UnsupportedEncodingException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e1) {
            logger.trace("" + e1);
            logger.error("exception while cipher decryption " + e1.getMessage());
        }
        return settingsMap;
    }

    private void readFromFileAndPutIntoMap(Properties props, Map<String, String> settingsMap, Cipher cipher) {
        try (CipherInputStream is = new CipherInputStream(new FileInputStream(this.settingsFile), cipher);){
            props.load(is);
            is.close();
            Enumeration<Object> keys = props.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                settingsMap.put(key, props.get(key).toString());
            }
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error(FILE_NOT_FOUND_EXCEPTION + e.getMessage());
        }
    }

    public Map<String, String> readAllDataUnencrypted() {
        Properties props = new Properties();
        LinkedHashMap<String, String> settingsMap = new LinkedHashMap<String, String>();
        try {
            if (this.settingsFile.exists()) {
                this.readAllUnencryptedData(props, settingsMap);
            }
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error(FILE_NOT_FOUND_EXCEPTION + e.getMessage());
        }
        return settingsMap;
    }

    private void readAllUnencryptedData(Properties props, Map<String, String> settingsMap) {
        try (FileInputStream is = new FileInputStream(this.settingsFile);){
            props.load(is);
            is.close();
            Enumeration<Object> keys = props.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                settingsMap.put(key, props.get(key).toString());
            }
        }
        catch (Exception e) {
            logger.trace("" + e);
            logger.error(FILE_NOT_FOUND_EXCEPTION + e.getMessage());
        }
    }

    public boolean setData(Map<String, String> settingsMap) {
        Properties props = new Properties();
        boolean success = false;
        try {
            if (!settingsMap.isEmpty()) {
                boolean created;
                if (!this.settingsFile.exists() && !(created = this.settingsFile.createNewFile())) {
                    logger.debug("Couldnt Create Settings File");
                    return false;
                }
                Cipher cipher = CipherHelper.encryptionCipher();
                Set<Map.Entry<String, String>> set = settingsMap.entrySet();
                for (Map.Entry<String, String> entry : set) {
                    String key = entry.getKey();
                    String val = entry.getValue();
                    if (key == null) continue;
                    if (val == null) {
                        props.setProperty(key, NULL_STRING_REPRESENTATION);
                        continue;
                    }
                    props.setProperty(key, val);
                }
                success = this.readFromCipherStream(props, success, cipher);
            }
        }
        catch (Exception e) {
            logger.error(EXCEPTION_WHILE_SETTINDATATO_SHAREDPREFERENCES + e);
        }
        return success;
    }

    private boolean readFromCipherStream(Properties props, boolean success, Cipher cipher) {
        boolean succ = success;
        try (CipherOutputStream os = new CipherOutputStream(new FileOutputStream(this.settingsFile), cipher);){
            props.store(os, "");
            os.close();
            succ = true;
        }
        catch (IOException e) {
            logger.error(EXCEPTION_WHILE_SETTINDATATO_SHAREDPREFERENCES + e);
        }
        return succ;
    }

    public boolean setDataUnencrypted(Map<String, String> settingsMap) {
        Properties props = new Properties();
        boolean success = false;
        try {
            if (!settingsMap.isEmpty()) {
                boolean created;
                if (!this.settingsFile.exists() && !(created = this.settingsFile.createNewFile())) {
                    logger.debug("Couldnt Create Settings File");
                    return false;
                }
                Set<Map.Entry<String, String>> set = settingsMap.entrySet();
                for (Map.Entry<String, String> entry : set) {
                    String key = entry.getKey();
                    String val = entry.getValue();
                    if (key == null) continue;
                    if (val == null) {
                        props.setProperty(key, NULL_STRING_REPRESENTATION);
                        continue;
                    }
                    props.setProperty(key, val);
                }
                success = this.readFromSettingsFile(props, success);
            }
        }
        catch (Exception e) {
            logger.error(EXCEPTION_WHILE_SETTINDATATO_SHAREDPREFERENCES + e);
        }
        return success;
    }

    private boolean readFromSettingsFile(Properties props, boolean success) {
        boolean succ = success;
        try (FileOutputStream os = new FileOutputStream(this.settingsFile);){
            props.store(os, "");
            os.close();
            succ = true;
        }
        catch (IOException e) {
            logger.error(EXCEPTION_WHILE_SETTINDATATO_SHAREDPREFERENCES + e);
        }
        return succ;
    }
}

