/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.helper.about;

import org.hyperic.sigar.CpuPerc;
import org.hyperic.sigar.Mem;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemInfo {
    private Logger logger = LoggerFactory.getLogger(SystemInfo.class);
    private Sigar sigar1 = new Sigar();

    public double getSystemMemory() throws SigarException {
        Mem mem = this.sigar1.getMem();
        long systemTotal = mem.getTotal();
        long systemUsed = mem.getUsed();
        double systemLoadInPercentage = (double)systemUsed * 0.1 / (double)systemTotal * 1000.0;
        this.logger.trace("Total used system memory in percentage.......: " + (double)systemUsed * 0.1 / (double)systemTotal * 100.0);
        return systemLoadInPercentage;
    }

    public double getCPUIdlePerc() {
        try {
            this.logger.trace("CPU PERCENTAGE PERC:" + this.sigar1.getCpuPerc());
            CpuPerc cpuPerc = this.sigar1.getCpuPerc();
            String cpuIdlePerc = CpuPerc.format((double)cpuPerc.getIdle());
            return Double.parseDouble(cpuIdlePerc.replace("%", ""));
        }
        catch (SigarException e) {
            this.logger.trace("getCPUIdlePerc : " + e);
            this.logger.error(e.getMessage());
            return 0.0;
        }
    }
}

