/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import java.math.BigInteger;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERConstructedSequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERTags;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.digests.SHA1Digest;

public class AuthorityKeyIdentifier
implements DEREncodable,
DERTags {
    ASN1OctetString keyidentifier = null;
    GeneralNames certissuer = null;
    DERInteger certserno = null;

    public AuthorityKeyIdentifier(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        while (enumeration.hasMoreElements()) {
            DERTaggedObject dERTaggedObject = (DERTaggedObject)enumeration.nextElement();
            switch (dERTaggedObject.getTagNo()) {
                case 0: {
                    this.keyidentifier = ASN1OctetString.getInstance(dERTaggedObject);
                    break;
                }
                case 1: {
                    this.certissuer = GeneralNames.getInstance(dERTaggedObject);
                    break;
                }
                case 2: {
                    this.certserno = DERInteger.getInstance(dERTaggedObject);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("illegal tag");
                }
            }
        }
    }

    public AuthorityKeyIdentifier(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        SHA1Digest sHA1Digest = new SHA1Digest();
        byte[] byArray = new byte[sHA1Digest.getDigestSize()];
        byte[] byArray2 = subjectPublicKeyInfo.getPublicKeyData().getBytes();
        sHA1Digest.update(byArray2, 0, byArray2.length);
        sHA1Digest.doFinal(byArray, 0);
        this.keyidentifier = new DEROctetString(byArray);
    }

    public AuthorityKeyIdentifier(SubjectPublicKeyInfo subjectPublicKeyInfo, GeneralNames generalNames, BigInteger bigInteger) {
        SHA1Digest sHA1Digest = new SHA1Digest();
        byte[] byArray = new byte[sHA1Digest.getDigestSize()];
        byte[] byArray2 = subjectPublicKeyInfo.getPublicKeyData().getBytes();
        sHA1Digest.update(byArray2, 0, byArray2.length);
        sHA1Digest.doFinal(byArray, 0);
        this.keyidentifier = new DEROctetString(byArray);
        this.certissuer = generalNames;
        this.certserno = new DERInteger(bigInteger);
    }

    public byte[] getKeyIdentifier() {
        if (this.keyidentifier != null) {
            return this.keyidentifier.getOctets();
        }
        return null;
    }

    public DERObject getDERObject() {
        DERConstructedSequence dERConstructedSequence = new DERConstructedSequence();
        if (this.keyidentifier != null) {
            dERConstructedSequence.addObject(new DERTaggedObject(false, 0, this.keyidentifier));
        }
        if (this.certissuer != null) {
            this.certissuer.markInsideImplicit(true);
            dERConstructedSequence.addObject(new DERTaggedObject(false, 1, this.certissuer));
        }
        if (this.certserno != null) {
            dERConstructedSequence.addObject(new DERTaggedObject(false, 2, this.certserno));
        }
        return dERConstructedSequence;
    }

    public String toString() {
        return "AuthorityKeyIdentifier: KeyID(" + this.keyidentifier.getOctets() + ")";
    }
}

