/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.util.ArrayList;
import java.util.List;
import zmq.Msg;
import zmq.Pipe;
import zmq.Utils;
import zmq.ValueReference;

class FQ {
    private final List<Pipe> pipes = new ArrayList<Pipe>();
    private int active = 0;
    private int current = 0;
    private boolean more = false;

    public void attach(Pipe pipe) {
        this.pipes.add(pipe);
        Utils.swap(this.pipes, this.active, this.pipes.size() - 1);
        ++this.active;
    }

    public void terminated(Pipe pipe) {
        int index = this.pipes.indexOf(pipe);
        if (index < this.active) {
            --this.active;
            Utils.swap(this.pipes, index, this.active);
            if (this.current == this.active) {
                this.current = 0;
            }
        }
        this.pipes.remove(pipe);
    }

    public void activated(Pipe pipe) {
        Utils.swap(this.pipes, this.pipes.indexOf(pipe), this.active);
        ++this.active;
    }

    public Msg recv(ValueReference<Integer> errno) {
        return this.recvPipe(errno, null);
    }

    public Msg recvPipe(ValueReference<Integer> errno, ValueReference<Pipe> pipe) {
        while (this.active > 0) {
            boolean fetched;
            Msg msg = this.pipes.get(this.current).read();
            boolean bl = fetched = msg != null;
            if (fetched) {
                if (pipe != null) {
                    pipe.set(this.pipes.get(this.current));
                }
                this.more = msg.hasMore();
                if (!this.more) {
                    this.current = (this.current + 1) % this.active;
                }
                return msg;
            }
            assert (!this.more);
            --this.active;
            Utils.swap(this.pipes, this.current, this.active);
            if (this.current != this.active) continue;
            this.current = 0;
        }
        errno.set(35);
        return null;
    }

    public boolean hasIn() {
        if (this.more) {
            return true;
        }
        while (this.active > 0) {
            if (this.pipes.get(this.current).checkRead()) {
                return true;
            }
            --this.active;
            Utils.swap(this.pipes, this.current, this.active);
            if (this.current != this.active) continue;
            this.current = 0;
        }
        return false;
    }
}

