/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.view;

import com.parablu.epa.common.constants.SyncConstants;
import com.parablu.epa.common.dao.BackUpFolderDAOImpl;
import com.parablu.epa.common.dao.BackupPolicyDAOImpl;
import com.parablu.epa.common.dao.MediaFolderDAOImpl;
import com.parablu.epa.common.dao.SyncPolicyDAOImpl;
import com.parablu.epa.common.service.notification.NotificationHelper;
import com.parablu.epa.common.service.settings.BackupHelper;
import com.parablu.epa.common.service.settings.PolicyManagementServerHelper;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.common.stringliterals.RegistrationLiterals;
import com.parablu.epa.core.adapter.pcb.BackupAdapter;
import com.parablu.epa.core.constant.StringLiterals;
import com.parablu.epa.core.element.FileListElement;
import com.parablu.epa.core.element.GroupPolicyElement;
import com.parablu.epa.core.element.GroupPolicyElementList;
import com.parablu.epa.core.element.ProxyElement;
import com.parablu.epa.core.element.SyncPolicyElement;
import com.parablu.epa.core.helper.PropertyHelper;
import com.parablu.epa.core.service.registration.CloudRegistrationUtility;
import com.parablu.epa.core.to.BackupPolicyTO;
import com.parablu.epa.core.to.DeviceRegTo;
import com.parablu.epa.core.to.MediaFolderTO;
import com.parablu.epa.core.to.SyncPolicyTo;
import com.parablu.epa.helper.utils.ParabluFileSystemUtils;
import com.parablu.epa.service.settings.MacSettingsHelper;
import com.parablu.epa.view.BackupManagerView;
import com.parablu.epa.view.BluSyncLauncher;
import com.parablu.epa.view.FontsManager;
import com.parablu.epa.view.RegistrationView;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProgressBarPaneView
implements Runnable {
    private Logger logger = LoggerFactory.getLogger(ProgressBarPaneView.class);
    private ImageData tickImageData = null;
    private Image tickImage = null;
    public static final String RESOURCE = "resource";
    private static final String IMG = "img";
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final String PARABLU_SEARCHING_GIF = MacSettingsHelper.baseResourceFolder + "resource" + FILE_SEPARATOR + "img" + FILE_SEPARATOR + "ParaBluSearch.gif";
    private static final String FALSE = "false";
    public static final String DEVICE_ALREADY_REGISTERED = "false";
    private Composite compositeForGif = null;
    private Composite compositeForFolderLocation = null;
    private Label chooseFolderDescriptionLabel = null;
    private Label chooseFolderImage = null;
    private Group currentFolderSelectPanel = null;
    private Composite helpTextPanel = null;
    private Label chooseFolderDefaultLabel = null;
    private Label helpTextLabel = null;
    private Text currentFolderSelectedText = null;
    private Button browseButton = null;
    private Display display = null;
    private String userCloudName = null;
    private String userDeviceName = null;
    private String name = null;
    private String userPassword = null;
    private StackLayout parentStackLayout = null;
    private Composite parentComposite = null;
    private Composite registrationPanelForInputTexts = null;
    private ImageLoader loader = null;
    private Image image = null;
    private int imageNumber = 0;
    private Thread gifUpdaterThread = null;
    private Canvas canvas = null;
    private Label connectingLabel;
    private static BackupAdapter backupAdapter = null;
    private boolean continueSearchDisplay = true;
    public static String loginType = "PB";
    private Image registrationImage = null;
    private static final int MINIMUM_WIDTH = 350;
    private static final int MINIMUM_HEIGHT = 10;
    private static Label messageLabel = null;
    private final Button registerButton;
    private Label pageDescription;
    private final RegistrationView.RegisterSelectionAdapter registerSelectionAdapter;
    private FontsManager fontsManager;
    private static final String DEFAULT_FOLDER_NAME = SettingHelper.getUserHome();
    private static final String DEFAULT_PARABLU_NAME = StringLiterals.FILE_SEPARATOR + "ParaBlu";
    String folderPath = DEFAULT_FOLDER_NAME;
    public static final String FORCE_REGISTRATION = "true";
    private static final int SEARCHING_CLOUD = 0;
    private static final int VALIDATING_USER = 1;
    private static final int ERROR = -5000;
    private int result = -5000;
    private Composite mainTextPanel;
    private Composite compositeForFolderGroups;
    private static final String SILENT = "silent";
    private static final String SHELL_CLOSE_STR = "Trying to close shell ";
    private static final String DISPLAY_NULL = "Display is null";
    private boolean retryRegister = false;
    private static BackUpFolderDAOImpl backUpFolderDAOImpl = null;
    protected static Shell silentShell;
    public static int deviceRegistryResponse;
    private Display display1 = null;

    public ProgressBarPaneView(Composite stackPanel, String cloudName, String deviceName, String userName, String password, Button parentRegButton, StackLayout stackLayout, Composite defaultComposite, RegistrationView.RegisterSelectionAdapter registerSelectionAdapter) {
        this.userCloudName = cloudName;
        this.userDeviceName = deviceName;
        this.name = userName;
        this.userPassword = password;
        this.parentComposite = stackPanel;
        this.registerButton = parentRegButton;
        this.parentStackLayout = stackLayout;
        this.registrationPanelForInputTexts = defaultComposite;
        this.registerSelectionAdapter = registerSelectionAdapter;
    }

    @Override
    public void run() {
        try {
            this.logger.debug("Silent Value&*&*&**&****&*&*" + BluSyncLauncher.isSilent);
            if (!SILENT.equalsIgnoreCase(BluSyncLauncher.isSilent)) {
                this.loadUI();
            } else if (SILENT.equalsIgnoreCase(BluSyncLauncher.isSilent)) {
                this.retryRegister = true;
            }
            this.logger.debug("Starting cloud registration ");
            CloudRegistrationUtility rs = new CloudRegistrationUtility(this.userCloudName, this.userDeviceName, this.name, this.userPassword, SettingHelper.getKeystorePath());
            this.logger.debug("searching for cloud ");
            this.update(0);
            boolean isIPFound = rs.searchForPublicIpOfCloud();
            if (!isIPFound) {
                if (!StringUtils.isEmpty((String)PropertyHelper.MAIN_EBMS_DOMAIN)) {
                    this.logger.debug("Inside hash check needed....");
                    rs.setGaeCloudLocalIP(PropertyHelper.MAIN_EBMS_DOMAIN.trim());
                    rs.setCloudPublicIP(PropertyHelper.MAIN_EBMS_DOMAIN.trim());
                } else {
                    this.showFailedToRegisterMessageBox(RegistrationLiterals.DEVICE_REGISTRATION_ERROR_TITLE, " Cloud name is not mapped to your Account");
                    this.closeShell();
                    return;
                }
            }
            this.update(1);
            this.logger.debug("Registering Cloud");
            rs.retryRegister = this.retryRegister;
            rs.productVersion = SettingHelper.getProductVersion();
            DeviceRegTo response = rs.registerDeviceForCloud(null, SettingHelper.getOsName(), "false", loginType, SettingHelper.getOsVersion(), FORCE_REGISTRATION, "false");
            this.continueSearchDisplay = false;
            this.logger.debug("registering device ");
            int res = this.decipherResponseTo(response, rs);
            if (res == 64) {
                response = rs.registerDeviceForCloud(null, SettingHelper.getOsName(), FORCE_REGISTRATION, loginType, SettingHelper.getOsVersion(), FORCE_REGISTRATION, "false");
                res = this.decipherResponseTo(response, rs);
            }
            if (res == 68) {
                int res1;
                String isSilent = PropertyHelper.getMessageResourceString((String)"login-type");
                String decoupled = PropertyHelper.getMessageResourceString((String)"decoupled");
                this.logger.debug("isSilent....:" + isSilent + " decoupled...... " + decoupled);
                if (StringUtils.isNotEmpty((String)isSilent) && SILENT.equalsIgnoreCase(isSilent) && StringUtils.isNotEmpty((String)decoupled) && FORCE_REGISTRATION.equalsIgnoreCase(decoupled) && (res1 = this.checkForConfirmation("Device decoupled", "To register the device again please click on the button below")) != 1) {
                    this.logger.debug("Registering device failed due to ...");
                    System.exit(0);
                }
                int retryCount = 0;
                int sleepTime = 1000;
                rs.startHttpServer();
                String clientId = response.getClientId();
                String redirectUri = response.getEndPointRedirectUri();
                String tenantName = response.getTenantName();
                String loginMode = response.getLoginMode();
                this.logger.debug("clientId:" + clientId);
                this.logger.debug("redirectUri:" + redirectUri);
                String url = "https://login.microsoftonline.com/" + tenantName + "/oauth2/v2.0/authorize?\nclient_id=" + clientId + "\n&response_type=code\n&redirect_uri=" + redirectUri + "\n&response_mode=query\n&scope=offline_access%20user.read";
                if (loginMode.equalsIgnoreCase("okta")) {
                    url = "https://" + tenantName + "/oauth2/v1/authorize?client_id=" + clientId + "&response_type=code&redirect_uri=" + redirectUri + "&response_mode=query&scope=openid%20profile%20email&state=state-pvn";
                }
                if (loginMode.equalsIgnoreCase("onelogin")) {
                    url = "https://" + tenantName + "/oidc/2/auth?client_id=" + clientId + "&response_type=code&redirect_uri=" + redirectUri + "&response_mode=query&scope=openid%20profile%20email&state=state-pvn";
                }
                this.logger.debug("url..." + url);
                Program.launch((String)url);
                while (StringUtils.isEmpty((String)ParabluFileSystemUtils.getAADAuthCode())) {
                    this.logger.debug("Sleep and Wait for Auth code.. ");
                    Thread.sleep(sleepTime);
                    if (++retryCount <= 30) continue;
                    sleepTime = 30000;
                    if (retryCount <= 90) continue;
                    this.logger.debug("couldn't get the auth code in a given time so quit the application");
                    System.exit(0);
                }
                rs.stopHttpServer();
                this.logger.debug("AAD auth code:" + ParabluFileSystemUtils.getAADAuthCode());
                response = rs.registerDeviceForCloud(null, SettingHelper.getOsName(), FORCE_REGISTRATION, loginType, SettingHelper.getOsVersion(), "false", FORCE_REGISTRATION);
                this.logger.debug("access token:" + response.getAccessToken());
                if (StringUtils.isNotEmpty((String)response.getAccessToken())) {
                    ParabluFileSystemUtils.setAADAccessToken((String)response.getAccessToken());
                }
                res = this.decipherResponseTo(response, rs);
            }
            if (res == 66) {
                if (StringUtils.isNotEmpty((String)response.getAccessToken())) {
                    ParabluFileSystemUtils.setAADAccessToken((String)response.getAccessToken());
                }
                response = rs.registerDeviceForCloud(null, SettingHelper.getOsName(), "false", SettingHelper.getKeystorePath(), SettingHelper.getOsVersion(), FORCE_REGISTRATION, "false");
                res = this.decipherResponseTo(response, rs);
            }
            if (res == 65) {
                response = rs.registerDeviceForCloud(null, SettingHelper.getOsName(), "false", SettingHelper.getKeystorePath(), SettingHelper.getOsVersion(), "false", "false");
                res = this.decipherResponseTo(response, rs);
            }
            if (res == 0 || res == 128) {
                this.closeShell();
                return;
            }
            if (res == 1) {
                this.logger.debug("registering device successful");
                SettingHelper.setSyncLicenced((String)response.getSyncEnabled());
                SettingHelper.setBackupLicenced((String)response.getBackupEnabled());
                SettingHelper.setLicenseActive((boolean)true);
                SettingHelper.setDeviceBlocked((boolean)false);
                SettingHelper.setDeviceUUId((String)response.getDeviceUUId());
                SettingHelper.setRestoreEnabled((String)response.getRestoreEnabled());
                SettingHelper.setIsExternalStorageSelected((String)response.getIsExternalStorageSelected());
                SettingHelper.setUserConsentGiven((boolean)response.isUserConsentGiven());
                this.logger.debug("deviceUUId*******" + SettingHelper.getDeviceUUId());
                NotificationHelper.setCurrentActivityId((long)6L);
                if (SettingHelper.getBackupLicenced().contentEquals(FORCE_REGISTRATION) && response.getBackupPolicyElement() == null || SettingHelper.getSyncLicenced().contentEquals(FORCE_REGISTRATION) && response.getSyncPolicyElement() == null) {
                    this.logger.debug("Backup Policy : " + response.getBackupPolicyElement());
                    this.logger.debug("Sync Policy : " + response.getSyncPolicyElement());
                    this.showFailedToRegisterMessageBox(RegistrationLiterals.DEVICE_REGISTRATION_ERROR_TITLE, "No policy mapped to user.\nPlease contact administrator");
                    this.closeShell();
                    return;
                }
                BackupPolicyDAOImpl backupPolicyDAOImpl = new BackupPolicyDAOImpl(SettingHelper.getBackUpDbUrl());
                if (SettingHelper.getBackupLicenced().contentEquals(FORCE_REGISTRATION)) {
                    this.logger.debug("Before creating databases..");
                    BackupHelper.setFullBackupFlagInReg((String)"FULL");
                    backUpFolderDAOImpl = new BackUpFolderDAOImpl(SettingHelper.getBackUpDbUrl());
                    backupPolicyDAOImpl.createBackupPolicyTable();
                    backupPolicyDAOImpl.createDeviceBackupLicenseTable();
                    backupPolicyDAOImpl.createNetworkThrottlingTable();
                    backupPolicyDAOImpl.createSchedulesTable();
                    backupPolicyDAOImpl.createInclusionsTable();
                    backupPolicyDAOImpl.createPrivacyGatewayTable();
                    backupPolicyDAOImpl.createBackupPolicyDefaultFoldersTable();
                    backupPolicyDAOImpl.createEBMSTable();
                    backupPolicyDAOImpl.createPolicyExceptionsTOExclusionTable();
                    backUpFolderDAOImpl.createHashTable();
                    backupPolicyDAOImpl.createNoBkpSchedulesTable();
                    this.logger.debug(" @@@@ " + response.getDeviceRegistrationElement().getDeviceElement().getDeviceName());
                    GroupPolicyElementList groupPolicyElementList = new GroupPolicyElementList();
                    ArrayList<GroupPolicyElement> groupPolicyElements = new ArrayList<GroupPolicyElement>();
                    groupPolicyElements.add(response.getBackupPolicyElement());
                    groupPolicyElementList.setGroupPolicyElement(groupPolicyElements);
                    PolicyManagementServerHelper.createGroupPolicyAndChildDetails((BackupPolicyDAOImpl)backupPolicyDAOImpl, (BackupPolicyTO)new BackupPolicyTO(), (GroupPolicyElementList)groupPolicyElementList);
                    if (SettingHelper.isDCMEnabled() && BluSyncLauncher.certName != null && !BluSyncLauncher.certName.isEmpty() && !this.authenticateDeviceCertificate(rs)) {
                        return;
                    }
                }
                if (SettingHelper.getSyncLicenced().contentEquals(FORCE_REGISTRATION)) {
                    SyncPolicyDAOImpl syncPolicyDAOImpl = new SyncPolicyDAOImpl(SettingHelper.getSyncdburl());
                    syncPolicyDAOImpl.createSyncPolicyTable();
                    syncPolicyDAOImpl.createInclusionsTable();
                    syncPolicyDAOImpl.createShareTable();
                    backupPolicyDAOImpl.createEBMSTable();
                    backupPolicyDAOImpl.createPrivacyGatewayTable();
                    if (response.getSyncPolicyElement() != null) {
                        PolicyManagementServerHelper.createSyncPolicyAndChildDetails((SyncPolicyDAOImpl)syncPolicyDAOImpl, (SyncPolicyTo)new SyncPolicyTo(), (SyncPolicyElement)response.getSyncPolicyElement());
                    } else {
                        this.showFailedToRegisterMessageBox(RegistrationLiterals.DEVICE_REGISTRATION_ERROR_TITLE, "No policy mapped to user.\nPlease contact administrator");
                        this.closeShell();
                        return;
                    }
                }
                if (!SILENT.equalsIgnoreCase(BluSyncLauncher.isSilent)) {
                    this.showFolderSelectionPage(rs.getPrefferedPort());
                } else {
                    SettingHelper.setParabluSyncFolder((String)this.folderPath);
                    SettingHelper.applyChangesToSharedPreferences((boolean)true);
                }
                PropertyHelper.changeConfigProperty((String)"decoupled", (String)"false", (int)1);
                this.logger.debug("closed registration uI");
            }
        }
        catch (Exception e) {
            this.showFailedToRegisterMessageBox("Access Error", "No policy mapped to user.\nPlease contact administrator");
            this.closeShell();
            this.logger.error("Exception occurred during connection to cloud ", (Throwable)e);
            this.logger.trace("" + e);
            return;
        }
    }

    private boolean authenticateDeviceCertificate(CloudRegistrationUtility rs) {
        boolean validity = true;
        try {
            this.logger.debug("Checking device cert auth.......");
            boolean isDeviceCertValid = rs.checkDeviceCertAuthentication(BluSyncLauncher.certName);
            if (!isDeviceCertValid) {
                this.logger.debug("certAuthentication Error");
                this.showFailedToRegisterMessageBox("DCM Authentication Error", "Device authentication failed for your machine.\nPlease contact administrator");
                this.closeShell();
                validity = false;
            }
        }
        catch (Exception exception) {
            this.logger.trace("" + exception);
            this.logger.error("certAuthentication Error" + exception.getMessage());
            this.showFailedToRegisterMessageBox("DCM Authentication Error", "Device authentication failed for your machine.\nPlease contact administrator");
            this.closeShell();
            validity = false;
        }
        return validity;
    }

    private int decipherResponseTo(DeviceRegTo response, CloudRegistrationUtility rs) {
        if (response.getStatus() != 30 && response.getStatus() != 409 && response.getStatus() != 1019) {
            if (response.getStatus() == 1014) {
                this.logger.debug("Registering device failed due to NO_NETWORK");
                this.showFailedToRegisterMessageBox("Network Error", "Device seems to be offline.Please check your internet connection and try again.");
            } else if (response.getStatus() == 8) {
                if (SILENT.equalsIgnoreCase(BluSyncLauncher.isSilent)) {
                    this.startUIAfterDecoupledAndIfSilent();
                } else {
                    this.logger.debug("registering device failed due to USERNAME_PASSWORD_AUTHENTHICATION_FAILED");
                    this.showFailedToRegisterMessageBox("Authentication Error: Invalid credentials", "Please check your login credentials and try again.");
                }
            } else if (response.getStatus() == 1001) {
                this.logger.debug("registering device failed due to DEVICE_LIMIT_EXCEEDED");
                this.showFailedToRegisterMessageBox("Device Limit Reached", RegistrationLiterals.DEVICE_LIMIT_EXCEEDED_ERROR_MESSAGE, response.getPolicyName(), response.getDeviceList());
            } else if (response.getStatus() == 1005) {
                this.logger.debug("registering device failed due to LICENSE_EXPIRED");
                this.showFailedToRegisterMessageBox("License Expired", "The license for this Parablu Installation has expired.");
            } else if (response.getStatus() == 426) {
                this.logger.debug("registering device failed due to HTTP_CONFLICTING_DEVICE");
                this.showFailedToRegisterMessageBox("Registration Failed", "A device with the same name already exists.\n Please enter a different name");
            } else if (response.getStatus() == 425) {
                this.logger.debug("registering device failed due to HTTP_AUTO_SYNC_BACKUP_DISABLED");
                this.showFailedToRegisterMessageBox("Registration Failed", PropertyHelper.USER_SYNC_BACK_DISABLED_ERROR_MESSAGE);
            } else if (response.getStatus() == 3) {
                this.logger.debug("registering device failed due to DEVICE_UNAUTHORIZED_CONNECTION");
                this.showFailedToRegisterMessageBox("Device Blocked", RegistrationLiterals.DEVICE_BLOCKED_ERROR_MESSAGE);
            } else if (response.getStatus() == 120) {
                this.logger.debug("registering device failed due to USER_NO_CLOUDS_ATTACHED");
                this.showFailedToRegisterMessageBox("Error:Login Failed", RegistrationLiterals.NO_CLOUDS_ATTACHED_ERROR_MESSAGE);
            } else if (response.getStatus() == 403) {
                this.logger.debug("Registering device failed due to OPERATION_FORBIDDEN_MESSAGE");
                this.showFailedToRegisterMessageBox("Access Error", "You don\u2019t have permission to do this operation. \nPlease contact your administrator.");
            } else if (response.getStatus() == 1012) {
                this.logger.debug("Registering device failed due to SERVICE_UNAVAILABLE");
                this.showFailedToRegisterMessageBox("Server Error", "Service is unavailable.\nPlease contact administrator");
            } else if (response.getStatus() == 901) {
                this.logger.debug("Registering device failed due to USER_POLICY_NOT_AVAILABLE");
                this.showFailedToRegisterMessageBox("Access Error", "No policy mapped to user.\nPlease contact administrator");
            } else if (response.getStatus() == 1015) {
                int res = this.checkForConfirmation("Parablu Device Registration", "This device is already registered with at least one other user.\nAre you sure you wish to continue?");
                deviceRegistryResponse = 0;
                if (res == 1) {
                    return 65;
                }
                this.logger.debug("Registering device failed due to HTTP_DEVICE_WITH_MULTIPLE_USER");
                System.exit(0);
            } else if (response.getStatus() == 1017) {
                int res = this.checkForConfirmation("Parablu Device Registration", "This device is already registered with at least one other user.\nAre you sure you wish to continue?");
                deviceRegistryResponse = 0;
                if (res == 1) {
                    int res1 = this.checkForConfirmation("Parablu Device Registration", "Your user name is already registered with at least one other device.\nAre you sure you wish to continue?");
                    deviceRegistryResponse = 0;
                    if (res1 == 1) {
                        return 65;
                    }
                    this.logger.debug("Registering device failed due to Multiple user and Device registration");
                    System.exit(0);
                } else {
                    this.logger.debug("Registering device failed due to Multiple user and Device registration");
                    System.exit(0);
                }
            } else if (response.getStatus() == 1018) {
                int res = this.checkForConfirmation("Parablu Device Registration", "Your user name is already registered with at least one other device.\nAre you sure you wish to continue?");
                deviceRegistryResponse = 0;
                if (res == 1) {
                    return 65;
                }
                this.logger.debug("Registering device failed due to Multiple Device registration");
                System.exit(0);
            } else if (response.getStatus() == 1016) {
                this.logger.debug("Registering device failed due to AAD_CREDENTIALS_NOT_FOUND");
                this.showFailedToRegisterMessageBox("Access Error", "No policy mapped to user.\nPlease contact administrator");
            } else if (response.getStatus() == 1020) {
                this.logger.debug("Registering device failed due to CREDENTIALS_NOT_FOUND");
                this.showFailedToRegisterMessageBox("Access Error", "This username/password combination is not recognized.\n Please contact your Administrator");
            } else if (response.getStatus() == 1021) {
                int res = this.checkForConfirmation("Parablu Device Registration", "Your user name is already registered with the same device.\nAre you sure you wish to continue?");
                deviceRegistryResponse = 0;
                if (res == 1) {
                    return 66;
                }
                this.logger.debug("Registering device failed due to alredy token exists");
                System.exit(0);
            } else {
                this.logger.debug("registering device failed due to undefined exception ");
                this.showFailedToRegisterMessageBox(RegistrationLiterals.DEVICE_REGISTRATION_ERROR_TITLE, PropertyHelper.DEVICE_REGISTRATION_ERROR_MESSAGE);
            }
            return 0;
        }
        if (response.getStatus() == 409) {
            this.logger.debug("another device is already registered");
            return 64;
        }
        if (response.getStatus() == 1019) {
            this.logger.debug("Bad login type login..");
            loginType = "AAD";
            return 68;
        }
        try {
            SettingHelper.createTokenFile((CloudRegistrationUtility)rs);
        }
        catch (Exception exception) {
            this.logger.trace("" + exception);
            this.logger.error(" exception in creating token..." + exception.getMessage());
            this.showFailedToRegisterMessageBox(RegistrationLiterals.DEVICE_REGISTRATION_ERROR_TITLE, " Cloud name is not mapped to your Account");
            return 0;
        }
        SettingHelper.refresh();
        SettingHelper.setLocalIpAddress((String)rs.getCloudLocalIP());
        SettingHelper.setPublicIpAddress((String)rs.getCloudPublicIP());
        SettingHelper.setCloudName((String)response.getCloudName());
        SettingHelper.setUserName((String)rs.getUserName());
        SettingHelper.setGaeLocalIpAddress((String)rs.getGaeCloudLocalIP());
        SettingHelper.setCurrentCloudIpAddress((String)rs.getPrefferedIP());
        ProxyElement.setIp((String)rs.getPrefferedIP());
        SettingHelper.setDeviceName((String)response.getDeviceRegistrationElement().getDeviceElement().getDeviceName());
        return 1;
    }

    private void showShell() {
        this.logger.debug(SHELL_CLOSE_STR);
        if (this.display == null) {
            this.logger.debug(DISPLAY_NULL);
            return;
        }
        Runnable runnable = () -> {
            if (this.compositeForGif != null && !this.compositeForGif.isDisposed()) {
                this.compositeForGif.setVisible(true);
            }
        };
        this.display.asyncExec(runnable);
    }

    private void disposeRegistrationView() {
        this.parentComposite.getShell().dispose();
    }

    private void showFolderSelectionPage(Integer port) {
        if (this.display == null) {
            this.logger.debug("showFolderSelectionPage; Display is null");
            return;
        }
        Runnable runnable = () -> this.showCustomiseParabluFolderShell(port);
        this.display.asyncExec(runnable);
    }

    public void hideShell() {
        this.logger.debug(SHELL_CLOSE_STR);
        if (this.display == null) {
            this.logger.debug("hideShell; Display is null");
            return;
        }
        Runnable runnable = () -> {
            if (this.compositeForGif != null && !this.compositeForGif.isDisposed()) {
                this.compositeForGif.setVisible(false);
            }
        };
        this.display.asyncExec(runnable);
    }

    public void closeShell() {
        this.logger.debug(SHELL_CLOSE_STR);
        if (this.display == null) {
            this.logger.debug("closeShell; Display is null");
            return;
        }
        Runnable runnable = () -> {
            if (this.compositeForGif != null) {
                this.disposeProgressBUIAndChangeTopControl();
                this.registrationPanelForInputTexts.setParent(this.parentComposite);
                this.parentStackLayout.topControl = this.registrationPanelForInputTexts;
                this.parentComposite.layout();
            }
        };
        this.display.asyncExec(runnable);
    }

    private void showErrorMessageBoxForFailure(String value, String messgae) {
        if (this.display == null) {
            this.logger.debug(DISPLAY_NULL);
            return;
        }
        Runnable runnable = () -> {
            if (this.compositeForGif != null) {
                this.disposeProgressBUIAndChangeTopControl();
                this.registrationPanelForInputTexts.setParent(this.parentComposite);
                this.parentStackLayout.topControl = this.registrationPanelForInputTexts;
                this.parentComposite.layout();
            }
            MessageBox dialog = new MessageBox(this.parentComposite.getShell(), 32);
            dialog.setText(value);
            dialog.setMessage(messgae);
            dialog.open();
            this.setLoginButtonEnableOrDisable(true);
        };
        this.display.asyncExec(runnable);
    }

    private int showFailedToRegisterMessageBox(String value, String messgae) {
        if (this.display == null) {
            this.logger.debug("Display is null in show Failed To Register Message Box....; ");
            this.display = new Display();
            this.logger.debug("Display is null in show Failed To Register Message Box....; ");
        }
        this.result = -5000;
        Runnable runnable = () -> {
            MessageBox dialog = new MessageBox(this.parentComposite.getShell(), 32);
            dialog.setText(value);
            dialog.setMessage(messgae);
            this.result = dialog.open();
            this.setLoginButtonEnableOrDisable(true);
        };
        this.display.asyncExec(runnable);
        return this.result;
    }

    private int showFailedToRegisterMessageBox(String value, String message, String policyName, String deviceList) {
        if (this.display == null) {
            this.logger.debug("Display is null in show Failed To Register Message Box....; ");
            this.display = new Display();
            this.logger.debug("Display is null in show Failed To Register Message Box....; ");
        }
        this.result = -5000;
        Runnable runnable = () -> {
            MessageBox dialog = new MessageBox(this.parentComposite.getShell(), 40);
            String text = message + "\nUser mapped to the " + policyName + " Policy\nUser Alredy registered with " + deviceList + " device(s)";
            dialog.setText(value);
            dialog.setMessage(text);
            this.result = dialog.open();
            this.setLoginButtonEnableOrDisable(true);
        };
        this.display.asyncExec(runnable);
        return this.result;
    }

    protected void launchParaBluButton() {
        this.pageDescription.setText("");
        this.registerButton.setEnabled(true);
        this.registerButton.setText("Launch Client");
        this.registerButton.removeSelectionListener((SelectionListener)this.registerSelectionAdapter);
        this.registerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SettingHelper.setParabluSyncFolder((String)ProgressBarPaneView.this.folderPath);
                SettingHelper.applyChangesToSharedPreferences((boolean)true);
                ProgressBarPaneView.this.disposeAllFontsAndImages();
                ProgressBarPaneView.this.disposeRegistrationView();
            }
        });
        this.registerButton.getParent().layout();
        this.parentComposite.layout();
    }

    protected void showFinishButton() {
        this.pageDescription.setText("");
        this.registerButton.setEnabled(true);
        this.registerButton.setText("Launch Client");
        this.registerButton.removeSelectionListener((SelectionListener)this.registerSelectionAdapter);
        this.registerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SettingHelper.initiateAndCreateDatabases();
                SettingHelper.setParabluSyncFolder((String)ProgressBarPaneView.this.folderPath);
                File baseParabluFolder = new File(ProgressBarPaneView.this.folderPath + DEFAULT_PARABLU_NAME);
                if (!baseParabluFolder.mkdirs() && !baseParabluFolder.isDirectory()) {
                    MessageBox messageBox = new MessageBox(ProgressBarPaneView.this.parentComposite.getShell());
                    messageBox.setText("Folder creation failed");
                    messageBox.setMessage("Failed to create folder, choose a different path");
                    messageBox.open();
                    return;
                }
                SettingHelper.applyChangesToSharedPreferences((boolean)true);
                ProgressBarPaneView.this.disposeAllFontsAndImages();
                ProgressBarPaneView.this.disposeRegistrationView();
            }
        });
        this.registerButton.getParent().layout();
        this.parentComposite.layout();
    }

    protected void setLoginButtonEnableOrDisable(boolean value) {
        this.registerButton.setEnabled(value);
        if (value) {
            this.pageDescription.setText("");
            this.pageDescription.setText(PropertyHelper.REGVIEWPROGRESS_CONNECTING_LABEL);
        } else {
            this.pageDescription.setText("");
            this.pageDescription.setText(PropertyHelper.REGVIEW_CONNECT_TO_LABEL);
        }
        this.registerButton.getParent().layout();
    }

    public void loadUI() {
        try {
            if (this.parentComposite.getDisplay() == null) {
                this.logger.debug("loadUI; Dispay was null");
                this.display = new Display();
            } else {
                this.display = !this.parentComposite.getDisplay().isDisposed() ? this.parentComposite.getDisplay() : new Display();
            }
            Runnable runnable = () -> this.startRegistrationProgressShell();
            this.display.asyncExec(runnable);
        }
        catch (Exception e) {
            this.logger.error("Exception in loadUI: ", (Throwable)e);
        }
    }

    protected void prepopulateMediaDBWithDefaultFolders() {
        this.logger.debug("entering prepopulateMediaDBWithDefaultFolders");
        MediaFolderDAOImpl mediaFolderDAOImpl = new MediaFolderDAOImpl(SettingHelper.getMediaDbUrl());
        if (!mediaFolderDAOImpl.checkIfTableIsEmpty()) {
            this.logger.debug("returning from prepopulateMediaDBWithDefaultFolders");
            return;
        }
        String[] mediaTypes = new String[]{"Music", "Picture", "Video"};
        HashMap<String, CallSite> aMap = new HashMap<String, CallSite>();
        aMap.put("Music", (CallSite)((Object)(SettingHelper.getUserHome() + StringLiterals.FILE_SEPARATOR + "Music")));
        aMap.put("Picture", (CallSite)((Object)(SettingHelper.getUserHome() + StringLiterals.FILE_SEPARATOR + "Pictures")));
        aMap.put("Video", (CallSite)((Object)(SettingHelper.getUserHome() + StringLiterals.FILE_SEPARATOR + "videos")));
        for (String mediaType : mediaTypes) {
            MediaFolderTO mediaFolderTO = new MediaFolderTO();
            mediaFolderTO.setFolderPath((String)aMap.get(mediaType));
            mediaFolderTO.setLastSyncTime(0L);
            mediaFolderTO.setMediaType(mediaType);
            mediaFolderDAOImpl.removeAParentFolder(mediaFolderTO);
            mediaFolderDAOImpl.insertAParentFolder(mediaFolderTO);
        }
    }

    private void startRegistrationProgressShell() {
        try {
            if (this.fontsManager == null) {
                this.fontsManager = new FontsManager(this.display);
            }
            this.compositeForGif = new Composite(this.parentComposite, 0);
            this.mainTextPanel = new Composite(this.compositeForGif, 4);
            GridLayout mainPanelGridLayout = new GridLayout();
            mainPanelGridLayout.numColumns = 1;
            mainPanelGridLayout.marginLeft = 90;
            mainPanelGridLayout.marginHeight = 20;
            mainPanelGridLayout.marginBottom = 5;
            this.mainTextPanel.setLayout((Layout)mainPanelGridLayout);
            GridData mainPanelGridData = new GridData(768);
            this.mainTextPanel.setLayoutData((Object)mainPanelGridData);
            this.mainTextPanel.setBackgroundMode(1);
            this.pageDescription = new Label(this.mainTextPanel, 4);
            this.pageDescription.setText(PropertyHelper.REGVIEW_CONNECT_TO_LABEL);
            this.pageDescription.setFont(this.fontsManager.getLargeNormalFont());
            this.pageDescription.setLayoutData((Object)new GridData(768));
            GridLayout shellGridLayout = new GridLayout();
            shellGridLayout.marginTop = 0;
            shellGridLayout.marginHeight = 0;
            shellGridLayout.marginLeft = 0;
            shellGridLayout.marginWidth = 0;
            shellGridLayout.verticalSpacing = 20;
            this.compositeForGif.setBackgroundMode(1);
            this.compositeForGif.setLayout((Layout)shellGridLayout);
            this.compositeForGif.setLayoutData((Object)new GridData());
            this.generateGif();
            this.parentStackLayout.topControl = this.compositeForGif;
            this.parentComposite.layout();
        }
        catch (Exception e) {
            this.logger.error("Exception occured in startRegistrationProgressShell: " + e);
        }
    }

    private void showCustomiseParabluFolderShell(Integer port) {
        if (this.fontsManager == null) {
            this.fontsManager = new FontsManager(this.display);
        }
        if (this.tickImage == null) {
            this.tickImageData = new ImageData(MacSettingsHelper.baseResourceFolder + SyncConstants.CONSTANTS_TICK_IMAGE_URL);
            this.tickImage = new Image((Device)this.display, this.tickImageData);
        }
        this.compositeForFolderLocation = new Composite(this.parentComposite, 0x1000000);
        GridLayout compositeForFolderLocationGridLayout = new GridLayout();
        compositeForFolderLocationGridLayout.marginTop = 10;
        compositeForFolderLocationGridLayout.marginHeight = 0;
        compositeForFolderLocationGridLayout.marginWidth = 0;
        compositeForFolderLocationGridLayout.verticalSpacing = 10;
        compositeForFolderLocationGridLayout.marginBottom = 0;
        compositeForFolderLocationGridLayout.marginLeft = 10;
        compositeForFolderLocationGridLayout.numColumns = 2;
        compositeForFolderLocationGridLayout.makeColumnsEqualWidth = false;
        this.compositeForFolderLocation.setBackgroundMode(1);
        this.compositeForFolderLocation.setLayout((Layout)compositeForFolderLocationGridLayout);
        this.compositeForFolderLocation.setLayoutData((Object)new GridData(1808));
        this.chooseFolderImage = new Label(this.compositeForFolderLocation, 256);
        this.chooseFolderImage.setImage(this.tickImage);
        this.chooseFolderImage.setLayoutData((Object)new GridData());
        this.chooseFolderDescriptionLabel = new Label(this.compositeForFolderLocation, 320);
        this.chooseFolderDescriptionLabel.setLayoutData((Object)new GridData(768));
        this.chooseFolderDescriptionLabel.setText(PropertyHelper.REGVIEWPROGRESS_SUCCESSFULL_LABEL);
        this.chooseFolderDescriptionLabel.setFont(this.fontsManager.getLargeNormalFont());
        this.compositeForFolderGroups = new Composite(this.compositeForFolderLocation, 0x1000000);
        GridLayout compositeForFolderGroupsGridLayout = new GridLayout();
        compositeForFolderGroupsGridLayout.marginTop = 20;
        compositeForFolderGroupsGridLayout.marginHeight = 0;
        compositeForFolderGroupsGridLayout.marginWidth = 0;
        compositeForFolderGroupsGridLayout.verticalSpacing = 5;
        compositeForFolderGroupsGridLayout.marginLeft = 10;
        compositeForFolderGroupsGridLayout.numColumns = 2;
        compositeForFolderGroupsGridLayout.makeColumnsEqualWidth = false;
        this.compositeForFolderGroups.setBackgroundMode(1);
        this.compositeForFolderGroups.setLayout((Layout)compositeForFolderGroupsGridLayout);
        GridData compositeForFolderGroupsGridData = new GridData(1808);
        compositeForFolderGroupsGridData.horizontalSpan = 2;
        this.compositeForFolderGroups.setLayoutData((Object)compositeForFolderGroupsGridData);
        this.currentFolderSelectPanel = new Group(this.compositeForFolderGroups, 0x1000000);
        if (SettingHelper.getSyncLicenced().contentEquals("false")) {
            this.currentFolderSelectPanel.setVisible(false);
        }
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginTop = 10;
        gridLayout.marginLeft = 10;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginBottom = 10;
        gridLayout.numColumns = 2;
        gridLayout.horizontalSpacing = 10;
        gridLayout.verticalSpacing = 10;
        GridData currentFolderSelectPanelData = new GridData(768);
        currentFolderSelectPanelData.horizontalSpan = 2;
        this.currentFolderSelectPanel.setLayout((Layout)gridLayout);
        this.currentFolderSelectPanel.setLayoutData((Object)currentFolderSelectPanelData);
        this.chooseFolderDefaultLabel = new Label((Composite)this.currentFolderSelectPanel, 320);
        GridData chooseFolderDefaultLabelGridData = new GridData();
        chooseFolderDefaultLabelGridData.horizontalSpan = 2;
        this.chooseFolderDefaultLabel.setLayoutData((Object)chooseFolderDefaultLabelGridData);
        this.chooseFolderDefaultLabel.setText(PropertyHelper.REGVIEWPROGRESS_CONFIGURE_FOLDER_LABEL);
        this.chooseFolderDefaultLabel.setFont(this.fontsManager.getMediumNormalFont());
        this.currentFolderSelectedText = new Text((Composite)this.currentFolderSelectPanel, 2048);
        GridData currentFolderSelectedTextGridData = new GridData();
        currentFolderSelectedTextGridData.widthHint = this.parentComposite.getSize().x / 2;
        this.currentFolderSelectedText.setLayoutData((Object)currentFolderSelectedTextGridData);
        this.currentFolderSelectedText.setText(this.folderPath + DEFAULT_PARABLU_NAME);
        this.currentFolderSelectedText.setEditable(false);
        this.browseButton = new Button((Composite)this.currentFolderSelectPanel, 8);
        this.browseButton.setText("Browse");
        this.browseButton.setFocus();
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DirectoryDialog directoryDialog = new DirectoryDialog(ProgressBarPaneView.this.compositeForFolderLocation.getShell());
                directoryDialog.setFilterPath(SettingHelper.getUserHome());
                directoryDialog.setMessage("Please select a folder");
                directoryDialog.setText("Folder Selection");
                ProgressBarPaneView.this.folderPath = directoryDialog.open();
                if (ProgressBarPaneView.this.folderPath == null) {
                    ProgressBarPaneView.this.folderPath = DEFAULT_FOLDER_NAME;
                }
                ProgressBarPaneView.this.currentFolderSelectedText.setText(new File(ProgressBarPaneView.this.folderPath + DEFAULT_PARABLU_NAME).getAbsolutePath());
                ProgressBarPaneView.this.parentComposite.getShell().layout();
            }
        });
        this.helpTextPanel = new Composite((Composite)this.currentFolderSelectPanel, 0x1000000);
        GridLayout helpTextPanelGridLayout = new GridLayout();
        helpTextPanelGridLayout.marginTop = 0;
        helpTextPanelGridLayout.verticalSpacing = 0;
        helpTextPanelGridLayout.marginHeight = 0;
        this.helpTextPanel.setLayout((Layout)helpTextPanelGridLayout);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.helpTextPanel.setLayoutData((Object)gridData);
        this.helpTextLabel = new Label(this.helpTextPanel, 320);
        GridData helpTextLabelGridData = new GridData(512);
        this.helpTextLabel.setLayoutData((Object)helpTextLabelGridData);
        this.helpTextLabel.setText("Please choose the folder to store the synchronized files. The current location of the folder is shown above.  We recommend that you choose a different location.");
        this.helpTextLabel.setFont(this.fontsManager.getMediumNormalFont());
        if (SettingHelper.getBackupLicenced().contentEquals(FORCE_REGISTRATION)) {
            backupAdapter = new BackupAdapter(SettingHelper.getCloudName(), SettingHelper.getKeystorePath());
            FileListElement listBackedUpFolders = new FileListElement();
            try {
                listBackedUpFolders = backupAdapter.getListOfBackedUpFolders(SettingHelper.getCurrentCloudIpAddress(), port, SettingHelper.readTokenFromFile());
            }
            catch (Exception e) {
                this.logger.debug("Exception", (Throwable)e);
            }
            List listFileElement = listBackedUpFolders.getFileElementList();
            if (!listFileElement.isEmpty()) {
                this.renderPreconfiguredBackupGroup();
            }
        }
        if (SettingHelper.getSyncLicenced().contentEquals(FORCE_REGISTRATION)) {
            this.showFinishButton();
        } else if (SettingHelper.getSyncLicenced().contentEquals("false") && SettingHelper.getBackupLicenced().contentEquals(FORCE_REGISTRATION)) {
            this.launchParaBluButton();
        } else if (SettingHelper.getSyncLicenced().contentEquals("false") && SettingHelper.getBackupLicenced().contentEquals("false")) {
            this.showInactiveButton();
        }
        this.parentStackLayout.topControl = this.compositeForFolderLocation;
        this.parentComposite.layout();
    }

    private void renderPreconfiguredBackupGroup() {
        Group preconfiguredBackupGroup = new Group(this.compositeForFolderGroups, 0);
        GridLayout preconfiguredBackupGridLayout = new GridLayout();
        preconfiguredBackupGridLayout.marginTop = 0;
        preconfiguredBackupGridLayout.marginLeft = 2;
        preconfiguredBackupGridLayout.marginWidth = 3;
        preconfiguredBackupGridLayout.marginHeight = 0;
        preconfiguredBackupGridLayout.marginBottom = 0;
        preconfiguredBackupGridLayout.numColumns = 1;
        preconfiguredBackupGridLayout.horizontalSpacing = 20;
        preconfiguredBackupGridLayout.verticalSpacing = 10;
        GridData preconfiguredBackupData = new GridData(768);
        preconfiguredBackupData.horizontalSpan = 2;
        preconfiguredBackupGroup.setLayout((Layout)preconfiguredBackupGridLayout);
        preconfiguredBackupGroup.setLayoutData((Object)preconfiguredBackupData);
        Label preconfiguredBackupLabel = new Label((Composite)preconfiguredBackupGroup, 320);
        GridData preconfiguredBackupLabelGrid = new GridData(768);
        preconfiguredBackupLabelGrid.widthHint = this.parentComposite.getSize().x / 3 * 2;
        preconfiguredBackupLabel.setLayoutData((Object)preconfiguredBackupLabelGrid);
        preconfiguredBackupLabel.setText("You have previously configured folders for backup. These folders have been added to your backup list. If you wish to edit them, then please click on the link provided.");
        Link preconfiguredBackupLink = new Link((Composite)preconfiguredBackupGroup, 0);
        preconfiguredBackupLink.setLayoutData((Object)new GridData());
        preconfiguredBackupLink.setText("<a>Pre-Configured Folders</a>");
        preconfiguredBackupLink.setFont(this.fontsManager.getSmallNormalFont());
        Listener listener = event -> {
            try {
                SettingHelper.initiateAndCreateDatabases();
                BackupManagerView backupManagerView = new BackupManagerView(this.parentComposite.getShell());
                backupManagerView.open();
            }
            catch (Exception e) {
                this.logger.debug("Exception", (Throwable)e);
            }
        };
        preconfiguredBackupLink.addListener(13, listener);
    }

    private void showInactiveButton() {
        this.pageDescription.setText("");
        this.registerButton.setEnabled(false);
        this.registerButton.setText("No Licenses");
        this.registerButton.removeSelectionListener((SelectionListener)this.registerSelectionAdapter);
        this.registerButton.getParent().layout();
    }

    protected void disposeProgressBUIAndChangeTopControl() {
        if (this.compositeForGif == null) {
            return;
        }
        this.disposeAllFontsAndImages();
        this.registrationPanelForInputTexts.setParent(this.parentComposite);
        this.parentStackLayout.topControl = this.registrationPanelForInputTexts;
        this.parentComposite.layout();
    }

    private void disposeAllFontsAndImages() {
        if (this.canvas != null && !this.canvas.isDisposed()) {
            this.canvas.dispose();
        }
        if (this.image != null && !this.image.isDisposed()) {
            this.image.dispose();
        }
        if (this.tickImage != null && !this.tickImage.isDisposed()) {
            this.tickImage.dispose();
        }
        this.fontsManager.disposeFonts();
    }

    private void generateGif() {
        this.loader = new ImageLoader();
        this.logger.debug(PARABLU_SEARCHING_GIF);
        try {
            this.loader.load((InputStream)new FileInputStream(PARABLU_SEARCHING_GIF));
            this.canvas = new Canvas(this.compositeForGif, 0);
            GridData gd = new GridData();
            gd.heightHint = 180;
            gd.widthHint = 400;
            this.canvas.setLayoutData((Object)gd);
            this.canvas.setBackgroundMode(1);
            this.image = new Image((Device)this.display, this.loader.data[0]);
            PaintListener paintListener = event -> {
                if (!this.image.isDisposed()) {
                    event.gc.drawImage(this.image, 0, 0);
                }
            };
            this.canvas.addPaintListener(paintListener);
            this.gifUpdaterThread = new Thread(new GIFRunnable());
            this.connectingLabel = new Label(this.compositeForGif, 0x1000000);
            this.connectingLabel.setText(PropertyHelper.REGVIEWPROGRESS_CONNECTING_LABEL);
            this.connectingLabel.setLayoutData((Object)new GridData(1808));
            this.connectingLabel.setFont(this.fontsManager.getLargeNormalFont());
        }
        catch (FileNotFoundException e) {
            this.logger.error("FileNotFoundException for PARABLU_SEARCHING_GIF: ", (Throwable)e);
        }
    }

    public synchronized void update(int value) {
        switch (value) {
            case 0: {
                this.showSearchingGif();
                break;
            }
            case 1: {
                this.continueSearchDisplay = false;
                this.showValidatingUserImage();
                break;
            }
        }
    }

    private void startUIAfterDecoupledAndIfSilent() {
        BluSyncLauncher.isSilent = "false";
        RegistrationView regview = new RegistrationView();
        regview.loadRegistrationUI();
        this.logger.debug("Registration complete");
        try {
            if (SettingHelper.readTokenFromFile() != null && SettingHelper.getCloudName() != null && SettingHelper.getParabluSyncFolder() != null) {
                this.logger.debug("inside RegView part");
                BluSyncLauncher.startUI();
            }
        }
        catch (Exception e) {
            this.logger.trace("" + e);
            this.logger.error(" exception in reading token..." + e.getMessage());
        }
    }

    private void showSearchingGif() {
        if (this.display == null) {
            return;
        }
        Runnable runnable = () -> {
            this.connectingLabel.setText("");
            this.connectingLabel.setText(PropertyHelper.REGVIEWPROGRESS_CONNECTING_LABEL);
            if (this.gifUpdaterThread != null) {
                this.gifUpdaterThread.start();
            } else {
                this.logger.debug("The thread is :" + this.gifUpdaterThread);
            }
        };
        this.display.asyncExec(runnable);
    }

    private void showValidatingUserImage() {
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        Runnable runnable = () -> {
            this.connectingLabel.setText("");
            this.connectingLabel.setText("Validating credentials...");
            if (!this.display.isDisposed()) {
                this.image.dispose();
                this.image = new Image((Device)this.display, MacSettingsHelper.baseResourceFolder + SyncConstants.VALIDATE_IMAGE);
            }
            if (this.compositeForGif != null && !this.compositeForGif.isDisposed() && !this.canvas.isDisposed()) {
                this.canvas.redraw();
            }
        };
        this.display.asyncExec(runnable);
    }

    public int checkForConfirmation(final String value, final String message) {
        try {
            deviceRegistryResponse = 0;
            if (SILENT.equalsIgnoreCase(BluSyncLauncher.isSilent)) {
                if (this.display1 == null) {
                    this.display1 = new Display();
                }
                silentShell = new Shell(this.display1, 128);
                GridLayout shellGridLayout = new GridLayout();
                GridData shellGridData = new GridData();
                ImageData registrationImageData = new ImageData(MacSettingsHelper.baseResourceFolder + SyncConstants.PARABLU_NAMED_IMAGE);
                this.registrationImage = new Image((Device)this.display, registrationImageData.scaledTo(72, 72));
                silentShell.setImage(this.registrationImage);
                silentShell.setText(PropertyHelper.REGVIEW_APPNAME);
                silentShell.setSize(silentShell.getSize());
                int xAxisLocation = ProgressBarPaneView.silentShell.getDisplay().getClientArea().width / 2 - 150;
                int yAxisLocation = ProgressBarPaneView.silentShell.getDisplay().getClientArea().height / 2 - 150;
                silentShell.setLocation(xAxisLocation, yAxisLocation);
                silentShell.setBackgroundMode(1);
                silentShell.setLayout((Layout)shellGridLayout);
                silentShell.setLayoutData((Object)shellGridData);
                silentShell.setSize(300, 335);
                GridLayout panelGridLayout = new GridLayout();
                GridLayout panelGridLayoutForMessage = new GridLayout();
                GridData registrationPanelGridData = new GridData(1808);
                panelGridLayout.marginLeft = 10;
                panelGridLayout.marginRight = 0;
                panelGridLayout.numColumns = 1;
                panelGridLayout.marginTop = 0;
                panelGridLayoutForMessage.numColumns = 2;
                panelGridLayoutForMessage.makeColumnsEqualWidth = false;
                panelGridLayoutForMessage.marginLeft = 0;
                panelGridLayoutForMessage.verticalSpacing = 15;
                panelGridLayoutForMessage.marginHeight = 4;
                panelGridLayoutForMessage.horizontalSpacing = 60;
                panelGridLayoutForMessage.marginTop = 0;
                Composite messagePanel = new Composite((Composite)silentShell, 0x1000000);
                messagePanel.setLayoutData((Object)new GridData(1808));
                messagePanel.setLayout((Layout)panelGridLayout);
                registrationPanelGridData.minimumWidth = 350;
                registrationPanelGridData.minimumHeight = 10;
                messagePanel.setLayoutData((Object)registrationPanelGridData);
                Composite compositeForHeading = new Composite(messagePanel, 16384);
                GridLayout textLayout = new GridLayout();
                textLayout.numColumns = 1;
                compositeForHeading.setLayout((Layout)textLayout);
                Label conf = new Label(compositeForHeading, 16385);
                conf.setText(value);
                FontData[] fD = conf.getFont().getFontData();
                fD[0].setHeight(9);
                conf.setFont(new Font((Device)silentShell.getDisplay(), fD[0]));
                conf.setFont(new Font(null, "Times New Roman", 12, 1));
                conf.setEnabled(true);
                Group registrationPanelForMessage = new Group(messagePanel, 4);
                registrationPanelForMessage.setText(value);
                GridLayout registrationPanelForMessageGridLayout = new GridLayout();
                registrationPanelForMessageGridLayout.marginLeft = 0;
                registrationPanelForMessageGridLayout.marginWidth = 0;
                registrationPanelForMessageGridLayout.marginRight = 0;
                registrationPanelForMessageGridLayout.marginTop = 20;
                registrationPanelForMessageGridLayout.marginBottom = 10;
                registrationPanelForMessage.setLayout((Layout)registrationPanelForMessageGridLayout);
                Composite compositeForDeatils = new Composite((Composite)registrationPanelForMessage, 16384);
                GridLayout deatilsLayout = new GridLayout();
                deatilsLayout.numColumns = 1;
                deatilsLayout.makeColumnsEqualWidth = false;
                deatilsLayout.marginTop = 10;
                deatilsLayout.horizontalSpacing = 10;
                deatilsLayout.marginRight = 10;
                deatilsLayout.verticalSpacing = 0;
                compositeForDeatils.setLayout((Layout)deatilsLayout);
                messageLabel = new Label(compositeForDeatils, 4);
                messageLabel.setText(message);
                messageLabel.setToolTipText("");
                Composite buttonComposite = new Composite((Composite)silentShell, 0x1000000);
                GridLayout buttonLayout = new GridLayout();
                buttonLayout.numColumns = 2;
                buttonLayout.marginTop = 15;
                buttonLayout.marginLeft = 50;
                buttonLayout.marginBottom = 15;
                buttonComposite.setLayout((Layout)buttonLayout);
                buttonComposite.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
                Color backgroundColor = this.display1.getSystemColor(1);
                silentShell.setBackground(backgroundColor);
                GridData buttonData = new GridData(131072, 0x1000000, true, false);
                buttonData.widthHint = 100;
                Button yesButton = new Button(buttonComposite, 8);
                yesButton.setText(" Yes ");
                yesButton.setLayoutData((Object)buttonData);
                yesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        System.out.println("aaaaaaaaaaa");
                        deviceRegistryResponse = 1;
                        silentShell.dispose();
                    }
                });
                Button noButton = new Button(buttonComposite, 8);
                noButton.setVisible(false);
                noButton.setText(" No ");
                noButton.setLayoutData((Object)buttonData);
                noButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        System.out.println("bbbbbbbb");
                        silentShell.dispose();
                    }
                });
                Listener listener = arg0 -> this.logger.debug("Close window....");
                silentShell.setSize(300, 335);
                silentShell.addListener(21, listener);
                silentShell.pack();
                silentShell.open();
                while (!silentShell.isDisposed()) {
                    if (silentShell.getDisplay().readAndDispatch()) continue;
                    silentShell.getDisplay().sleep();
                }
                silentShell.getDisplay().dispose();
            } else {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageBox dialog = null;
                        dialog = new MessageBox(ProgressBarPaneView.this.parentComposite.getShell(), 196);
                        try {
                            dialog.setText(value);
                            dialog.setMessage(message);
                            ProgressBarPaneView.this.result = dialog.open();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        ProgressBarPaneView.this.logger.debug(ProgressBarPaneView.this.result + "result");
                        if (ProgressBarPaneView.this.result == 64) {
                            deviceRegistryResponse = 1;
                        } else if (!ProgressBarPaneView.SILENT.equalsIgnoreCase(BluSyncLauncher.isSilent)) {
                            ProgressBarPaneView.this.setLoginButtonEnableOrDisable(true);
                        }
                    }
                });
            }
        }
        catch (Exception e1) {
            this.logger.error("......" + e1.getMessage());
        }
        return deviceRegistryResponse;
    }

    static {
        deviceRegistryResponse = 0;
    }

    class GIFRunnable
    implements Runnable {
        GIFRunnable() {
        }

        @Override
        public void run() {
            if (ProgressBarPaneView.this.display == null) {
                ProgressBarPaneView.this.logger.debug("display is null");
                return;
            }
            while (ProgressBarPaneView.this.continueSearchDisplay && !ProgressBarPaneView.this.display.isDisposed()) {
                int delayTime = ProgressBarPaneView.this.loader.data[ProgressBarPaneView.this.imageNumber].delayTime;
                try {
                    Thread.sleep((long)delayTime * 10L);
                }
                catch (InterruptedException e1) {
                    ProgressBarPaneView.this.logger.error("Thread Interrupted " + e1);
                }
                Runnable runnable = () -> {
                    try {
                        int n = ProgressBarPaneView.this.imageNumber = ProgressBarPaneView.this.imageNumber == ProgressBarPaneView.this.loader.data.length - 1 ? 0 : ProgressBarPaneView.this.imageNumber + 1;
                        if (!ProgressBarPaneView.this.display.isDisposed()) {
                            ProgressBarPaneView.this.image.dispose();
                            ProgressBarPaneView.this.image = new Image((Device)ProgressBarPaneView.this.display, ProgressBarPaneView.this.loader.data[ProgressBarPaneView.this.imageNumber]);
                        }
                        if (ProgressBarPaneView.this.compositeForGif != null && !ProgressBarPaneView.this.compositeForGif.isDisposed() && !ProgressBarPaneView.this.canvas.isDisposed()) {
                            ProgressBarPaneView.this.canvas.redraw();
                        }
                    }
                    catch (Exception e) {
                        ProgressBarPaneView.this.logger.error("Exception in canvas/compositeForGif: ", (Throwable)e);
                    }
                };
                ProgressBarPaneView.this.display.asyncExec(runnable);
            }
        }
    }
}

