/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;

public class CpuInfo
implements Serializable {
    private static final long serialVersionUID = 9710L;
    String vendor = null;
    String model = null;
    int mhz = 0;
    long cacheSize = 0L;
    int totalCores = 0;
    int totalSockets = 0;
    int coresPerSocket = 0;

    public native void gather(Sigar var1) throws SigarException;

    static CpuInfo fetch(Sigar sigar) throws SigarException {
        CpuInfo cpuInfo = new CpuInfo();
        cpuInfo.gather(sigar);
        return cpuInfo;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getModel() {
        return this.model;
    }

    public int getMhz() {
        return this.mhz;
    }

    public long getCacheSize() {
        return this.cacheSize;
    }

    public int getTotalCores() {
        return this.totalCores;
    }

    public int getTotalSockets() {
        return this.totalSockets;
    }

    public int getCoresPerSocket() {
        return this.coresPerSocket;
    }

    void copyTo(CpuInfo copy) {
        copy.vendor = this.vendor;
        copy.model = this.model;
        copy.mhz = this.mhz;
        copy.cacheSize = this.cacheSize;
        copy.totalCores = this.totalCores;
        copy.totalSockets = this.totalSockets;
        copy.coresPerSocket = this.coresPerSocket;
    }

    public Map toMap() {
        String strcoresPerSocket;
        String strtotalSockets;
        String strtotalCores;
        String strcacheSize;
        String strmhz;
        String strmodel;
        HashMap<String, String> map = new HashMap<String, String>();
        String strvendor = String.valueOf(this.vendor);
        if (!"-1".equals(strvendor)) {
            map.put("Vendor", strvendor);
        }
        if (!"-1".equals(strmodel = String.valueOf(this.model))) {
            map.put("Model", strmodel);
        }
        if (!"-1".equals(strmhz = String.valueOf(this.mhz))) {
            map.put("Mhz", strmhz);
        }
        if (!"-1".equals(strcacheSize = String.valueOf(this.cacheSize))) {
            map.put("CacheSize", strcacheSize);
        }
        if (!"-1".equals(strtotalCores = String.valueOf(this.totalCores))) {
            map.put("TotalCores", strtotalCores);
        }
        if (!"-1".equals(strtotalSockets = String.valueOf(this.totalSockets))) {
            map.put("TotalSockets", strtotalSockets);
        }
        if (!"-1".equals(strcoresPerSocket = String.valueOf(this.coresPerSocket))) {
            map.put("CoresPerSocket", strcoresPerSocket);
        }
        return map;
    }

    public String toString() {
        return this.toMap().toString();
    }
}

