/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.service.dedup.rabincarb;

import com.parablu.epa.common.service.dedup.rabincarb.Polynomial;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkerHelper {
    private static final int KiB = 1024;
    private static final int MiB = 0x100000;
    private static final int GiB = 0x40000000;
    public static final int WINDOWS_SIZE = 64;
    public static int minSize = 524288;
    public static final int MAX_SIZE = 0x800000;
    private static final int CHUNKER_BUF_SIZE = 524288;
    public static final int GB_5 = 0x40000000;
    public static final int GB_10 = Integer.MIN_VALUE;
    public static final int GB_20 = 0;
    public static final int GB_30 = Integer.MIN_VALUE;
    public static final int GB_50 = Integer.MIN_VALUE;
    public static final int MAX_SIZE_LARGE_FILE = 0x1900000;
    private static final ChunkerHelper CH = new ChunkerHelper();
    private static final Logger log = LoggerFactory.getLogger(ChunkerHelper.class);
    static final HashMap<Long, tables> cacheEntries = new HashMap();
    int debug_i;

    public ChunkerHelper() {
        try {
            FileHandler fh = new FileHandler("error.log");
            fh.setLevel(Level.INFO);
            java.util.logging.Logger.getLogger("").addHandler(fh);
        }
        catch (IOException | SecurityException e) {
            e.printStackTrace();
        }
        this.debug_i = 0;
    }

    byte[] append(byte[] x, byte[] y) {
        byte[] z = new byte[x.length + y.length];
        System.arraycopy(x, 0, z, 0, x.length);
        System.arraycopy(y, 0, z, x.length, y.length);
        return z;
    }

    public static Chunker New(File rd, Polynomial pol) throws FileNotFoundException {
        return ChunkerHelper.NewWithBoundaries(rd, pol, ChunkerHelper.getMinSize(rd), 0x800000);
    }

    public static Chunker New(File rd, Polynomial pol, boolean largeFile) throws FileNotFoundException {
        return ChunkerHelper.NewWithBoundaries(rd, pol, ChunkerHelper.getMinSizeForLargeFiles(rd), 0x1900000);
    }

    private static int getMinSize(File file) {
        long fileSizeInGb = file.length() / 0x40000000L;
        int chunkSize = (int)fileSizeInGb / 8;
        if (chunkSize == 0) {
            return minSize;
        }
        return chunkSize * 0x100000;
    }

    private static int getMinSizeForLargeFiles(File file) {
        long fileSizeInGb = file.length() / 0x40000000L;
        int chunkSize = (int)fileSizeInGb / 8;
        if (chunkSize == 0) {
            return 0x800000;
        }
        return (chunkSize + 8) * 0x100000;
    }

    static Chunker NewWithBoundaries(File rd, Polynomial pol, int min, int max) throws FileNotFoundException {
        ChunkerHelper chunkerHelper = CH;
        Objects.requireNonNull(chunkerHelper);
        Chunker c = chunkerHelper.new Chunker(rd, pol, min, max);
        c.reset();
        return c;
    }

    public class Chunker {
        chunkerConfig chunkerConfig;
        chunkerState chunkerState;

        private Chunker(File rd, Polynomial pol, int min, int max) throws FileNotFoundException {
            this.chunkerConfig = new chunkerConfig();
            this.chunkerState = new chunkerState();
            this.chunkerConfig.pol = pol;
            this.chunkerConfig.minSize = min;
            this.chunkerConfig.MaxSize = max;
            this.chunkerConfig.splitmask = 1048575L;
            this.chunkerConfig.rd = rd;
            this.chunkerConfig.reader = new FileInputStream(rd);
            this.chunkerConfig.tables = new tables();
        }

        void SetAverageBits(int averageBits) {
            this.chunkerConfig.splitmask = (1 << (int)((long)averageBits)) - 1;
        }

        void Reset(File rd, Polynomial pol) throws FileNotFoundException {
            this.ResetWithBoundaries(rd, pol, ChunkerHelper.getMinSize(rd), 0x800000);
        }

        long updateDigest(long digest, int polShift, tables tab, byte b) {
            long index = digest >>> polShift;
            digest <<= 8;
            digest |= (long)b;
            return digest ^= tab.mod[(int)index].x;
        }

        long appendByte(Polynomial hash, int b, Polynomial pol) {
            hash.x <<= 8;
            hash.x |= (long)b;
            return Polynomial.Mod(hash.x, pol.x);
        }

        long slide(long digest, byte b) {
            byte out = this.chunkerState.window[this.chunkerState.wpos];
            this.chunkerState.window[this.chunkerState.wpos] = b;
            digest ^= this.chunkerConfig.tables.out[out].x;
            this.chunkerState.wpos = (this.chunkerState.wpos + 1) % 64;
            digest = this.updateDigest(digest, this.chunkerConfig.polShift, this.chunkerConfig.tables, b);
            return digest;
        }

        void ResetWithBoundaries(File fd, Polynomial pol, int min, int max) throws FileNotFoundException {
            this.chunkerConfig.pol = pol;
            this.chunkerConfig.minSize = min;
            this.chunkerConfig.MaxSize = max;
            this.chunkerConfig.splitmask = 1048575L;
            this.chunkerConfig.reader = new FileInputStream(fd);
            this.reset();
        }

        void reset() {
            this.chunkerConfig.polShift = Polynomial.Deg(this.chunkerConfig.pol.x) - 8;
            this.fillTables();
            for (int i = 0; i < 64; ++i) {
                this.chunkerState.window[i] = 0;
            }
            this.chunkerConfig.closed = false;
            this.chunkerState.digest = 0L;
            this.chunkerState.wpos = 0;
            this.chunkerState.count = 0L;
            this.chunkerState.digest = this.slide(this.chunkerState.digest, (byte)1);
            this.chunkerState.start = this.chunkerState.pos;
            this.chunkerState.pre = this.chunkerConfig.minSize - 64L;
        }

        void fillTables() {
            if (this.chunkerConfig.pol.x == 0L) {
                return;
            }
            tables t = cacheEntries.get(this.chunkerConfig.pol.x);
            if (t != null) {
                this.chunkerConfig.tables = t;
                this.chunkerConfig.tablesInitialized = true;
                return;
            }
            for (int b = 0; b < 256; ++b) {
                Polynomial h = new Polynomial();
                h.x = this.appendByte(h, b, this.chunkerConfig.pol);
                for (int i = 0; i < 63; ++i) {
                    h.x = this.appendByte(h, 0, this.chunkerConfig.pol);
                }
                this.chunkerConfig.tables.out[b] = h;
            }
            int k = Polynomial.Deg(this.chunkerConfig.pol.x);
            for (int b = 0; b < 256; ++b) {
                Polynomial p = new Polynomial();
                p.x = Polynomial.Mod((long)b << (int)((long)k), this.chunkerConfig.pol.x) | (long)b << (int)((long)k);
                this.chunkerConfig.tables.mod[b] = p;
            }
            cacheEntries.put(this.chunkerConfig.pol.x, this.chunkerConfig.tables);
            this.chunkerConfig.tablesInitialized = true;
        }

        public Chunk Next(byte[] data, File rd) throws IOException {
            if (!this.chunkerConfig.tablesInitialized) {
                return null;
            }
            Polynomial[] tabout = this.chunkerConfig.tables.out;
            Polynomial[] tabmod = this.chunkerConfig.tables.mod;
            int polShift = this.chunkerConfig.polShift;
            int minSize = ChunkerHelper.getMinSize(rd);
            int maxSize = 0x800000;
            byte[] buf = this.chunkerState.buf;
            while (true) {
                int n = 0;
                if (this.chunkerState.bpos >= this.chunkerState.bmax) {
                    try {
                        n = this.chunkerConfig.reader.read(buf);
                    }
                    catch (IOException e) {
                        log.error("Failed to read ", (Object)e.getMessage());
                        if (e.getMessage().equalsIgnoreCase("The cloud file provider is not running") || e.getMessage().equalsIgnoreCase("The cloud operation is not supported on a read-only volume") || e.getMessage().contains("BitLocker Drive Encryption")) {
                            log.error("inside return...");
                            throw new IOException(e.getMessage());
                        }
                        return null;
                    }
                    if (n == -1) {
                        if (!this.chunkerConfig.closed) {
                            this.chunkerConfig.closed = true;
                            if (this.chunkerState.count >= 0L) {
                                return new Chunk(this.chunkerState.start, this.chunkerState.count, this.chunkerState.digest, data);
                            }
                        } else {
                            return new Chunk(0L, 0L, 0L, new byte[0]);
                        }
                    }
                    this.chunkerState.bpos = 0L;
                    this.chunkerState.bmax = n;
                }
                if (this.chunkerState.pre > 0L) {
                    n = (int)(this.chunkerState.bmax - this.chunkerState.bpos);
                    if (this.chunkerState.pre > (long)n) {
                        this.chunkerState.pre -= (long)n;
                        byte[] temp = Arrays.copyOfRange(buf, (int)this.chunkerState.bpos, (int)this.chunkerState.bmax);
                        data = ChunkerHelper.this.append(data, temp);
                        this.chunkerState.count += (long)n;
                        this.chunkerState.pos += (long)n;
                        this.chunkerState.bpos = this.chunkerState.bmax;
                        continue;
                    }
                    byte[] temp = Arrays.copyOfRange(buf, (int)this.chunkerState.bpos, (int)this.chunkerState.pre);
                    data = ChunkerHelper.this.append(data, temp);
                    this.chunkerState.bpos += this.chunkerState.pre;
                    this.chunkerState.count += this.chunkerState.pre;
                    this.chunkerState.pos += this.chunkerState.pre;
                    this.chunkerState.pre = 0L;
                }
                long add = this.chunkerState.count;
                long digest = this.chunkerState.digest;
                byte[] win = this.chunkerState.window;
                int wpos = this.chunkerState.wpos;
                int b_i = (int)this.chunkerState.bpos;
                while ((long)b_i < this.chunkerState.bmax) {
                    int b = Byte.toUnsignedInt(buf[b_i]);
                    int out = Byte.toUnsignedInt(win[wpos]);
                    win[wpos] = (byte)b;
                    digest ^= tabout[out].x;
                    if (++wpos >= 64) {
                        wpos = 0;
                    }
                    int index = (int)(digest >>> polShift & 0xFFL);
                    digest <<= 8;
                    digest |= (long)b;
                    if (++add >= (long)minSize && (((digest ^= tabmod[index].x) & this.chunkerConfig.splitmask) == 0L || add >= (long)maxSize)) {
                        int i = (int)(add - this.chunkerState.count - 1L);
                        byte[] temp = Arrays.copyOfRange(buf, (int)this.chunkerState.bpos, (int)this.chunkerState.bpos + i + 1);
                        data = ChunkerHelper.this.append(data, temp);
                        this.chunkerState.count = add;
                        this.chunkerState.pos += (long)(i + 1);
                        this.chunkerState.bpos += (long)(i + 1);
                        this.chunkerState.buf = buf;
                        Chunk chunk = new Chunk(this.chunkerState.start, this.chunkerState.count, digest, data);
                        this.reset();
                        return chunk;
                    }
                    ++b_i;
                }
                this.chunkerState.digest = digest;
                this.chunkerState.wpos = wpos;
                long steps = this.chunkerState.bmax - this.chunkerState.bpos;
                if (steps > 0L) {
                    byte[] temp = Arrays.copyOfRange(buf, (int)this.chunkerState.bpos, (int)(this.chunkerState.bpos + steps));
                    data = ChunkerHelper.this.append(data, temp);
                }
                this.chunkerState.count += steps;
                this.chunkerState.pos += steps;
                this.chunkerState.bpos = this.chunkerState.bmax;
            }
        }
    }

    public class chunkerConfig {
        long minSize;
        long MaxSize;
        Polynomial pol;
        int polShift;
        boolean tablesInitialized;
        long splitmask;
        File rd;
        FileInputStream reader;
        tables tables;
        boolean closed;
    }

    public class chunkerState {
        final byte[] window = new byte[64];
        byte[] buf = new byte[524288];
        int wpos = 0;
        long bpos = 0L;
        long bmax = 0L;
        long start = 0L;
        long count = 0L;
        long pos = 0L;
        long pre = 0L;
        long digest = 0L;
    }

    public class Chunk {
        public final long Start;
        public final long Length;
        public final long Cut;
        public final byte[] data;

        Chunk(long Start, long Length, long Cut, byte[] data2) {
            this.Start = Start;
            this.Length = Length;
            this.Cut = Cut;
            this.data = data2;
        }
    }

    class tables {
        final Polynomial[] out = new Polynomial[256];
        final Polynomial[] mod = new Polynomial[256];

        tables() {
        }
    }
}

