/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERString;

public class DERBMPString
extends DERObject
implements DERString {
    String string;

    public static DERBMPString getInstance(Object object) {
        if (object == null || object instanceof DERBMPString) {
            return (DERBMPString)object;
        }
        if (object instanceof ASN1OctetString) {
            return new DERBMPString(((ASN1OctetString)object).getOctets());
        }
        if (object instanceof ASN1TaggedObject) {
            return DERBMPString.getInstance(((ASN1TaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance");
    }

    public DERBMPString(byte[] byArray) {
        char[] cArray = new char[byArray.length / 2];
        int n = 0;
        while (n != cArray.length) {
            cArray[n] = (char)(byArray[2 * n] << 8 | byArray[2 * n + 1] & 0xFF);
            ++n;
        }
        this.string = new String(cArray);
    }

    public DERBMPString(String string) {
        this.string = string;
    }

    public String getString() {
        return this.string;
    }

    public int hashCode() {
        return this.getString().hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof DERBMPString)) {
            return false;
        }
        DERPrintableString dERPrintableString = (DERPrintableString)object;
        return this.getString().equals(dERPrintableString.getString());
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        char[] cArray = this.string.toCharArray();
        byte[] byArray = new byte[cArray.length * 2];
        int n = 0;
        while (n != cArray.length) {
            byArray[2 * n] = (byte)(cArray[n] >> 8);
            byArray[2 * n + 1] = (byte)cArray[n];
            ++n;
        }
        dEROutputStream.writeEncoded(30, byArray);
    }
}

