/*
 * Decompiled with CFR 0.152.
 */
package com.jacob.com;

import com.jacob.com.ComThread;
import com.jacob.com.JacobObject;
import com.jacob.com.LibraryLoader;
import com.jacob.com.SafeArray;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ROT {
    protected static final boolean USE_AUTOMATIC_GARBAGE_COLLECTION = "true".equalsIgnoreCase(System.getProperty("com.jacob.autogc"));
    protected static String PUT_IN_ROT_SUFFIX = ".PutInROT";
    private static HashMap<String, Map<JacobObject, String>> rot = new HashMap();

    static {
        LibraryLoader.loadJacobLibrary();
    }

    protected static synchronized Map<JacobObject, String> addThread() {
        String t_name = Thread.currentThread().getName();
        if (!rot.containsKey(t_name)) {
            AbstractMap tab = null;
            if (JacobObject.isDebugEnabled()) {
                JacobObject.debug("ROT: Automatic GC flag == " + USE_AUTOMATIC_GARBAGE_COLLECTION);
            }
            tab = !USE_AUTOMATIC_GARBAGE_COLLECTION ? new HashMap() : new WeakHashMap();
            rot.put(t_name, tab);
        }
        return ROT.getThreadObjects(false);
    }

    protected static synchronized Map<JacobObject, String> getThreadObjects(boolean createIfDoesNotExist) {
        String t_name = Thread.currentThread().getName();
        if (!rot.containsKey(t_name) && createIfDoesNotExist) {
            ROT.addThread();
        }
        return rot.get(t_name);
    }

    protected static void clearObjects() {
        Map<JacobObject, String> tab;
        if (JacobObject.isDebugEnabled()) {
            JacobObject.debug("ROT: " + rot.keySet().size() + " thread tables exist");
        }
        if ((tab = ROT.getThreadObjects(false)) != null) {
            if (JacobObject.isDebugEnabled()) {
                JacobObject.debug("ROT: " + tab.keySet().size() + " objects to clear in this thread's ROT ");
            }
            for (JacobObject o : tab.keySet()) {
                if (o == null) continue;
                if (JacobObject.isDebugEnabled()) {
                    if (o instanceof SafeArray) {
                        JacobObject.debug("ROT: removing " + o.getClass().getName());
                    } else {
                        JacobObject.debug("ROT: removing " + o.hashCode() + "->" + o.getClass().getName());
                    }
                }
                o.safeRelease();
            }
            tab.clear();
            ROT.removeThread();
            if (JacobObject.isDebugEnabled()) {
                JacobObject.debug("ROT: thread table cleared and removed");
            }
        } else if (JacobObject.isDebugEnabled()) {
            JacobObject.debug("ROT: nothing to clear!");
        }
    }

    private static synchronized void removeThread() {
        rot.remove(Thread.currentThread().getName());
    }

    @Deprecated
    protected static void removeObject(JacobObject o) {
        Map<JacobObject, String> tab = ROT.getThreadObjects(false);
        if (tab != null) {
            tab.remove(o);
        }
        o.safeRelease();
    }

    protected static void addObject(JacobObject o) {
        String shouldIncludeClassInROT = System.getProperty(String.valueOf(o.getClass().getName()) + PUT_IN_ROT_SUFFIX, "true");
        if (shouldIncludeClassInROT.equalsIgnoreCase("false")) {
            if (JacobObject.isDebugEnabled()) {
                JacobObject.debug("JacobObject: New instance of " + o.getClass().getName() + " not added to ROT");
            }
        } else {
            Map<JacobObject, String> tab = ROT.getThreadObjects(false);
            if (tab == null) {
                ComThread.InitMTA(false);
                tab = ROT.getThreadObjects(true);
            }
            if (JacobObject.isDebugEnabled()) {
                JacobObject.debug("ROT: adding " + o + "->" + o.getClass().getName() + " table size prior to addition:" + tab.size());
            }
            if (tab != null) {
                tab.put(o, null);
            }
        }
    }
}

