/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.util;

import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;
import org.simpleframework.xml.util.Cache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeakCache<K, V>
implements Cache<K, V> {
    private SegmentList list;

    public WeakCache() {
        this(10);
    }

    public WeakCache(int size) {
        this.list = new SegmentList(size);
    }

    @Override
    public void cache(K key, V value) {
        this.map(key).cache(key, value);
    }

    @Override
    public V take(K key) {
        return this.map(key).take(key);
    }

    @Override
    public V fetch(K key) {
        return this.map(key).fetch(key);
    }

    @Override
    public boolean contains(K key) {
        return this.map(key).contains(key);
    }

    private Segment map(K key) {
        return this.list.get(key);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Segment
    extends WeakHashMap<K, V> {
        private Segment() {
        }

        public synchronized void cache(K key, V value) {
            this.put(key, value);
        }

        public synchronized V fetch(K key) {
            return this.get(key);
        }

        public synchronized V take(K key) {
            return this.remove(key);
        }

        public synchronized boolean contains(K key) {
            return this.containsKey(key);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SegmentList {
        private List<Segment> list = new ArrayList<Segment>();
        private int size;

        public SegmentList(int size) {
            this.size = size;
            this.create(size);
        }

        public Segment get(K key) {
            int segment = this.segment(key);
            if (segment < this.size) {
                return this.list.get(segment);
            }
            return null;
        }

        private void create(int size) {
            int count = size;
            while (count-- > 0) {
                this.list.add(new Segment());
            }
        }

        private int segment(K key) {
            return Math.abs(key.hashCode() % this.size);
        }
    }
}

