/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import org.bouncycastle.asn1.DERConstructedSequence;
import org.bouncycastle.asn1.DERInputStream;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.oiw.ElGamalParameter;
import org.bouncycastle.asn1.pkcs.DHParameter;
import org.bouncycastle.asn1.x509.DSAParameter;
import org.bouncycastle.jce.spec.ElGamalParameterSpec;

public abstract class JDKAlgorithmParameters
extends AlgorithmParametersSpi {

    public static class ElGamal
    extends JDKAlgorithmParameters {
        ElGamalParameterSpec currentSpec;
        static /* synthetic */ Class class$org$bouncycastle$jce$spec$ElGamalParameterSpec;

        protected byte[] engineGetEncoded() {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
            ElGamalParameter elGamalParameter = new ElGamalParameter(this.currentSpec.getP(), this.currentSpec.getG());
            try {
                dEROutputStream.writeObject(elGamalParameter);
                dEROutputStream.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException("Error encoding ElGamalParameters");
            }
            return byteArrayOutputStream.toByteArray();
        }

        protected byte[] engineGetEncoded(String string) {
            if (string.equals("X.509")) {
                return this.engineGetEncoded();
            }
            return null;
        }

        protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
            if (clazz == (class$org$bouncycastle$jce$spec$ElGamalParameterSpec == null ? (class$org$bouncycastle$jce$spec$ElGamalParameterSpec = ElGamal.class$("org.bouncycastle.jce.spec.ElGamalParameterSpec")) : class$org$bouncycastle$jce$spec$ElGamalParameterSpec)) {
                return this.currentSpec;
            }
            throw new InvalidParameterSpecException("unknown parameter spec passed to ElGamal parameters object.");
        }

        protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
            if (!(algorithmParameterSpec instanceof ElGamalParameterSpec)) {
                throw new InvalidParameterSpecException("ElGamalParameterSpec required to initialise a ElGamal algorithm parameters object");
            }
            this.currentSpec = (ElGamalParameterSpec)algorithmParameterSpec;
        }

        protected void engineInit(byte[] byArray) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DERInputStream dERInputStream = new DERInputStream(byteArrayInputStream);
            try {
                ElGamalParameter elGamalParameter = new ElGamalParameter((DERConstructedSequence)dERInputStream.readObject());
                this.currentSpec = new ElGamalParameterSpec(elGamalParameter.getP(), elGamalParameter.getG());
            }
            catch (ClassCastException classCastException) {
                throw new IOException("Not a valid ElGamal Parameter encoding.");
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new IOException("Not a valid ElGamal Parameter encoding.");
            }
        }

        protected void engineInit(byte[] byArray, String string) throws IOException {
            if (!string.equals("X.509")) {
                throw new IOException("Unknown parameter format " + string);
            }
            this.engineInit(byArray);
        }

        protected String engineToString() {
            return "ElGamal Parameters";
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    public static class DSA
    extends JDKAlgorithmParameters {
        DSAParameterSpec currentSpec;
        static /* synthetic */ Class class$java$security$spec$DSAParameterSpec;

        protected byte[] engineGetEncoded() {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
            DSAParameter dSAParameter = new DSAParameter(this.currentSpec.getP(), this.currentSpec.getQ(), this.currentSpec.getG());
            try {
                dEROutputStream.writeObject(dSAParameter);
                dEROutputStream.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException("Error encoding DSAParameters");
            }
            return byteArrayOutputStream.toByteArray();
        }

        protected byte[] engineGetEncoded(String string) {
            if (string.equals("X.509")) {
                return this.engineGetEncoded();
            }
            return null;
        }

        protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
            if (clazz == (class$java$security$spec$DSAParameterSpec == null ? (class$java$security$spec$DSAParameterSpec = DSA.class$("java.security.spec.DSAParameterSpec")) : class$java$security$spec$DSAParameterSpec)) {
                return this.currentSpec;
            }
            throw new InvalidParameterSpecException("unknown parameter spec passed to DSA parameters object.");
        }

        protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
            if (!(algorithmParameterSpec instanceof DSAParameterSpec)) {
                throw new InvalidParameterSpecException("DSAParameterSpec required to initialise a DSA algorithm parameters object");
            }
            this.currentSpec = (DSAParameterSpec)algorithmParameterSpec;
        }

        protected void engineInit(byte[] byArray) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DERInputStream dERInputStream = new DERInputStream(byteArrayInputStream);
            try {
                DSAParameter dSAParameter = new DSAParameter((DERConstructedSequence)dERInputStream.readObject());
                this.currentSpec = new DSAParameterSpec(dSAParameter.getP(), dSAParameter.getQ(), dSAParameter.getG());
            }
            catch (ClassCastException classCastException) {
                throw new IOException("Not a valid DSA Parameter encoding.");
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new IOException("Not a valid DSA Parameter encoding.");
            }
        }

        protected void engineInit(byte[] byArray, String string) throws IOException {
            if (!string.equals("X.509")) {
                throw new IOException("Unknown parameter format " + string);
            }
            this.engineInit(byArray);
        }

        protected String engineToString() {
            return "DSA Parameters";
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    public static class DH
    extends JDKAlgorithmParameters {
        DHParameterSpec currentSpec;
        static /* synthetic */ Class class$javax$crypto$spec$DHParameterSpec;

        protected byte[] engineGetEncoded() {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
            DHParameter dHParameter = new DHParameter(this.currentSpec.getP(), this.currentSpec.getG(), this.currentSpec.getL());
            try {
                dEROutputStream.writeObject(dHParameter);
                dEROutputStream.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException("Error encoding DHParameters");
            }
            return byteArrayOutputStream.toByteArray();
        }

        protected byte[] engineGetEncoded(String string) {
            if (string.equals("X.509")) {
                return this.engineGetEncoded();
            }
            return null;
        }

        protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
            if (clazz == (class$javax$crypto$spec$DHParameterSpec == null ? (class$javax$crypto$spec$DHParameterSpec = DH.class$("javax.crypto.spec.DHParameterSpec")) : class$javax$crypto$spec$DHParameterSpec)) {
                return this.currentSpec;
            }
            throw new InvalidParameterSpecException("unknown parameter spec passed to DH parameters object.");
        }

        protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
            if (!(algorithmParameterSpec instanceof DHParameterSpec)) {
                throw new InvalidParameterSpecException("DHParameterSpec required to initialise a Diffie-Hellman algorithm parameters object");
            }
            this.currentSpec = (DHParameterSpec)algorithmParameterSpec;
        }

        protected void engineInit(byte[] byArray) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DERInputStream dERInputStream = new DERInputStream(byteArrayInputStream);
            try {
                DHParameter dHParameter = new DHParameter((DERConstructedSequence)dERInputStream.readObject());
                this.currentSpec = dHParameter.getL() != null ? new DHParameterSpec(dHParameter.getP(), dHParameter.getG(), dHParameter.getL().intValue()) : new DHParameterSpec(dHParameter.getP(), dHParameter.getG());
            }
            catch (ClassCastException classCastException) {
                throw new IOException("Not a valid DH Parameter encoding.");
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new IOException("Not a valid DH Parameter encoding.");
            }
        }

        protected void engineInit(byte[] byArray, String string) throws IOException {
            if (!string.equals("X.509")) {
                throw new IOException("Unknown parameter format " + string);
            }
            this.engineInit(byArray);
        }

        protected String engineToString() {
            return "Diffie-Hellman Parameters";
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    public static class IVAlgorithmParameters
    extends JDKAlgorithmParameters {
        private byte[] iv;
        static /* synthetic */ Class class$javax$crypto$spec$IvParameterSpec;

        protected byte[] engineGetEncoded() {
            byte[] byArray = new byte[this.iv.length];
            System.arraycopy(this.iv, 0, byArray, 0, this.iv.length);
            return byArray;
        }

        protected byte[] engineGetEncoded(String string) {
            if (string.equals("RAW")) {
                return this.engineGetEncoded();
            }
            return null;
        }

        protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
            if (clazz == (class$javax$crypto$spec$IvParameterSpec == null ? (class$javax$crypto$spec$IvParameterSpec = IVAlgorithmParameters.class$("javax.crypto.spec.IvParameterSpec")) : class$javax$crypto$spec$IvParameterSpec)) {
                return new IvParameterSpec(this.iv);
            }
            throw new InvalidParameterSpecException("unknown parameter spec passed to IV parameters object.");
        }

        protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
            if (!(algorithmParameterSpec instanceof IvParameterSpec)) {
                throw new InvalidParameterSpecException("IvParameterSpec required to initialise a IV parameters algorithm parameters object");
            }
            this.iv = ((IvParameterSpec)algorithmParameterSpec).getIV();
        }

        protected void engineInit(byte[] byArray) throws IOException {
            this.iv = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.iv, 0, this.iv.length);
        }

        protected void engineInit(byte[] byArray, String string) throws IOException {
            if (string.equals("RAW")) {
                this.engineInit(byArray);
                return;
            }
            throw new IOException("Unknown parameters format in IV parameters object");
        }

        protected String engineToString() {
            return "IV Parameters";
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

