/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.dao;

import com.parablu.epa.common.dao.BaseDAO;
import com.parablu.epa.core.constant.BluSyncSQLConstants;
import com.parablu.epa.core.dao.BackUpImageDAO;
import com.parablu.epa.core.to.BackupTO;
import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackUpImageDAOImpl
extends BaseDAO
implements BackUpImageDAO {
    private Logger logger = LoggerFactory.getLogger(BackUpImageDAOImpl.class);
    private static final String DELETEFROM = "delete from ";

    public BackUpImageDAOImpl(String uRL) {
        super(uRL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTable() {
        BackUpImageDAOImpl backUpImageDAOImpl = this;
        synchronized (backUpImageDAOImpl) {
            String query = BluSyncSQLConstants.CREATE_BACKUP_IMAGE_TABLE_QUERY;
            if (this.getConnection()) {
                try {
                    this.statement = this.conn.prepareStatement(query);
                    this.statement.execute();
                }
                catch (SQLException exception) {
                    this.logger.error("SQLException while creating backup image table", (Throwable)exception);
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    this.closeConnection();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insertListIntoTable(List<BackupTO> fileTOs) {
        BackUpImageDAOImpl backUpImageDAOImpl = this;
        synchronized (backUpImageDAOImpl) {
            String query = new StringBuffer().append("INSERT INTO ").append("BKIT").append(" (").append("filename").append(",").append("filepath").append(",").append("bkupfilestatus").append(",").append("gatewayIP").append(",").append("checksum").append(",").append("metadata").append(",").append("modifiedtimestamp").append(",").append("folder").append(")").append(" Values(?,?,?,?,?,?,?,?);").toString();
            boolean success = false;
            if (this.getConnection()) {
                try {
                    this.statement = this.conn.prepareStatement(query);
                    int listsize = fileTOs.size();
                    this.conn.setAutoCommit(false);
                    for (int recordCount = 0; recordCount < listsize; ++recordCount) {
                        BackupTO currentFilesTO = fileTOs.get(recordCount);
                        String tempValueFolder = String.valueOf(currentFilesTO.isFolder());
                        this.statement.setString(1, currentFilesTO.getFileName());
                        this.statement.setString(2, currentFilesTO.getAbstractFilePath());
                        this.statement.setString(3, currentFilesTO.getBkupStatus());
                        this.statement.setString(4, currentFilesTO.getGatewayIP());
                        this.statement.setString(5, currentFilesTO.getMd5checksum());
                        this.statement.setString(6, currentFilesTO.getMetaData());
                        this.statement.setString(7, String.valueOf(currentFilesTO.getLastModifiedTimestamp()));
                        this.statement.setString(8, tempValueFolder);
                        this.statement.addBatch();
                        if (recordCount % 1000 != 0) continue;
                        this.statement.executeBatch();
                        this.statement.clearBatch();
                    }
                    this.statement.executeBatch();
                    this.conn.commit();
                    success = true;
                }
                catch (SQLException exception) {
                    this.logger.error("SQLException while inserting into backup image table", (Throwable)exception);
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    this.closeConnection();
                }
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BackupTO> readAllEntriesFromBackupImageTable() {
        BackUpImageDAOImpl backUpImageDAOImpl = this;
        synchronized (backUpImageDAOImpl) {
            String query = "select * from BKIT where bkupfilestatus not like '%STARTED%' OR bkupfilestatus is NULL";
            ResultSet selectImageTableResult = null;
            ArrayList<BackupTO> fileTOList = null;
            boolean gotConnection = this.getConnection();
            if (gotConnection) {
                try {
                    this.statement = this.conn.prepareStatement("select * from BKIT where bkupfilestatus not like '%STARTED%' OR bkupfilestatus is NULL");
                    selectImageTableResult = this.statement.executeQuery();
                    fileTOList = new ArrayList<BackupTO>();
                    while (selectImageTableResult != null && selectImageTableResult.next()) {
                        BackupTO tempFile = new BackupTO();
                        tempFile.setFileName(selectImageTableResult.getString("filename"));
                        tempFile.setAbstractFilePath(selectImageTableResult.getString("filepath"));
                        tempFile.setMd5checksum(selectImageTableResult.getString("checksum"));
                        tempFile.setMetaData(selectImageTableResult.getString("metadata"));
                        String tempTimeStamp = selectImageTableResult.getString("modifiedtimestamp");
                        tempFile.setFolder(Boolean.valueOf(selectImageTableResult.getString("folder")).booleanValue());
                        tempFile.setLastModifiedTimestamp(Long.valueOf(tempTimeStamp).longValue());
                        tempFile.setBkupStatus(selectImageTableResult.getString("bkupfilestatus"));
                        tempFile.setClientData(selectImageTableResult.getString("filepath") + File.separator + selectImageTableResult.getString("filename"));
                        tempFile.setGatewayIP(selectImageTableResult.getString("gatewayIP"));
                        fileTOList.add(tempFile);
                    }
                    this.statement.close();
                }
                catch (SQLException e) {
                    this.logger.error("SQLException while readAllEntriesFromTable", (Throwable)e);
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    if (selectImageTableResult != null) {
                        try {
                            selectImageTableResult.close();
                        }
                        catch (SQLException e) {
                            this.logger.error("SQLException while closing result set" + e);
                        }
                        catch (RuntimeException e) {
                            this.logger.error("Runtime Exception...", (Object)e.getMessage());
                        }
                    }
                    this.closeConnection();
                }
            }
            return fileTOList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeListFromTable(List<BackupTO> fileTOs) {
        BackUpImageDAOImpl backUpImageDAOImpl = this;
        synchronized (backUpImageDAOImpl) {
            String query = "delete from BKIT where filename=? And filepath=?;";
            boolean success = false;
            this.statement = null;
            if (this.getConnection()) {
                try {
                    this.statement = this.conn.prepareStatement("delete from BKIT where filename=? And filepath=?;");
                    int listsize = fileTOs.size();
                    this.conn.setAutoCommit(false);
                    for (int recordCount = 0; recordCount < listsize; ++recordCount) {
                        this.statement.setString(1, fileTOs.get(recordCount).getFileName());
                        this.statement.setString(2, fileTOs.get(recordCount).getAbstractFilePath());
                        this.statement.addBatch();
                        if (recordCount % 1000 != 0) continue;
                        this.statement.executeBatch();
                        this.statement.clearBatch();
                    }
                    this.statement.executeBatch();
                    this.conn.commit();
                    success = true;
                }
                catch (SQLException exception) {
                    this.logger.error("SQLException while removeListFromTable", (Throwable)exception);
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    this.closeConnection();
                }
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateEventToBackupImageTable(BackupTO backupTO) {
        BackUpImageDAOImpl backUpImageDAOImpl = this;
        synchronized (backUpImageDAOImpl) {
            String bkupStatus = backupTO.getBkupStatus();
            String fileName = backupTO.getFileName();
            String gatewayIP = backupTO.getGatewayIP();
            String sqlQuery = "Update BKIT set bkupfilestatus=? And gatewayIP=? where filename=? ;";
            this.statement = null;
            boolean success = false;
            boolean gotConnection = this.getConnection();
            if (gotConnection) {
                try {
                    this.statement = this.conn.prepareStatement("Update BKIT set bkupfilestatus=? And gatewayIP=? where filename=? ;");
                    this.statement.setString(1, bkupStatus);
                    this.statement.setString(2, gatewayIP);
                    this.statement.setString(3, fileName);
                    this.statement.execute();
                    this.statement.close();
                    success = true;
                }
                catch (SQLException e) {
                    this.logger.trace("" + e);
                    this.logger.error("SQLException while updating activity Table:" + e.getMessage());
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    this.closeConnection();
                }
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insertFileToBackupImageTable(BackupTO fileTO) {
        BackUpImageDAOImpl backUpImageDAOImpl = this;
        synchronized (backUpImageDAOImpl) {
            String query = new StringBuffer().append("INSERT INTO ").append("BKIT").append(" (").append("filename").append(",").append("filepath").append(",").append("bkupfilestatus").append(",").append("gatewayIP").append(",").append("checksum").append(",").append("metadata").append(",").append("modifiedtimestamp").append(",").append("folder").append(")").append(" Values(?,?,?,?,?,?,?,?);").toString();
            boolean success = false;
            if (this.getConnection()) {
                try {
                    this.statement = this.conn.prepareStatement(query);
                    this.conn.setAutoCommit(false);
                    String tempValueFolder = String.valueOf(fileTO.isFolder());
                    this.statement.setString(1, fileTO.getFileName());
                    this.statement.setString(2, fileTO.getAbstractFilePath());
                    this.statement.setString(3, fileTO.getBkupStatus());
                    this.statement.setString(4, fileTO.getGatewayIP());
                    this.statement.setString(5, fileTO.getMd5checksum());
                    this.statement.setString(6, fileTO.getMetaData());
                    this.statement.setString(7, String.valueOf(fileTO.getLastModifiedTimestamp()));
                    this.statement.setString(8, tempValueFolder);
                    this.statement.addBatch();
                    this.statement.executeBatch();
                    this.conn.commit();
                    success = true;
                }
                catch (SQLException exception) {
                    this.logger.error("SQLException while inserting into backup image table:", (Throwable)exception);
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    this.closeConnection();
                }
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BackupTO> searchFilename() {
        BackUpImageDAOImpl backUpImageDAOImpl = this;
        synchronized (backUpImageDAOImpl) {
            String sqlQuery = "select * from BKIT where bkupfilestatus = 'STARTED';";
            ResultSet selectImageTableResult = null;
            this.statement = null;
            ArrayList<BackupTO> fileTOList = null;
            boolean gotConnection = this.getConnection();
            if (gotConnection) {
                try {
                    this.statement = this.conn.prepareStatement("select * from BKIT where bkupfilestatus = 'STARTED';");
                    selectImageTableResult = this.statement.executeQuery();
                    fileTOList = new ArrayList<BackupTO>();
                    while (selectImageTableResult != null && selectImageTableResult.next()) {
                        BackupTO tempFile = new BackupTO();
                        tempFile.setFileName(selectImageTableResult.getString("filename"));
                        tempFile.setAbstractFilePath(selectImageTableResult.getString("filepath"));
                        tempFile.setMd5checksum(selectImageTableResult.getString("checksum"));
                        tempFile.setMetaData(selectImageTableResult.getString("metadata"));
                        String tempTimeStamp = selectImageTableResult.getString("modifiedtimestamp");
                        tempFile.setFolder(Boolean.valueOf(selectImageTableResult.getString("folder")).booleanValue());
                        tempFile.setLastModifiedTimestamp(Long.valueOf(tempTimeStamp).longValue());
                        tempFile.setBkupStatus(selectImageTableResult.getString("bkupfilestatus"));
                        tempFile.setGatewayIP(selectImageTableResult.getString("gatewayIP"));
                        fileTOList.add(tempFile);
                    }
                    this.statement.close();
                }
                catch (SQLException e) {
                    this.logger.error("SQLException while get file " + e);
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    if (selectImageTableResult != null) {
                        try {
                            selectImageTableResult.close();
                        }
                        catch (SQLException exception) {
                            this.logger.error("SQLException while get file :", (Throwable)exception);
                        }
                        catch (RuntimeException e) {
                            this.logger.error("Runtime Exception...", (Object)e.getMessage());
                        }
                    }
                    this.closeConnection();
                }
            }
            return fileTOList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean alterTable() {
        BackUpImageDAOImpl backUpImageDAOImpl = this;
        synchronized (backUpImageDAOImpl) {
            this.statement = null;
            boolean success = false;
            boolean gotConnection = this.getConnectionForCreatingDatabase();
            if (gotConnection) {
                try {
                    this.statement = this.conn.prepareStatement("ALTER table BKIT ADD COLUMN bkupfilestatus TEXT;");
                    this.statement.execute();
                    this.statement.close();
                    this.statement = this.conn.prepareStatement("ALTER table BKIT ADD COLUMN gatewayIP TEXT;");
                    this.statement.execute();
                    this.statement.close();
                    success = true;
                }
                catch (SQLException e) {
                    this.logger.error("sqlExeception in CREATE_ACTIVITY_TABLE" + e);
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    this.closeConnection();
                }
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteEntireTable() {
        BackUpImageDAOImpl backUpImageDAOImpl = this;
        synchronized (backUpImageDAOImpl) {
            String query = "delete from BKIT";
            boolean success = false;
            this.statement = null;
            if (this.getConnection()) {
                try {
                    this.statement = this.conn.prepareStatement("delete from BKIT");
                    this.statement.execute();
                    success = true;
                }
                catch (SQLException exception) {
                    this.logger.error("SQLException while deleting backup image table:", (Throwable)exception);
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    this.closeConnection();
                }
            }
            return success;
        }
    }
}

