/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.core.adapter.tcp;

import com.parablu.epa.core.service.proxy.ProxyDetector;
import com.parablu.epa.core.to.BackupFolderTO;
import com.parablu.epa.helper.utils.RegistryUtils;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeromq.ZMQ;

public class ListnerAdapter {
    private Logger logger = LoggerFactory.getLogger(ListnerAdapter.class);
    private String action = "action";
    private static final String EXCEPTION = "Exception : ";
    private static final int FIVE_MIN_IN_MILLI = 300000;
    private String osType = ProxyDetector.getOsType();

    public void deleteVsnapshot(List<BackupFolderTO> listOfFolder) {
        ZMQ.Context context = ZMQ.context((int)1);
        ZMQ.Socket socket = context.socket(3);
        String port = RegistryUtils.getServicePortNumberFromReg((String)this.osType);
        socket.connect("tcp://localhost:" + port);
        JSONObject obj = new JSONObject();
        obj.put((Object)this.action, (Object)"deletevss");
        JSONArray list = new JSONArray();
        for (BackupFolderTO folder : listOfFolder) {
            list.add((Object)folder.getFolderPath());
            this.logger.debug("snapfolders to delete : " + folder.getFolderPath());
        }
        obj.put((Object)"folderPaths", (Object)list);
        this.logger.debug("calling to delete");
        int requestNbr = 0;
        if (requestNbr != 1) {
            String request = obj.toJSONString();
            socket.send(request.getBytes(), 0);
            ZMQ.PollItem[] items = new ZMQ.PollItem[]{new ZMQ.PollItem(socket, 1)};
            int rc = ZMQ.poll((ZMQ.PollItem[])items, (long)300000L);
            if (rc == -1) {
                this.terminateConnetion(context, socket);
                return;
            }
            if (items[0].isReadable()) {
                String reply = socket.recvStr();
                this.logger.debug("Received " + new String(reply) + " " + requestNbr);
            } else {
                this.logger.debug("Service TIME OUT");
            }
            this.terminateConnetion(context, socket);
            return;
        }
    }

    public boolean checkForService() {
        boolean serviceAlive = false;
        try {
            ZMQ.Context context = ZMQ.context((int)1);
            ZMQ.Socket socket = context.socket(3);
            String port = RegistryUtils.getServicePortNumberFromReg((String)this.osType);
            socket.connect("tcp://localhost:" + port);
            JSONObject obj = new JSONObject();
            obj.put((Object)this.action, (Object)"ping");
            this.logger.debug("calling to check for update");
            String request = obj.toJSONString();
            socket.send(request.getBytes(), 0);
            ZMQ.PollItem[] items = new ZMQ.PollItem[]{new ZMQ.PollItem(socket, 1)};
            int rc = ZMQ.poll((ZMQ.PollItem[])items, (long)5000L);
            if (rc == -1) {
                this.terminateConnetion(context, socket);
                return false;
            }
            if (items[0].isReadable()) {
                String reply = socket.recvStr();
                if (reply.equalsIgnoreCase(String.valueOf(200))) {
                    serviceAlive = true;
                }
            } else {
                this.logger.debug("TIME OUT");
                this.terminateConnetion(context, socket);
                return serviceAlive;
            }
            this.terminateConnetion(context, socket);
        }
        catch (Exception e) {
            this.logger.debug(EXCEPTION + e);
        }
        return serviceAlive;
    }

    public String initiateUpdateCheckFromService(String cloudIpAddress, String cloudName, String productVersion, String deviceUUID, String userProfile) {
        String updateAvailable = String.valueOf(false);
        try {
            ZMQ.Context context = ZMQ.context((int)1);
            ZMQ.Socket socket = context.socket(3);
            String port = RegistryUtils.getServicePortNumberFromReg((String)this.osType);
            socket.connect("tcp://localhost:" + port);
            JSONObject obj = new JSONObject();
            obj.put((Object)this.action, (Object)"checkUpdate");
            obj.put((Object)"updateIp", (Object)cloudIpAddress);
            obj.put((Object)"cloudName", (Object)cloudName);
            obj.put((Object)"productVersion", (Object)productVersion);
            obj.put((Object)"deviceUUID", (Object)deviceUUID);
            obj.put((Object)"userProfile", (Object)userProfile);
            this.logger.debug("calling to check for update");
            String request = obj.toJSONString();
            socket.send(request.getBytes(), 0);
            String reply = socket.recvStr();
            if (reply.equalsIgnoreCase(String.valueOf(200))) {
                this.logger.debug("update is available");
                updateAvailable = String.valueOf(true);
            } else if (reply.equalsIgnoreCase(String.valueOf(203))) {
                updateAvailable = String.valueOf(false);
            }
            this.terminateConnetion(context, socket);
        }
        catch (Exception e) {
            this.logger.debug(EXCEPTION + e);
        }
        return updateAvailable;
    }

    public String getServiceVersion(String userAppdata) {
        String serviceVersion = "";
        try {
            ZMQ.Context context = ZMQ.context((int)1);
            ZMQ.Socket socket = context.socket(3);
            String port = RegistryUtils.getServicePortNumberFromReg((String)this.osType);
            socket.connect("tcp://localhost:" + port);
            JSONObject obj = new JSONObject();
            obj.put((Object)this.action, (Object)"GetVersion_StartUpdateTimer");
            obj.put((Object)"userAppdata", (Object)userAppdata);
            this.logger.debug("calling get service version and start service update");
            String request = obj.toJSONString();
            socket.send(request.getBytes(), 0);
            ZMQ.PollItem[] items = new ZMQ.PollItem[]{new ZMQ.PollItem(socket, 1)};
            int rc = ZMQ.poll((ZMQ.PollItem[])items, (long)10000L);
            if (rc == -1) {
                this.terminateConnetion(context, socket);
                return serviceVersion;
            }
            if (items[0].isReadable()) {
                String reply = socket.recvStr();
                if (StringUtils.isNotEmpty((String)reply) && !reply.equalsIgnoreCase(String.valueOf(400))) {
                    serviceVersion = reply;
                }
            } else {
                this.logger.debug("TIME OUT");
                this.terminateConnetion(context, socket);
                return serviceVersion;
            }
            this.terminateConnetion(context, socket);
        }
        catch (Exception e) {
            this.logger.debug(EXCEPTION + e);
        }
        return serviceVersion;
    }

    public void terminateConnetion(ZMQ.Context context, ZMQ.Socket socket) {
        this.logger.debug("before closing the socket..");
        if (socket != null) {
            socket.close();
        }
        this.logger.debug("After closing the socket..");
        if (context != null) {
            context.term();
        }
        this.logger.debug("After terminating the context..");
    }

    public boolean copySetupLogs(String cloudIpAddress, String cloudName, String deviceUUID, String userProfile) {
        boolean result = false;
        try {
            ZMQ.Context context = ZMQ.context((int)1);
            ZMQ.Socket socket = context.socket(3);
            String port = RegistryUtils.getServicePortNumberFromReg((String)this.osType);
            socket.connect("tcp://localhost:" + port);
            JSONObject obj = new JSONObject();
            obj.put((Object)this.action, (Object)"copysetuplogs");
            obj.put((Object)"updateIp", (Object)cloudIpAddress);
            obj.put((Object)"cloudName", (Object)cloudName);
            obj.put((Object)"deviceUUID", (Object)deviceUUID);
            obj.put((Object)"userProfile", (Object)userProfile);
            this.logger.debug("calling to copy files");
            String request = obj.toJSONString();
            socket.send(request.getBytes(), 0);
            String reply = socket.recvStr();
            if (reply.equalsIgnoreCase(String.valueOf(200))) {
                this.logger.debug("Files copied successufully from temp to prablu");
                result = true;
            } else if (reply.equalsIgnoreCase(String.valueOf(203))) {
                result = false;
            }
            this.terminateConnetion(context, socket);
        }
        catch (Exception e) {
            this.logger.debug(EXCEPTION + e);
            e.printStackTrace();
        }
        return result;
    }

    public boolean setAgentUninstallationPassword(String password, String filePath, boolean isPswdCheckEnabled) {
        boolean result = false;
        try {
            ZMQ.Context context = ZMQ.context((int)1);
            ZMQ.Socket socket = context.socket(3);
            String port = RegistryUtils.getServicePortNumberFromReg((String)this.osType);
            socket.connect("tcp://localhost:" + port);
            JSONObject obj = new JSONObject();
            obj.put((Object)this.action, (Object)"AgentUninstallationPassword");
            obj.put((Object)"password", (Object)password);
            obj.put((Object)"filePath", (Object)filePath);
            obj.put((Object)"isPswdCheckEnabled", (Object)String.valueOf(isPswdCheckEnabled));
            this.logger.debug("calling to copy files");
            String request = obj.toJSONString();
            socket.send(request.getBytes(), 0);
            String reply = socket.recvStr();
            if (reply.equalsIgnoreCase(String.valueOf(200))) {
                this.logger.debug("Files copied successufully from temp to prablu");
                result = true;
            } else if (reply.equalsIgnoreCase(String.valueOf(203))) {
                result = false;
            }
            this.terminateConnetion(context, socket);
        }
        catch (Exception e) {
            this.logger.debug(EXCEPTION + e);
            e.printStackTrace();
        }
        return result;
    }

    public boolean validateConnectedDomain(String cloudIpAddress, String cloudName, String deviceUUID, String userProfile, String domainName) {
        boolean result = false;
        try {
            ZMQ.Context context = ZMQ.context((int)1);
            ZMQ.Socket socket = context.socket(3);
            String port = RegistryUtils.getServicePortNumberFromReg((String)this.osType);
            socket.connect("tcp://localhost:" + port);
            JSONObject obj = new JSONObject();
            obj.put((Object)this.action, (Object)"validateDomain");
            obj.put((Object)"updateIp", (Object)cloudIpAddress);
            obj.put((Object)"cloudName", (Object)cloudName);
            obj.put((Object)"deviceUUID", (Object)deviceUUID);
            obj.put((Object)"userProfile", (Object)userProfile);
            obj.put((Object)"domainName", (Object)domainName);
            this.logger.debug("calling to validateConnectedDomain");
            String request = obj.toJSONString();
            socket.send(request.getBytes(), 0);
            String reply = socket.recvStr();
            if (reply.equalsIgnoreCase(String.valueOf(200))) {
                this.logger.debug("validated successfully...");
                result = true;
            } else if (reply.equalsIgnoreCase(String.valueOf(203))) {
                this.logger.debug("validateConnectedDomain failed ...");
                result = false;
            }
            this.terminateConnetion(context, socket);
        }
        catch (Exception e) {
            this.logger.debug(EXCEPTION + e);
            e.printStackTrace();
        }
        return result;
    }
}

