/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.view;

import com.parablu.blusync.service.update.SparkleActivator;
import com.parablu.epa.common.service.alarm.StatisticsCollectorHelper;
import com.parablu.epa.common.service.notification.NotificationHelper;
import com.parablu.epa.common.service.settings.PolicyManagementServerHelper;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.adapter.pcb.UpdateAdapter;
import com.parablu.epa.core.helper.PropertyHelper;
import com.parablu.epa.service.alarm.BlusyncThreadHelper;
import com.parablu.epa.service.alarm.MacPolicyRefreshHelper;
import com.parablu.epa.service.settings.MacSettingsHelper;
import com.parablu.epa.view.ActivityHistoryTask;
import com.parablu.epa.view.RegistrationView;
import com.parablu.epa.view.SystemTrayUI;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.PropertyConfigurator;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BluSyncLauncher {
    private static SystemTrayUI systray = null;
    private static final int TIMER_DAY_MILLISECONDS = 86400000;
    private static final int TIMER_MINUTE_MILLISECONDS = 60000;
    private static final int TIMER_TWO_MINUTE_MILLISECONDS = 120000;
    private static File mainAppFile;
    private static Logger logger;
    private static Timer activityCleanUPTimer;
    private static Timer upgradeCheckTimer;
    public static String isSilent;
    public static String certName;
    private static final String EXCEPTION = "Exception";
    private static final String IO_EXCEPTION = "IOException";
    private static final String FALSE = "false";
    private static Display display;

    private BluSyncLauncher() {
    }

    public static void main(String[] args) throws IOException {
        try {
            boolean isSettingsInitialized = MacSettingsHelper.initiateSettings();
            if (!isSettingsInitialized) {
                logger.debug("Error at initiateSettings");
                logger.debug("Error at initiateSettings1");
                return;
            }
            String logfilePath = SettingHelper.getParabluBlusyncAppDataFolderUrl();
            PropertyConfigurator.configure((String)(MacSettingsHelper.baseResourceFolder + "ParaBlu-log4j.properties"));
            logger.debug("Error at initiateSettings2");
            BluSyncLauncher.validateOnlyOneInstanceIsRunning();
            logger.error("Application started");
            logger.error("Agent Version:" + SettingHelper.getProductVersion());
            logger.error("SWT version:" + SWT.getVersion());
            logger.info("before starting UI");
            isSilent = PropertyHelper.LOGIN_TYPE;
            certName = PropertyHelper.CERT_FILE_ALIAS;
            Boolean isNonSilentAgent = SettingHelper.isNonSilentFileExist();
            if (StringUtils.isNotEmpty((String)isSilent) && "silent".equalsIgnoreCase(isSilent) && !isNonSilentAgent.booleanValue()) {
                BluSyncLauncher.startWiproUI(PropertyHelper.CLOUD_NAME);
            } else {
                BluSyncLauncher.startUI();
            }
            logger.info("After starting UI");
            BluSyncLauncher.updateBackupStatus();
            BluSyncLauncher.stopCrawlProcess();
            logger.debug("Exiting the Application bye..");
            System.exit(0);
        }
        catch (Exception e) {
            logger.error("Error in main()");
            logger.error(EXCEPTION, (Throwable)e);
        }
    }

    private static void validateOnlyOneInstanceIsRunning() throws Exception {
        logger.debug(SettingHelper.getMainLockUrl());
        mainAppFile = new File(SettingHelper.getMainLockUrl());
        if (!mainAppFile.exists()) {
            if (mainAppFile.createNewFile()) {
                BluSyncLauncher.addEntryToFile();
                return;
            }
            throw new Exception("Application Instance failed to create a file lock");
        }
        int proceessId = BluSyncLauncher.readProcessIdFromFile();
        logger.debug("processId :" + proceessId);
        if (BluSyncLauncher.isProcessActive(proceessId)) {
            throw new Exception("Application already started");
        }
        BluSyncLauncher.addEntryToFile();
    }

    private static void addEntryToFile() {
        BluSyncLauncher.writeProcessIdToFile();
        ShutdownHook shutdownHook = new ShutdownHook();
        Runtime.getRuntime().addShutdownHook(shutdownHook);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isProcessActive(int proceessId) {
        if (proceessId == -1) {
            return false;
        }
        try {
            String[] str = new String[]{"/bin/sh", "-c", "ps ax | awk '{print $1}'"};
            Process p = Runtime.getRuntime().exec(str);
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(p.getInputStream()));){
                String line = bufferedReader.readLine();
                while (line != null) {
                    if (line.equals(String.valueOf(proceessId))) {
                        IOUtils.closeQuietly((Reader)bufferedReader);
                        p.destroy();
                        boolean bl = true;
                        return bl;
                    }
                    line = bufferedReader.readLine();
                }
            }
            p.waitFor();
            return false;
        }
        catch (IOException e) {
            logger.debug(IO_EXCEPTION, (Throwable)e);
            return false;
        }
        catch (Exception e) {
            logger.debug(EXCEPTION, (Throwable)e);
        }
        return false;
    }

    private static int readProcessIdFromFile() {
        int processId = -1;
        try (FileReader fileReader = new FileReader(mainAppFile);
             BufferedReader bufferedReader = new BufferedReader(fileReader);){
            String line = bufferedReader.readLine();
            logger.debug(line);
            processId = Integer.valueOf(line);
        }
        catch (IOException | NumberFormatException e) {
            logger.debug(IO_EXCEPTION, (Throwable)e);
        }
        return processId;
    }

    private static void writeProcessIdToFile() {
        try (FileWriter fileWriter = new FileWriter(mainAppFile);){
            Integer processId = BluSyncLauncher.getCurrentProcessID();
            fileWriter.write(String.valueOf(processId));
        }
        catch (Exception e) {
            logger.debug(EXCEPTION, (Throwable)e);
        }
    }

    private static Integer getCurrentProcessID() throws NoSuchFieldException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        return Math.toIntExact(ManagementFactory.getRuntimeMXBean().getPid());
    }

    public static synchronized void unlockFile() {
        logger.debug("Running during app shutdown");
        try {
            if (mainAppFile != null) {
                mainAppFile.delete();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void changeAccount() {
        BluSyncLauncher.stopCrawlProcess();
        BluSyncLauncher.stopAllTimersOperating();
        BluSyncLauncher.killSystrayUI();
        BluSyncLauncher.deleteAllTablesAndUpdateSettingFile();
        SettingHelper.deleteNotSyncedFile();
        SettingHelper.deleteParaBluFolderPathTempFile();
        SettingHelper.deleteUserValidityFilePath();
        SettingHelper.resetBackupNotifications();
        if (SettingHelper.process != null) {
            SettingHelper.process.destroy();
        }
        try {
            SettingHelper.createNonSilentFile();
        }
        catch (IOException e) {
            logger.debug("error in crreating non silent file....", (Object)e.getMessage());
            e.printStackTrace();
        }
        logger.info("at change account");
        try {
            PropertyHelper.changeConfigProperty((String)"decoupled", (String)"true", (int)1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BluSyncLauncher.startUI();
    }

    private static void stopAllTimersOperating() {
        BluSyncLauncher.stopTimers();
    }

    public static void startUI() {
        try {
            boolean isSettingsInitialized = MacSettingsHelper.initiateSettings();
            if (!isSettingsInitialized) {
                return;
            }
            activityCleanUPTimer = new Timer();
            upgradeCheckTimer = new Timer();
            logger.info("Loading UI");
            if (PropertyHelper.INSTALL_TYPE.equalsIgnoreCase("new")) {
                logger.debug("Install type is new so deleting the old databases..");
                SettingHelper.deleteTokenFile();
                PropertyHelper.changeConfigProperty((String)"Install-type", (String)"", (int)1);
            }
            if (SettingHelper.readTokenFromFile() != null && SettingHelper.getCloudName() != null && SettingHelper.getParabluSyncFolder() != null) {
                logger.debug("Registration Id is not null");
                logger.debug("cloud anme token" + SettingHelper.getCloudName() + SettingHelper.getParabluSyncFolder());
                BluSyncLauncher.startCrawlThreadAndUI();
            } else {
                logger.debug("Started Registration");
                BluSyncLauncher.deleteOldDatabasesIfPresent();
                RegistrationView regview = new RegistrationView();
                regview.loadRegistrationUI();
                logger.debug("Registration complete");
                if (SettingHelper.readTokenFromFile() != null && SettingHelper.getCloudName() != null && SettingHelper.getParabluSyncFolder() != null) {
                    BluSyncLauncher.startCrawlThreadAndUI();
                }
            }
            BluSyncLauncher.stopTimers();
        }
        catch (Exception e) {
            logger.error("Exception in start UI: ", (Throwable)e);
            System.exit(0);
        }
    }

    private static void startCrawlThreadAndUI() throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        SettingHelper.initiateAndCreateDatabases();
        SettingHelper.alterTables();
        if ((StringUtils.isEmpty((String)PropertyHelper.OVERRIDE_IP_SETTINGS) || !StringUtils.isEmpty((String)PropertyHelper.OVERRIDE_IP_SETTINGS) && PropertyHelper.OVERRIDE_IP_SETTINGS.equalsIgnoreCase(FALSE)) && !StringUtils.isEmpty((String)PropertyHelper.MAIN_EBMS_DOMAIN)) {
            SettingHelper.checkAndUpdateIpAddress();
        }
        try {
            PropertyHelper.changeConfigProperty((String)"Override-Ip-Settings", (String)FALSE, (int)1);
        }
        catch (ConfigurationException e) {
            e.printStackTrace(System.out);
        }
        NotificationHelper.setLastSyncTime((long)SettingHelper.loadLastSuccessfulCrawl());
        SettingHelper.setLastSuccessfulBackup((long)SettingHelper.loadLastSuccessfullBackup());
        BluSyncLauncher.updateAgentVersionToServer();
        if (SettingHelper.isLicenseActive()) {
            if (SettingHelper.getSyncLicenced().contentEquals("true") && SettingHelper.getBackupLicenced().contentEquals("true")) {
                logger.info("Started crawl for sync and backup");
                BlusyncThreadHelper.initiateBackUpTimer();
                logger.info("initiated BackUpTimer");
                if (SettingHelper.getBackupLicenced().equalsIgnoreCase("true")) {
                    MacPolicyRefreshHelper.initiateBackupPolicyTimer();
                    StatisticsCollectorHelper.initiateStatisticsTimer();
                }
                BlusyncThreadHelper.initiateSyncTimer();
                logger.info("initiated SyncTimer");
                BlusyncThreadHelper.updateRestoreBatch();
            } else if (SettingHelper.getSyncLicenced().contentEquals("true") && SettingHelper.getBackupLicenced().contentEquals(FALSE)) {
                logger.info("Started crawl only for sync");
                BlusyncThreadHelper.initiateSyncTimer();
            } else if (SettingHelper.getSyncLicenced().contentEquals(FALSE) && SettingHelper.getBackupLicenced().contentEquals("true")) {
                logger.info("Started crawl (backup)");
                BlusyncThreadHelper.initiateBackUpTimer();
                if (SettingHelper.getBackupLicenced().equalsIgnoreCase("true")) {
                    MacPolicyRefreshHelper.initiateBackupPolicyTimer();
                    StatisticsCollectorHelper.initiateStatisticsTimer();
                }
                BlusyncThreadHelper.updateRestoreBatch();
            }
        }
        logger.info("Starting Activity Timer");
        activityCleanUPTimer.schedule((TimerTask)new ActivityHistoryTask(), 120000L, 86400000L);
        BluSyncLauncher.checkForUpdates();
        logger.info("Load SystemTrayUI");
        systray = SystemTrayUI.getSystemtrayInstance();
        boolean showTooltip = true;
        systray.loadSystemTray(showTooltip);
    }

    private static void checkForUpdates() {
        logger.debug("Starting Sparkle update...");
        SparkleActivator activator = new SparkleActivator();
        try {
            activator.start();
        }
        catch (Exception e) {
            logger.error("Exception while checking for updates: ", (Object)e.getMessage());
            logger.error("Exception stacktrace : ", (Throwable)e);
        }
    }

    public static void startWiproUI(String cloudName) {
        try {
            String deviceName = BluSyncLauncher.getDeviceName();
            String userName = System.getProperty("user.name");
            logger.debug("the user name is*********************" + userName + "********************" + deviceName);
            boolean isSettingsInitialized = MacSettingsHelper.initiateSettings();
            if (!isSettingsInitialized) {
                return;
            }
            activityCleanUPTimer = new Timer();
            upgradeCheckTimer = new Timer();
            logger.info("Loading UI");
            if (PropertyHelper.INSTALL_TYPE.equalsIgnoreCase("new")) {
                logger.debug("Install type is new so deleting the old databases..");
                SettingHelper.deleteTokenFile();
                PropertyHelper.changeConfigProperty((String)"Install-type", (String)"", (int)1);
            }
            if (SettingHelper.readTokenFromFile() != null && SettingHelper.getCloudName() != null && SettingHelper.getParabluSyncFolder() != null) {
                logger.debug("Registration Id is not null");
                logger.debug("inside if part");
                BluSyncLauncher.startCrawlThreadAndUI();
            } else {
                logger.debug("token stored :" + SettingHelper.readTokenFromFile());
                logger.debug("current cloud name :" + SettingHelper.getCloudName());
                logger.debug("parablu sync folder :" + SettingHelper.getParabluSyncFolder());
                logger.debug("Started Registration");
                BluSyncLauncher.deleteOldDatabasesIfPresent();
                RegistrationView regview = new RegistrationView();
                regview.loadSilentRegistration(deviceName, userName, null, cloudName);
                logger.debug("Registration complete");
                if (SettingHelper.readTokenFromFile() != null && SettingHelper.getCloudName() != null && SettingHelper.getParabluSyncFolder() != null) {
                    logger.debug("inside else part");
                    BluSyncLauncher.startCrawlThreadAndUI();
                }
            }
            BluSyncLauncher.stopTimers();
        }
        catch (Exception e) {
            logger.error("Exception in start UI: ", (Throwable)e);
            System.exit(0);
        }
    }

    static String getDeviceName() {
        String deviceName = "";
        try {
            deviceName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            logger.trace("" + e);
            logger.error("unknown Exception" + e.getMessage());
        }
        return deviceName;
    }

    private static void updateAgentVersionToServer() {
        new Thread(() -> {
            try {
                UpdateAdapter updateAdapter = new UpdateAdapter(SettingHelper.getCloudName(), SettingHelper.getKeystorePath());
                String userConsentGiven = updateAdapter.updateAgentVersionToServer(SettingHelper.getCurrentCloudIpAddress(), SettingHelper.getDeviceUUId(), SettingHelper.readTokenFromFile(), SettingHelper.getProductVersion(), "", MacSettingsHelper.getOSType(), MacSettingsHelper.getOSVersion());
                if (StringUtils.isNotEmpty((String)userConsentGiven) && userConsentGiven.equals("yes")) {
                    SettingHelper.setUserConsentGiven((boolean)true);
                } else if (StringUtils.isNotEmpty((String)userConsentGiven) && !userConsentGiven.equals("yes")) {
                    SettingHelper.setUserConsentGiven((boolean)false);
                } else {
                    SettingHelper.setUserConsentGiven((boolean)false);
                }
                if (SettingHelper.isLicenseActive() && SettingHelper.getBackupLicenced().contentEquals("true")) {
                    BlusyncThreadHelper.checkForUserConsent(display);
                }
            }
            catch (Exception e) {
                logger.error("Exception : " + e.getMessage());
                logger.trace("", (Throwable)e);
            }
        }).start();
    }

    private static void deleteOldDatabasesIfPresent() {
        logger.info("deleting Old Databases If Present");
        ArrayList<String> databaseToDeleteList = new ArrayList<String>();
        databaseToDeleteList.add(SettingHelper.getDownloadTableDBUrl());
        databaseToDeleteList.add(SettingHelper.getActivityDBUrl());
        databaseToDeleteList.add(SettingHelper.getUploadTableDBUrl());
        databaseToDeleteList.add(SettingHelper.getImageTableHistoryDBUrl());
        databaseToDeleteList.add(SettingHelper.getBackUpDbUrl());
        for (String fileToDelete : databaseToDeleteList) {
            try {
                File databaseFile = new File(fileToDelete);
                if (!databaseFile.exists()) continue;
                FileUtils.forceDelete((File)databaseFile);
            }
            catch (IOException e) {
                logger.error("Couldnt delete old databases " + e);
            }
        }
    }

    private static synchronized void stopTimers() {
        logger.info("stop Timers");
        if (activityCleanUPTimer != null) {
            activityCleanUPTimer.cancel();
            activityCleanUPTimer = null;
        }
        if (upgradeCheckTimer != null) {
            upgradeCheckTimer.cancel();
            upgradeCheckTimer = null;
        }
        if (!SettingHelper.getSyncLicenced().contentEquals(FALSE)) {
            MacPolicyRefreshHelper.cancelBSyncPolicyTimer();
        }
        if (!SettingHelper.getBackupLicenced().contentEquals(FALSE)) {
            MacPolicyRefreshHelper.cancelBackupPolicyTimer();
            StatisticsCollectorHelper.cancelStatisticsTimer();
        }
    }

    private static void stopCrawlProcess() {
        if (!SettingHelper.getSyncLicenced().contentEquals(FALSE)) {
            BlusyncThreadHelper.cancelSyncTimer();
            BlusyncThreadHelper.cancelCurrentSyncProcess();
        }
        if (!SettingHelper.getBackupLicenced().contentEquals(FALSE)) {
            BlusyncThreadHelper.cancelCurrentBackupProcess(false, false, false);
            BlusyncThreadHelper.interruptParentBackupThread();
            BlusyncThreadHelper.cancelBackupTimer();
        }
    }

    private static void updateBackupStatus() {
        if (!SettingHelper.getBackupLicenced().contentEquals(FALSE) && NotificationHelper.isBackUpStarted()) {
            PolicyManagementServerHelper.updateFailCodeToActivityHistory((int)911);
            PolicyManagementServerHelper.sendCurrentStatisticsToServerBeforeExit((String)"STOPPED", (boolean)false);
        }
    }

    private static void deleteAllTablesAndUpdateSettingFile() {
        String paraBluDatabaseFolder = SettingHelper.getBaseDBUrl();
        int sleepTime = 400;
        File databaseFolders = new File(paraBluDatabaseFolder);
        try {
            FileUtils.forceDelete((File)databaseFolders);
        }
        catch (IOException e) {
            logger.debug("retrying Delete Database" + e);
            BluSyncLauncher.retryDeleteDatabase(databaseFolders, sleepTime);
        }
        SettingHelper.resetSharedPreferences();
        SettingHelper.deleteTokenFile();
    }

    public static void retryDeleteDatabase(File databaseFolders, int sleepTime) {
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException e1) {
            logger.trace("" + e1);
            logger.error("interrupted exception" + e1.getMessage());
        }
        try {
            FileUtils.forceDelete((File)databaseFolders);
        }
        catch (IOException e1) {
            logger.trace("" + e1);
            logger.error("IOException " + e1.getMessage());
        }
    }

    private static void killSystrayUI() {
        systray.disposeSystrayUIShells();
    }

    static {
        logger = LoggerFactory.getLogger(BluSyncLauncher.class);
        activityCleanUPTimer = null;
        upgradeCheckTimer = null;
        isSilent = "";
        certName = null;
        display = null;
    }

    static class ShutdownHook
    extends Thread {
        ShutdownHook() {
        }

        @Override
        public void run() {
            BluSyncLauncher.unlockFile();
        }
    }
}

