/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class OriginatorPublicKey
implements DEREncodable {
    private AlgorithmIdentifier algorithm;
    private DERBitString publicKey;

    public OriginatorPublicKey(AlgorithmIdentifier algorithmIdentifier, byte[] byArray) {
        this.setAlgorithm(algorithmIdentifier);
        this.setPublicKey(byArray);
    }

    public OriginatorPublicKey(BERConstructedSequence bERConstructedSequence) {
        DEREncodable dEREncodable = bERConstructedSequence.getObjectAt(0);
        if (dEREncodable instanceof AlgorithmIdentifier) {
            this.algorithm = (AlgorithmIdentifier)dEREncodable;
        } else if (dEREncodable instanceof DERObjectIdentifier) {
            this.algorithm = new AlgorithmIdentifier((DERObjectIdentifier)dEREncodable);
        } else if (dEREncodable instanceof BERConstructedSequence) {
            this.algorithm = new AlgorithmIdentifier((BERConstructedSequence)dEREncodable);
        } else {
            throw new IllegalArgumentException("Invalid AlgorithmIdentifier");
        }
        this.publicKey = (DERBitString)bERConstructedSequence.getObjectAt(1);
    }

    public OriginatorPublicKey(OriginatorPublicKey originatorPublicKey) {
        this.algorithm = originatorPublicKey.algorithm;
        this.publicKey = originatorPublicKey.publicKey;
    }

    public static OriginatorPublicKey getInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof OriginatorPublicKey) {
            return (OriginatorPublicKey)object;
        }
        if (object instanceof BERConstructedSequence) {
            return new OriginatorPublicKey((BERConstructedSequence)object);
        }
        if (object instanceof BERTaggedObject) {
            return OriginatorPublicKey.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid OriginatorPublicKey");
    }

    public static OriginatorPublicKey newInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof OriginatorPublicKey) {
            return new OriginatorPublicKey((OriginatorPublicKey)object);
        }
        if (object instanceof BERConstructedSequence) {
            return new OriginatorPublicKey((BERConstructedSequence)object);
        }
        if (object instanceof BERTaggedObject) {
            return OriginatorPublicKey.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid OriginatorPublicKey");
    }

    public AlgorithmIdentifier getAlgorithm() {
        return this.algorithm;
    }

    private void setAlgorithm(AlgorithmIdentifier algorithmIdentifier) {
        this.algorithm = algorithmIdentifier;
    }

    public byte[] getPublicKey() {
        return this.publicKey.getBytes();
    }

    private void setPublicKey(byte[] byArray) {
        this.publicKey = new DERBitString(byArray);
    }

    public DERObject getDERObject() {
        BERConstructedSequence bERConstructedSequence = new BERConstructedSequence();
        bERConstructedSequence.addObject(this.algorithm);
        bERConstructedSequence.addObject(this.publicKey);
        return bERConstructedSequence;
    }
}

