/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.cms.OtherKeyAttribute;

public class KEKIdentifier
implements DEREncodable {
    private DEROctetString keyIdentifier;
    private DERGeneralizedTime date;
    private OtherKeyAttribute other;

    public KEKIdentifier(byte[] byArray, String string, OtherKeyAttribute otherKeyAttribute) {
        this.setKeyIdentifier(byArray);
        this.setDate(string);
        this.setOther(otherKeyAttribute);
    }

    public KEKIdentifier(BERConstructedSequence bERConstructedSequence) {
        this.keyIdentifier = (DEROctetString)bERConstructedSequence.getObjectAt(0);
        switch (bERConstructedSequence.getSize()) {
            case 1: {
                break;
            }
            case 2: {
                try {
                    this.date = (DERGeneralizedTime)bERConstructedSequence.getObjectAt(1);
                }
                catch (Exception exception) {
                    this.other = OtherKeyAttribute.getInstance(bERConstructedSequence.getObjectAt(2));
                }
                break;
            }
            case 3: {
                this.date = (DERGeneralizedTime)bERConstructedSequence.getObjectAt(1);
                this.other = OtherKeyAttribute.getInstance(bERConstructedSequence.getObjectAt(2));
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid KEKIdentifier");
            }
        }
    }

    public KEKIdentifier(KEKIdentifier kEKIdentifier) {
        this.keyIdentifier = kEKIdentifier.keyIdentifier;
        this.date = kEKIdentifier.date;
        this.other = kEKIdentifier.other;
    }

    public static KEKIdentifier getInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof KEKIdentifier) {
            return (KEKIdentifier)object;
        }
        if (object instanceof BERConstructedSequence) {
            return new KEKIdentifier((BERConstructedSequence)object);
        }
        if (object instanceof BERTaggedObject) {
            return KEKIdentifier.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid KEKIdentifier");
    }

    public static KEKIdentifier newInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof KEKIdentifier) {
            return new KEKIdentifier((KEKIdentifier)object);
        }
        if (object instanceof BERConstructedSequence) {
            return new KEKIdentifier((BERConstructedSequence)object);
        }
        if (object instanceof BERTaggedObject) {
            return KEKIdentifier.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid KEKIdentifier");
    }

    public byte[] getKeyIdentifier() {
        return this.keyIdentifier.getOctets();
    }

    private void setKeyIdentifier(byte[] byArray) {
        this.keyIdentifier = new DEROctetString(byArray);
    }

    public String getDate() {
        return this.date.getTime();
    }

    private void setDate(String string) {
        this.date = new DERGeneralizedTime(string);
    }

    public OtherKeyAttribute getOther() {
        return this.other;
    }

    private void setOther(OtherKeyAttribute otherKeyAttribute) {
        this.other = otherKeyAttribute;
    }

    public DERObject getDERObject() {
        BERConstructedSequence bERConstructedSequence = new BERConstructedSequence();
        bERConstructedSequence.addObject(this.keyIdentifier);
        if (this.date != null) {
            bERConstructedSequence.addObject(this.date);
        }
        if (this.other != null) {
            bERConstructedSequence.addObject(this.other);
        }
        return bERConstructedSequence;
    }
}

