/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class DigestAlgorithmIdentifier
implements DEREncodable {
    private AlgorithmIdentifier alg;

    public DigestAlgorithmIdentifier(AlgorithmIdentifier algorithmIdentifier) {
        this.setAlgorithmIdentifier(algorithmIdentifier);
    }

    public DigestAlgorithmIdentifier(BERConstructedSequence bERConstructedSequence) {
        this.alg = new AlgorithmIdentifier(bERConstructedSequence);
    }

    public DigestAlgorithmIdentifier(DigestAlgorithmIdentifier digestAlgorithmIdentifier) {
        this.alg = digestAlgorithmIdentifier.alg;
    }

    public DigestAlgorithmIdentifier(DERObjectIdentifier dERObjectIdentifier) {
        this.alg = new AlgorithmIdentifier(dERObjectIdentifier);
    }

    public DigestAlgorithmIdentifier(DERObjectIdentifier dERObjectIdentifier, DERObject dERObject) {
        this.alg = new AlgorithmIdentifier(dERObjectIdentifier, dERObject);
    }

    public static DigestAlgorithmIdentifier getInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof DigestAlgorithmIdentifier) {
            return (DigestAlgorithmIdentifier)object;
        }
        if (object instanceof BERConstructedSequence) {
            return new DigestAlgorithmIdentifier((BERConstructedSequence)object);
        }
        if (object instanceof DERObjectIdentifier) {
            return new DigestAlgorithmIdentifier((DERObjectIdentifier)object);
        }
        if (object instanceof BERTaggedObject) {
            return DigestAlgorithmIdentifier.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid DigestAlgorithmIdentifier");
    }

    public static DigestAlgorithmIdentifier newInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof DigestAlgorithmIdentifier) {
            return new DigestAlgorithmIdentifier((DigestAlgorithmIdentifier)object);
        }
        if (object instanceof BERConstructedSequence) {
            return new DigestAlgorithmIdentifier((BERConstructedSequence)object);
        }
        if (object instanceof DERObjectIdentifier) {
            return new DigestAlgorithmIdentifier((DERObjectIdentifier)object);
        }
        if (object instanceof BERTaggedObject) {
            return DigestAlgorithmIdentifier.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid DigestAlgorithmIdentifier");
    }

    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.alg;
    }

    private void setAlgorithmIdentifier(AlgorithmIdentifier algorithmIdentifier) {
        this.alg = algorithmIdentifier;
    }

    public DERObject getDERObject() {
        return this.alg.getDERObject();
    }
}

