/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.helper.utils;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReparsePointUtils {
    private static final int MICROSOFT_REPARSE_TAG_MASK = Integer.MIN_VALUE;
    private static final int IO_REPARSE_TAG_CLOUD_MASK = 61440;
    private static Logger logger = LoggerFactory.getLogger(ReparsePointUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WinBase.WIN32_FIND_DATA getWin32FindDataForFile(String absoluteFilePath) {
        Kernel32 kernel = Kernel32.INSTANCE;
        WinNT.HANDLE hFile = WinBase.INVALID_HANDLE_VALUE;
        try {
            Memory p = new Memory((long)WinBase.WIN32_FIND_DATA.sizeOf());
            hFile = kernel.FindFirstFile(absoluteFilePath, (Pointer)p);
            if (!WinBase.INVALID_HANDLE_VALUE.equals((Object)hFile)) {
                WinBase.WIN32_FIND_DATA fd;
                WinBase.WIN32_FIND_DATA wIN32_FIND_DATA = fd = new WinBase.WIN32_FIND_DATA((Pointer)p);
                return wIN32_FIND_DATA;
            }
            int lastError = kernel.GetLastError();
            logger.debug("Failed to get win32 find data information for " + absoluteFilePath + " ,Error = " + lastError);
        }
        catch (Exception e) {
            logger.debug("Exception while getting win32 find data information for " + absoluteFilePath + " " + e.getMessage());
        }
        finally {
            if (!WinBase.INVALID_HANDLE_VALUE.equals((Object)hFile)) {
                kernel.FindClose(hFile);
            }
        }
        return null;
    }

    private int getReparseTagValueForFile(String absoluteFilePath) {
        try {
            WinBase.WIN32_FIND_DATA fd = this.getWin32FindDataForFile(absoluteFilePath);
            if (fd != null && (fd.dwFileAttributes & 0x400) > 0) {
                return fd.dwReserved0;
            }
        }
        catch (Exception e) {
            logger.debug("Failed to get reparse tag value for " + absoluteFilePath + " " + e.getMessage());
        }
        return 0;
    }

    public boolean checkMSReparseTagForFile(String absoluteFilePath) {
        try {
            int reparseTagValue = this.getReparseTagValueForFile(absoluteFilePath);
            if (reparseTagValue != 0 && (reparseTagValue & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
                logger.debug("Found Microsoft reparse tag for " + absoluteFilePath);
                return true;
            }
        }
        catch (Exception e) {
            logger.debug("Failed to check Microsoft reparse tag for " + absoluteFilePath + " " + e.getMessage());
        }
        return false;
    }

    public boolean checkMSCloudReparseTagForFile(String absoluteFilePath) {
        try {
            int reparseTagValue = this.getReparseTagValueForFile(absoluteFilePath);
            if (reparseTagValue != 0 && (reparseTagValue & Integer.MIN_VALUE) == Integer.MIN_VALUE && (reparseTagValue & 0xF000) != 0) {
                logger.debug("Found Microsoft cloud reparse tag for " + absoluteFilePath);
                return true;
            }
        }
        catch (Exception e) {
            logger.debug("Failed to check Microsoft cloud reparse tag for " + absoluteFilePath + " " + e.getMessage());
        }
        return false;
    }

    public boolean checkMSMountPointReparseTagForFile(String absoluteFilePath) {
        try {
            int reparseTagValue = this.getReparseTagValueForFile(absoluteFilePath);
            if (reparseTagValue != 0 && (reparseTagValue & Integer.MIN_VALUE) == Integer.MIN_VALUE && reparseTagValue == -1610612733) {
                logger.debug("Found Microsoft mount point reparse tag for " + absoluteFilePath);
                return true;
            }
        }
        catch (Exception e) {
            logger.debug("Failed to check Microsoft mount point reparse tag for " + absoluteFilePath + " " + e.getMessage());
        }
        return false;
    }

    public boolean checkMSSymLinkReparseTagForFile(String absoluteFilePath) {
        try {
            int reparseTagValue = this.getReparseTagValueForFile(absoluteFilePath);
            if (reparseTagValue != 0 && (reparseTagValue & Integer.MIN_VALUE) == Integer.MIN_VALUE && reparseTagValue == -1610612724) {
                logger.debug("Found Microsoft sym link reparse tag for " + absoluteFilePath);
                return true;
            }
        }
        catch (Exception e) {
            logger.debug("Failed to check Microsoft sym link reparse tag for " + absoluteFilePath + " " + e.getMessage());
        }
        return false;
    }
}

