/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.win32.HDITEM;
import org.eclipse.swt.internal.win32.LVCOLUMN;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TOOLINFO;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TypedListener;

public class TableColumn
extends Item {
    Table parent;
    boolean resizable = true;
    boolean moveable;
    String toolTipText;
    int id;

    public TableColumn(Table table, int n) {
        super(table, TableColumn.checkStyle(n));
        this.parent = table;
        table.createItem(this, table.getColumnCount());
    }

    public TableColumn(Table table, int n, int n2) {
        super(table, TableColumn.checkStyle(n));
        this.parent = table;
        table.createItem(this, n2);
    }

    public void addControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(controlListener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n) {
        return TableColumn.checkBits(n, 16384, 0x1000000, 131072, 0, 0, 0);
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    @Override
    String getNameText() {
        return this.getText();
    }

    public Table getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getMoveable() {
        this.checkWidget();
        return this.moveable;
    }

    public boolean getResizable() {
        this.checkWidget();
        return this.resizable;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public int getWidth() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getWidthInPixels());
    }

    int getWidthInPixels() {
        int n = this.parent.indexOf(this);
        if (n == -1) {
            return 0;
        }
        int n2 = this.parent.handle;
        return OS.SendMessage(n2, 4125, n, 0);
    }

    public void pack() {
        int n;
        int n2;
        int n3;
        int n4;
        this.checkWidget();
        int n5 = this.parent.indexOf(this);
        if (n5 == -1) {
            return;
        }
        int n6 = this.parent.handle;
        int n7 = OS.SendMessage(n6, 4125, n5, 0);
        TCHAR tCHAR = new TCHAR(this.parent.getCodePage(), this.text, true);
        int n8 = OS.SendMessage(n6, OS.LVM_GETSTRINGWIDTH, 0, tCHAR) + 12;
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            n8 += 3;
        }
        boolean bl = false;
        if (this.image != null || this.parent.sortColumn == this) {
            bl = true;
            Image image = null;
            if (this.parent.sortColumn == this && this.parent.sortDirection != 0) {
                if (OS.COMCTL32_MAJOR < 6) {
                    image = this.display.getSortImage(this.parent.sortDirection);
                } else {
                    n8 += 10;
                }
            } else {
                image = this.image;
            }
            if (image != null) {
                Rectangle rectangle = image.getBoundsInPixels();
                n8 += rectangle.width;
            }
            n4 = 0;
            if (OS.COMCTL32_VERSION >= OS.VERSION(5, 80)) {
                n3 = OS.SendMessage(n6, 4127, 0, 0);
                n4 = OS.SendMessage(n3, 4629, 0, 0);
            } else {
                n4 = OS.GetSystemMetrics(45) * 3;
            }
            n8 += n4 * 4;
        }
        this.parent.ignoreColumnResize = true;
        int n9 = 0;
        if (this.parent.hooks(41)) {
            RECT rECT = new RECT();
            n3 = OS.SendMessage(n6, 4127, 0, 0);
            OS.SendMessage(n3, 4615, n5, rECT);
            OS.MapWindowPoints(n3, n6, rECT, 2);
            n2 = OS.GetDC(n6);
            int n10 = 0;
            n = OS.SendMessage(n6, 49, 0, 0);
            if (n != 0) {
                n10 = OS.SelectObject(n2, n);
            }
            int n11 = OS.SendMessage(n6, 4100, 0, 0);
            for (int i = 0; i < n11; ++i) {
                TableItem tableItem = this.parent._getItem(i, false);
                if (tableItem == null) continue;
                int n12 = tableItem.fontHandle(n5);
                if (n12 != -1) {
                    n12 = OS.SelectObject(n2, n12);
                }
                Event event = this.parent.sendMeasureItemEvent(tableItem, i, n5, n2);
                if (n12 != -1) {
                    n12 = OS.SelectObject(n2, n12);
                }
                if (this.isDisposed() || this.parent.isDisposed()) break;
                Rectangle rectangle = event.getBoundsInPixels();
                n9 = Math.max(n9, rectangle.x + rectangle.width - rECT.left);
            }
            if (n != 0) {
                OS.SelectObject(n2, n10);
            }
            OS.ReleaseDC(n6, n2);
            OS.SendMessage(n6, 4126, n5, n9);
        } else {
            OS.SendMessage(n6, 4126, n5, -1);
            n9 = OS.SendMessage(n6, 4125, n5, 0);
            if (n5 == 0) {
                int[] nArray;
                if (this.parent.imageList == null) {
                    n9 += 2;
                }
                if (!OS.IsWinCE && OS.WIN32_VERSION < OS.VERSION(6, 0) && !this.parent.firstColumnImage && (n4 = OS.SendMessage(n6, 4098, 1, 0)) != 0) {
                    int[] nArray2 = new int[1];
                    nArray = new int[1];
                    OS.ImageList_GetIconSize(n4, nArray2, nArray);
                    n9 += nArray2[0];
                }
                if ((this.parent.style & 0x20) != 0 && (n4 = OS.SendMessage(n6, 4098, 2, 0)) != 0) {
                    int[] nArray3 = new int[1];
                    nArray = new int[1];
                    OS.ImageList_GetIconSize(n4, nArray3, nArray);
                    n9 += nArray3[0];
                }
            }
        }
        if (n8 > n9) {
            if (!bl) {
                boolean bl2;
                RECT rECT = null;
                boolean bl3 = bl2 = n5 == this.parent.getColumnCount() - 1;
                if (bl2) {
                    rECT = new RECT();
                    OS.GetWindowRect(n6, rECT);
                    OS.UpdateWindow(n6);
                    n2 = 30;
                    this.SetWindowPos(n6, 0, 0, 0, 0, rECT.bottom - rECT.top, n2);
                }
                OS.SendMessage(n6, 4126, n5, -2);
                if (bl2) {
                    n2 = 22;
                    this.SetWindowPos(n6, 0, 0, 0, rECT.right - rECT.left, rECT.bottom - rECT.top, n2);
                }
            } else {
                OS.SendMessage(n6, 4126, n5, n8);
            }
        } else if (n5 == 0) {
            OS.SendMessage(n6, 4126, n5, n9);
        }
        this.parent.ignoreColumnResize = false;
        int n13 = OS.SendMessage(n6, 4125, n5, 0);
        if (n7 != n13) {
            this.updateToolTip(n5);
            this.sendEvent(11);
            if (this.isDisposed()) {
                return;
            }
            boolean bl4 = false;
            int[] nArray = this.parent.getColumnOrder();
            TableColumn[] tableColumnArray = this.parent.getColumns();
            for (n = 0; n < nArray.length; ++n) {
                TableColumn tableColumn = tableColumnArray[nArray[n]];
                if (bl4 && !tableColumn.isDisposed()) {
                    tableColumn.updateToolTip(nArray[n]);
                    tableColumn.sendEvent(10);
                }
                if (tableColumn != this) continue;
                bl4 = true;
            }
        }
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
    }

    @Override
    void releaseParent() {
        super.releaseParent();
        if (this.parent.sortColumn == this) {
            this.parent.sortColumn = null;
        }
    }

    public void removeControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(10, controlListener);
        this.eventTable.unhook(11, controlListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void setAlignment(int n) {
        this.checkWidget();
        if ((n & 0x1024000) == 0) {
            return;
        }
        int n2 = this.parent.indexOf(this);
        if (n2 == -1 || n2 == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= n & 0x1024000;
        int n3 = this.parent.handle;
        LVCOLUMN lVCOLUMN = new LVCOLUMN();
        lVCOLUMN.mask = 1;
        OS.SendMessage(n3, OS.LVM_GETCOLUMN, n2, lVCOLUMN);
        lVCOLUMN.fmt &= 0xFFFFFFFC;
        int n4 = 0;
        if ((this.style & 0x4000) == 16384) {
            n4 = 0;
        }
        if ((this.style & 0x1000000) == 0x1000000) {
            n4 = 2;
        }
        if ((this.style & 0x20000) == 131072) {
            n4 = 1;
        }
        lVCOLUMN.fmt |= n4;
        OS.SendMessage(n3, OS.LVM_SETCOLUMN, n2, lVCOLUMN);
        if (n2 != 0) {
            this.parent.forceResize();
            RECT rECT = new RECT();
            RECT rECT2 = new RECT();
            OS.GetClientRect(n3, rECT);
            int n5 = OS.SendMessage(n3, 4127, 0, 0);
            OS.SendMessage(n5, 4615, n2, rECT2);
            OS.MapWindowPoints(n5, n3, rECT2, 2);
            rECT.left = rECT2.left;
            rECT.right = rECT2.right;
            OS.InvalidateRect(n3, rECT, true);
        }
    }

    @Override
    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        super.setImage(image);
        if (this.parent.sortColumn != this || this.parent.sortDirection != 0) {
            this.setImage(image, false, false);
        }
    }

    void setImage(Image image, boolean bl, boolean bl2) {
        int n = this.parent.indexOf(this);
        if (n == -1) {
            return;
        }
        int n2 = this.parent.handle;
        if (OS.COMCTL32_MAJOR < 6) {
            int n3 = OS.SendMessage(n2, 4127, 0, 0);
            HDITEM hDITEM = new HDITEM();
            hDITEM.mask = 52;
            OS.SendMessage(n3, OS.HDM_GETITEM, n, hDITEM);
            hDITEM.fmt &= 0xFFFFEFFF;
            if (image != null) {
                if (bl) {
                    hDITEM.mask &= 0xFFFFFFDF;
                    hDITEM.fmt &= 0xFFFFF7FF;
                    hDITEM.fmt |= 0x2000;
                    hDITEM.hbm = image.handle;
                } else {
                    hDITEM.mask &= 0xFFFFFFEF;
                    hDITEM.fmt &= 0xFFFFDFFF;
                    hDITEM.fmt |= 0x800;
                    hDITEM.iImage = this.parent.imageIndexHeader(image);
                }
                if (bl2) {
                    hDITEM.fmt |= 0x1000;
                }
            } else {
                hDITEM.fmt &= 0xFFFFD7FF;
            }
            OS.SendMessage(n3, OS.HDM_SETITEM, n, hDITEM);
        } else {
            LVCOLUMN lVCOLUMN = new LVCOLUMN();
            lVCOLUMN.mask = 17;
            OS.SendMessage(n2, OS.LVM_GETCOLUMN, n, lVCOLUMN);
            if (image != null) {
                lVCOLUMN.fmt |= 0x800;
                lVCOLUMN.iImage = this.parent.imageIndexHeader(image);
                if (bl2) {
                    lVCOLUMN.fmt |= 0x1000;
                }
            } else {
                lVCOLUMN.mask &= 0xFFFFFFEF;
                lVCOLUMN.fmt &= 0xFFFFE7FF;
            }
            OS.SendMessage(n2, OS.LVM_SETCOLUMN, n, lVCOLUMN);
        }
    }

    public void setMoveable(boolean bl) {
        this.checkWidget();
        this.moveable = bl;
        this.parent.updateMoveable();
    }

    public void setResizable(boolean bl) {
        this.checkWidget();
        this.resizable = bl;
    }

    void setSortDirection(int n) {
        if (OS.COMCTL32_MAJOR >= 6) {
            RECT rECT;
            int n2 = this.parent.indexOf(this);
            if (n2 == -1) {
                return;
            }
            int n3 = this.parent.handle;
            int n4 = OS.SendMessage(n3, 4127, 0, 0);
            HDITEM hDITEM = new HDITEM();
            hDITEM.mask = 36;
            OS.SendMessage(n4, OS.HDM_GETITEM, n2, hDITEM);
            switch (n) {
                case 128: {
                    hDITEM.fmt &= 0xFFFFF5FF;
                    hDITEM.fmt |= 0x400;
                    if (this.image != null) break;
                    hDITEM.mask &= 0xFFFFFFDF;
                    break;
                }
                case 1024: {
                    hDITEM.fmt &= 0xFFFFF3FF;
                    hDITEM.fmt |= 0x200;
                    if (this.image != null) break;
                    hDITEM.mask &= 0xFFFFFFDF;
                    break;
                }
                case 0: {
                    hDITEM.fmt &= 0xFFFFF9FF;
                    if (this.image != null) {
                        hDITEM.fmt |= 0x800;
                        hDITEM.iImage = this.parent.imageIndexHeader(this.image);
                        break;
                    }
                    hDITEM.fmt &= 0xFFFFF7FF;
                    hDITEM.mask &= 0xFFFFFFDF;
                }
            }
            OS.SendMessage(n4, OS.HDM_SETITEM, n2, hDITEM);
            this.parent.forceResize();
            RECT rECT2 = new RECT();
            OS.GetClientRect(n3, rECT2);
            if (OS.SendMessage(n3, 4096, 0, 0) != -1) {
                int n5 = OS.SendMessage(n3, 4270, 0, 0);
                int n6 = n == 0 ? -1 : n2;
                OS.SendMessage(n3, 4236, n6, 0);
                RECT rECT3 = new RECT();
                if (n5 != -1 && OS.SendMessage(n4, 4615, n5, rECT3) != 0) {
                    OS.MapWindowPoints(n4, n3, rECT3, 2);
                    rECT2.left = rECT3.left;
                    rECT2.right = rECT3.right;
                    OS.InvalidateRect(n3, rECT2, true);
                }
            }
            if (OS.SendMessage(n4, 4615, n2, rECT = new RECT()) != 0) {
                OS.MapWindowPoints(n4, n3, rECT, 2);
                rECT2.left = rECT.left;
                rECT2.right = rECT.right;
                OS.InvalidateRect(n3, rECT2, true);
            }
        } else {
            switch (n) {
                case 128: 
                case 1024: {
                    this.setImage(this.display.getSortImage(n), true, true);
                    break;
                }
                case 0: {
                    this.setImage(this.image, false, false);
                }
            }
        }
    }

    @Override
    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (string.equals(this.text)) {
            return;
        }
        int n = this.parent.indexOf(this);
        if (n == -1) {
            return;
        }
        super.setText(string);
        int n2 = this.parent.handle;
        LVCOLUMN lVCOLUMN = new LVCOLUMN();
        lVCOLUMN.mask = 1;
        OS.SendMessage(n2, OS.LVM_GETCOLUMN, n, lVCOLUMN);
        boolean bl = !OS.IsWinCE && OS.WIN32_VERSION <= OS.VERSION(4, 10);
        int n3 = OS.GetProcessHeap();
        TCHAR tCHAR = new TCHAR(this.parent.getCodePage(), this.fixMnemonic(string, bl), true);
        int n4 = tCHAR.length() * TCHAR.sizeof;
        int n5 = OS.HeapAlloc(n3, 8, n4);
        OS.MoveMemory(n5, tCHAR, n4);
        lVCOLUMN.mask |= 4;
        lVCOLUMN.pszText = n5;
        int n6 = OS.SendMessage(n2, OS.LVM_SETCOLUMN, n, lVCOLUMN);
        if (n5 != 0) {
            OS.HeapFree(n3, 0, n5);
        }
        if (n6 == 0) {
            this.error(13);
        }
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
        int n = this.parent.headerToolTipHandle;
        if (n == 0) {
            this.parent.createHeaderToolTips();
            this.parent.updateHeaderToolTips();
        }
    }

    public void setWidth(int n) {
        this.checkWidget();
        this.setWidthInPixels(DPIUtil.autoScaleUp(n));
    }

    void setWidthInPixels(int n) {
        if (n < 0) {
            return;
        }
        int n2 = this.parent.indexOf(this);
        if (n2 == -1) {
            return;
        }
        int n3 = this.parent.handle;
        if (n != OS.SendMessage(n3, 4125, n2, 0)) {
            OS.SendMessage(n3, 4126, n2, n);
        }
    }

    void updateToolTip(int n) {
        RECT rECT;
        int n2;
        int n3;
        int n4 = this.parent.headerToolTipHandle;
        if (n4 != 0 && OS.SendMessage(n3 = OS.SendMessage(n2 = this.parent.handle, 4127, 0, 0), 4615, n, rECT = new RECT()) != 0) {
            TOOLINFO tOOLINFO = new TOOLINFO();
            tOOLINFO.cbSize = TOOLINFO.sizeof;
            tOOLINFO.hwnd = n3;
            tOOLINFO.uId = this.id;
            tOOLINFO.left = rECT.left;
            tOOLINFO.top = rECT.top;
            tOOLINFO.right = rECT.right;
            tOOLINFO.bottom = rECT.bottom;
            OS.SendMessage(n4, OS.TTM_NEWTOOLRECT, 0, tOOLINFO);
        }
    }
}

