/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.core.adapter.pcb;

import com.parablu.epa.core.adapter.BaseAdapter;
import com.parablu.epa.core.exception.CrawlAdapterException;
import com.parablu.epa.core.helper.UpdateHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateAdapter
extends BaseAdapter {
    private Logger logger = LoggerFactory.getLogger(UpdateAdapter.class);
    private static final String CLOUD = "/cloud";
    String isRollbackEnabled = null;

    public UpdateAdapter(String cloudName, String keyStorePath) {
        super(cloudName, keyStorePath);
    }

    public UpdateAdapter(InputStream stream, String cloudName) {
        super(stream, cloudName);
    }

    public String checkCloudForVersion(String ip, Integer port, String productVersion, String productType, String deviceUUID) {
        this.logger.debug("Entering check cloud for version");
        String cloudVersion = null;
        HttpResponse httpResponse = null;
        try {
            String updateUrl = "/update/details";
            URI uri = port != null ? this.formHttpsUri(ip, port, "/paracloud/cloud" + this.cloudName + updateUrl) : this.formHttpsUri(ip, "/paracloud/cloud" + this.cloudName + updateUrl);
            HttpPost httpPost = new HttpPost(uri);
            this.logger.debug("URL for check service version: " + uri);
            httpPost.setHeader("version-type", productType);
            httpPost.setHeader("current-version", productVersion);
            httpPost.setHeader("deviceUUID", deviceUUID);
            this.logger.debug("deviceUUID: " + deviceUUID);
            httpResponse = this.httpclient.execute((HttpUriRequest)httpPost);
            this.logger.debug("httpResponse: " + httpResponse);
        }
        catch (Exception e) {
            this.logger.error("Exception", (Throwable)e);
            this.closeResponseEntity(httpResponse);
            throw new CrawlAdapterException("Exception:", e);
        }
        if (httpResponse == null) {
            this.logger.debug("Inside http response is null....");
            return null;
        }
        if (httpResponse.getStatusLine().getStatusCode() == 200) {
            String isAutoUpdateEnabled = httpResponse.getFirstHeader("autoUpdateEnabled").getValue();
            this.logger.debug("cloudVersion: " + cloudVersion + isAutoUpdateEnabled);
            cloudVersion = httpResponse.getFirstHeader("current-version").getValue();
            this.logger.debug("cloudVersion: " + cloudVersion);
            this.isRollbackEnabled = httpResponse.getFirstHeader("rollBack").getValue();
            this.logger.debug("Roll Back" + this.isRollbackEnabled);
        } else if (httpResponse.getStatusLine().getStatusCode() == 430) {
            cloudVersion = "UpdateDisabled";
        } else {
            this.logger.debug("httpResponse code: " + httpResponse.getStatusLine().getStatusCode());
            this.closeResponseEntity(httpResponse);
            throw new CrawlAdapterException("httpResponse code:" + httpResponse.getStatusLine().getStatusCode());
        }
        if (StringUtils.isNotEmpty((String)this.isRollbackEnabled)) {
            UpdateHelper.setRollbackEnabled(Boolean.valueOf(this.isRollbackEnabled));
        }
        this.closeResponseEntity(httpResponse);
        return cloudVersion;
    }

    private void closeResponseEntity(HttpResponse httpResponse) {
        try {
            if (httpResponse != null && httpResponse.getEntity() != null && httpResponse.getEntity().getContent() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
        catch (IOException e) {
            this.logger.error("Exception", (Throwable)e);
        }
    }

    public boolean downloadLatestVersion(String ip, Integer port, String cloudName, String productVersion, String productType, String downloadUrl, String deviceUUID, boolean serviceUpdate) {
        HttpResponse httpResponse = null;
        boolean downloaded = false;
        this.logger.debug("Inside UpdateAdapter.downloadLatestVersion ");
        this.logger.debug("Values : IP" + ip + " Port :" + port + " Cloud name :" + cloudName + " productVersion :" + productVersion + " productType :" + productType);
        try {
            URI uri = port != null ? this.formHttpsUri(ip, port, "/paracloud/cloud" + this.cloudName + "/update/download") : this.formHttpsUri(ip, "/paracloud/cloud" + this.cloudName + "/update/download");
            this.logger.debug("Going to execute url " + uri);
            this.logger.debug("Headers version-type:" + productType);
            this.logger.debug("Headers current-version:" + productVersion);
            HttpGet httpGet = new HttpGet(uri);
            httpGet.setHeader("version-type", productType);
            httpGet.setHeader("current-version", productVersion);
            httpGet.setHeader("deviceUUID", deviceUUID);
            if (serviceUpdate) {
                httpGet.setHeader("serviceUpdate", String.valueOf(serviceUpdate));
            }
            httpResponse = this.httpclient.execute((HttpUriRequest)httpGet);
            this.logger.debug("HTTP Response " + httpResponse.getStatusLine().getStatusCode());
        }
        catch (Exception e) {
            this.logger.error("Exception", (Throwable)e);
            this.closeResponseEntity(httpResponse);
            throw new CrawlAdapterException("Exception:", e);
        }
        try {
            if (httpResponse.getStatusLine() == null) {
                this.logger.error("Error 1 during upgrade");
            }
            int responseCode = httpResponse.getStatusLine().getStatusCode();
            this.logger.debug("Response code " + responseCode);
            if (responseCode == 200 && httpResponse.getEntity() != null) {
                downloaded = this.downloadUpdate(downloadUrl, httpResponse);
            }
            this.closeResponseEntity(httpResponse);
        }
        catch (IllegalStateException e) {
            this.logger.error("Exception", (Throwable)e);
            this.closeResponseEntity(httpResponse);
            throw new CrawlAdapterException("Exception:", e);
        }
        return downloaded;
    }

    private boolean downloadUpdate(String downloadUrl, HttpResponse httpResponse) {
        boolean isDownloaded = false;
        try (FileOutputStream fileOS = new FileOutputStream(new File(downloadUrl));){
            this.logger.debug(" Going to download to " + downloadUrl);
            IOUtils.copy((InputStream)httpResponse.getEntity().getContent(), (OutputStream)fileOS);
            isDownloaded = true;
        }
        catch (Exception e) {
            this.logger.error("Exception", (Throwable)e);
            throw new CrawlAdapterException("Exception:", e);
        }
        return isDownloaded;
    }

    public String updateAgentVersionToServer(String ip, String deviceUUID, String token, String productVersion, String serviceVersion, String osType, String osVersion) throws CrawlAdapterException {
        int responseCode = 0;
        HttpResponse response = null;
        String userConsentGiven = "false";
        try {
            URI uri = this.formHttpsUri(ip, "/paracloud/cloud" + this.cloudName + "/update/agentProductVersion");
            this.logger.debug("URI:" + uri);
            HttpPost httpPost = new HttpPost(uri);
            httpPost.setHeader("Content-Type", "application/json");
            if (StringUtils.isNotEmpty((String)token)) {
                httpPost.setHeader("token", token);
            }
            if (StringUtils.isNotEmpty((String)productVersion)) {
                httpPost.setHeader("productVersion", productVersion);
            }
            if (StringUtils.isNotEmpty((String)serviceVersion)) {
                this.logger.debug("Service version : " + serviceVersion);
                httpPost.setHeader("serviceVersion", serviceVersion);
            }
            httpPost.setHeader("deviceUUID", deviceUUID);
            String dispalyName = this.getDeviceName();
            if (StringUtils.isNotEmpty((String)dispalyName)) {
                this.logger.debug("DisplayName..." + dispalyName);
                httpPost.setHeader("displayName", dispalyName);
            }
            if (StringUtils.isNotEmpty((String)osType)) {
                this.logger.debug("osType..." + osType);
                httpPost.setHeader("osType", osType);
            }
            if (StringUtils.isNotEmpty((String)osVersion)) {
                this.logger.debug("osVersion..." + osVersion);
                httpPost.setHeader("osVersion", osVersion);
            }
            response = this.httpclient.execute((HttpUriRequest)httpPost);
            responseCode = response.getStatusLine().getStatusCode();
            this.logger.debug("response : " + responseCode);
            if (responseCode == 200) {
                this.logger.debug("Agent version updated to server successfully");
                userConsentGiven = response.getFirstHeader("user-consent-given").getValue();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CrawlAdapterException("Exception " + e);
        }
        finally {
            try {
                if (response != null && response.getEntity() != null) {
                    response.getEntity().getContent().close();
                }
            }
            catch (IOException e) {
                this.logger.error("Exception", (Throwable)e);
            }
        }
        return userConsentGiven;
    }

    public String getDeviceName() {
        String deviceName = "";
        try {
            deviceName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            this.logger.error("Exception", (Throwable)e);
        }
        return deviceName;
    }
}

