/*
 * Decompiled with CFR 0.152.
 */
package com.btr.proxy.selector.pac;

import com.btr.proxy.selector.pac.PacScriptMethods;
import com.btr.proxy.selector.pac.PacScriptParser;
import com.btr.proxy.selector.pac.PacScriptSource;
import com.btr.proxy.selector.pac.ProxyEvaluationException;
import com.btr.proxy.selector.pac.ScriptMethods;
import com.btr.proxy.util.Logger;
import java.lang.reflect.Method;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class JavaxPacScriptParser
implements PacScriptParser {
    static final String SCRIPT_METHODS_OBJECT = "__pacutil";
    private final PacScriptSource source;
    private final ScriptEngine engine;

    public JavaxPacScriptParser(PacScriptSource source) throws ProxyEvaluationException {
        this.source = source;
        this.engine = this.setupEngine();
    }

    private ScriptEngine setupEngine() throws ProxyEvaluationException {
        Method[] scriptMethods;
        ScriptEngineManager mng = new ScriptEngineManager();
        ScriptEngine engine = mng.getEngineByMimeType("text/javascript");
        engine.put(SCRIPT_METHODS_OBJECT, new PacScriptMethods());
        Class<ScriptMethods> scriptMethodsClazz = ScriptMethods.class;
        for (Method method : scriptMethods = scriptMethodsClazz.getMethods()) {
            int i;
            String name = method.getName();
            int args = method.getParameterTypes().length;
            StringBuilder toEval = new StringBuilder(name).append(" = function(");
            for (i = 0; i < args; ++i) {
                if (i > 0) {
                    toEval.append(",");
                }
                toEval.append("arg").append(i);
            }
            toEval.append(") {return ").append(SCRIPT_METHODS_OBJECT).append(".").append(name).append("(");
            for (i = 0; i < args; ++i) {
                if (i > 0) {
                    toEval.append(",");
                }
                toEval.append("arg").append(i);
            }
            toEval.append("); }");
            try {
                engine.eval(toEval.toString());
            }
            catch (ScriptException e) {
                Logger.log(this.getClass(), Logger.LogLevel.ERROR, "JS evaluation error when creating alias for " + name + ".", e);
                throw new ProxyEvaluationException("Error setting up script engine", e);
            }
        }
        return engine;
    }

    public PacScriptSource getScriptSource() {
        return this.source;
    }

    public String evaluate(String url, String host) throws ProxyEvaluationException {
        try {
            StringBuilder script = new StringBuilder(this.source.getScriptContent());
            String evalMethod = " ;FindProxyForURL (\"" + url + "\",\"" + host + "\")";
            script.append(evalMethod);
            Object result = this.engine.eval(script.toString());
            return (String)result;
        }
        catch (Exception e) {
            Logger.log(this.getClass(), Logger.LogLevel.ERROR, "JS evaluation error.", e);
            throw new ProxyEvaluationException("Error while executing PAC script: " + e.getMessage(), e);
        }
    }
}

