/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERConstructedSequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERString;
import org.bouncycastle.asn1.x509.X509NameTokenizer;

public class X509Name
implements DEREncodable {
    public static final DERObjectIdentifier C = new DERObjectIdentifier("2.5.4.6");
    public static final DERObjectIdentifier O = new DERObjectIdentifier("2.5.4.10");
    public static final DERObjectIdentifier OU = new DERObjectIdentifier("2.5.4.11");
    public static final DERObjectIdentifier T = new DERObjectIdentifier("2.5.4.12");
    public static final DERObjectIdentifier CN = new DERObjectIdentifier("2.5.4.3");
    public static final DERObjectIdentifier SN = new DERObjectIdentifier("2.5.4.5");
    public static final DERObjectIdentifier L = new DERObjectIdentifier("2.5.4.7");
    public static final DERObjectIdentifier ST = new DERObjectIdentifier("2.5.4.8");
    public static final DERObjectIdentifier EmailAddress = new DERObjectIdentifier("1.2.840.113549.1.9.1");
    public static final DERObjectIdentifier DC = new DERObjectIdentifier("0.9.2342.19200300.100.1.25");
    public static Hashtable OIDLookUp = new Hashtable();
    public static Hashtable SymbolLookUp = new Hashtable();
    private Vector ordering = new Vector();
    private Vector values = new Vector();

    public static X509Name getInstance(Object object) {
        if (object instanceof X509Name) {
            return (X509Name)object;
        }
        if (object instanceof ASN1Sequence) {
            return new X509Name((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public X509Name(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        while (enumeration.hasMoreElements()) {
            DERSet dERSet = (DERSet)enumeration.nextElement();
            DERConstructedSequence dERConstructedSequence = (DERConstructedSequence)dERSet.getSequence();
            this.ordering.addElement(dERConstructedSequence.getObjectAt(0));
            this.values.addElement(((DERString)((Object)dERConstructedSequence.getObjectAt(1))).getString());
        }
    }

    public X509Name(Hashtable hashtable) {
        this(null, hashtable);
    }

    public X509Name(Vector vector, Hashtable hashtable) {
        if (vector != null) {
            int n = 0;
            while (n != vector.size()) {
                this.ordering.addElement(vector.elementAt(n));
                ++n;
            }
        } else {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                this.ordering.addElement(enumeration.nextElement());
            }
        }
        int n = 0;
        while (n != this.ordering.size()) {
            DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)this.ordering.elementAt(n);
            if (OIDLookUp.get(dERObjectIdentifier) == null) {
                throw new IllegalArgumentException("Unknown object id - " + dERObjectIdentifier.getId() + " - passed to distinguished name");
            }
            if (hashtable.get(dERObjectIdentifier) == null) {
                throw new IllegalArgumentException("No attribute for object id - " + dERObjectIdentifier.getId() + " - passed to distinguished name");
            }
            this.values.addElement(hashtable.get(dERObjectIdentifier));
            ++n;
        }
    }

    public X509Name(Vector vector, Vector vector2) {
        if (vector.size() != vector2.size()) {
            throw new IllegalArgumentException("ordering vector must be same length as values.");
        }
        int n = 0;
        while (n < vector.size()) {
            this.ordering.addElement(vector.elementAt(n));
            this.values.addElement(vector2.elementAt(n));
            ++n;
        }
    }

    public X509Name(String string) {
        X509NameTokenizer x509NameTokenizer = new X509NameTokenizer(string);
        while (x509NameTokenizer.hasMoreTokens()) {
            String string2 = x509NameTokenizer.nextToken();
            int n = string2.indexOf(61);
            if (n == -1) {
                throw new IllegalArgumentException("badly formated directory string");
            }
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1);
            DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)SymbolLookUp.get(string3);
            if (dERObjectIdentifier == null) {
                throw new IllegalArgumentException("Unknown object id - " + string3 + " - passed to distinguished name");
            }
            this.ordering.addElement(dERObjectIdentifier);
            this.values.addElement(string4);
        }
    }

    public DERObject getDERObject() {
        DERConstructedSequence dERConstructedSequence = new DERConstructedSequence();
        int n = 0;
        while (n != this.ordering.size()) {
            DERConstructedSequence dERConstructedSequence2 = new DERConstructedSequence();
            DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)this.ordering.elementAt(n);
            dERConstructedSequence2.addObject(dERObjectIdentifier);
            if (dERObjectIdentifier.equals(EmailAddress)) {
                dERConstructedSequence2.addObject(new DERIA5String((String)this.values.elementAt(n)));
            } else {
                dERConstructedSequence2.addObject(new DERPrintableString((String)this.values.elementAt(n)));
            }
            dERConstructedSequence.addObject(new DERSet(dERConstructedSequence2));
            ++n;
        }
        return dERConstructedSequence;
    }

    public int hashCode() {
        DERConstructedSequence dERConstructedSequence = (DERConstructedSequence)this.getDERObject();
        Enumeration enumeration = dERConstructedSequence.getObjects();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            DERSet dERSet = (DERSet)enumeration.nextElement();
            DERConstructedSequence dERConstructedSequence2 = (DERConstructedSequence)dERSet.getSequence();
            int n2 = dERConstructedSequence2.getSize() - 1;
            while (n2 >= 0) {
                n ^= dERConstructedSequence2.getObjectAt(n2).hashCode();
                --n2;
            }
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof X509Name)) {
            return false;
        }
        X509Name x509Name = (X509Name)object;
        DERConstructedSequence dERConstructedSequence = (DERConstructedSequence)this.getDERObject();
        DERConstructedSequence dERConstructedSequence2 = (DERConstructedSequence)x509Name.getDERObject();
        if (dERConstructedSequence.getSize() != dERConstructedSequence2.getSize()) {
            return false;
        }
        Enumeration enumeration = dERConstructedSequence.getObjects();
        Enumeration enumeration2 = dERConstructedSequence2.getObjects();
        while (enumeration.hasMoreElements()) {
            DERSet dERSet = (DERSet)enumeration.nextElement();
            DERConstructedSequence dERConstructedSequence3 = (DERConstructedSequence)dERSet.getSequence();
            DERSet dERSet2 = (DERSet)enumeration2.nextElement();
            DERConstructedSequence dERConstructedSequence4 = (DERConstructedSequence)dERSet2.getSequence();
            if (dERConstructedSequence3.getSize() != dERConstructedSequence4.getSize()) {
                return false;
            }
            int n = dERConstructedSequence3.getSize() - 1;
            while (n >= 0) {
                if (!dERConstructedSequence3.getObjectAt(n).equals(dERConstructedSequence4.getObjectAt(n))) {
                    return false;
                }
                --n;
            }
        }
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        Enumeration enumeration = this.ordering.elements();
        Enumeration enumeration2 = this.values.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            String string = (String)OIDLookUp.get(e);
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(", ");
            }
            if (string != null) {
                stringBuffer.append(string);
            } else {
                stringBuffer.append(((DERObjectIdentifier)e).getId());
            }
            stringBuffer.append("=");
            stringBuffer.append((String)enumeration2.nextElement());
        }
        return stringBuffer.toString();
    }

    static {
        OIDLookUp.put(C, "C");
        OIDLookUp.put(O, "O");
        OIDLookUp.put(T, "T");
        OIDLookUp.put(OU, "OU");
        OIDLookUp.put(CN, "CN");
        OIDLookUp.put(L, "L");
        OIDLookUp.put(ST, "ST");
        OIDLookUp.put(SN, "SN");
        OIDLookUp.put(EmailAddress, "EmailAddress");
        OIDLookUp.put(DC, "DC");
        SymbolLookUp.put("C", C);
        SymbolLookUp.put("O", O);
        SymbolLookUp.put("T", T);
        SymbolLookUp.put("OU", OU);
        SymbolLookUp.put("CN", CN);
        SymbolLookUp.put("L", L);
        SymbolLookUp.put("ST", ST);
        SymbolLookUp.put("SN", SN);
        SymbolLookUp.put("EmailAddress", EmailAddress);
        SymbolLookUp.put("DC", DC);
    }
}

