/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import java.util.Vector;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DERConstructedSet;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.DigestAlgorithmIdentifier;

public class DigestAlgorithmIdentifiers
implements DEREncodable {
    private DERConstructedSet identifiers;

    public DigestAlgorithmIdentifiers(Vector vector) {
        this.setIdentifiers(vector);
    }

    public DigestAlgorithmIdentifiers(DERConstructedSet dERConstructedSet) {
        this.identifiers = dERConstructedSet;
    }

    public DigestAlgorithmIdentifiers(DigestAlgorithmIdentifiers digestAlgorithmIdentifiers) {
        this.identifiers = digestAlgorithmIdentifiers.identifiers;
    }

    public static DigestAlgorithmIdentifiers getInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof DigestAlgorithmIdentifiers) {
            return (DigestAlgorithmIdentifiers)object;
        }
        if (object instanceof DERConstructedSet) {
            return new DigestAlgorithmIdentifiers((DERConstructedSet)object);
        }
        if (object instanceof BERTaggedObject) {
            return DigestAlgorithmIdentifiers.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid DigestAlgorithmIdentifiers");
    }

    public static DigestAlgorithmIdentifiers newInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof DigestAlgorithmIdentifiers) {
            return new DigestAlgorithmIdentifiers((DigestAlgorithmIdentifiers)object);
        }
        if (object instanceof DERConstructedSet) {
            return new DigestAlgorithmIdentifiers((DERConstructedSet)object);
        }
        if (object instanceof BERTaggedObject) {
            return DigestAlgorithmIdentifiers.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid DigestAlgorithmIdentifiers");
    }

    public Vector getIdentifiers() {
        int n = this.identifiers.getSize();
        Vector<DigestAlgorithmIdentifier> vector = new Vector<DigestAlgorithmIdentifier>();
        int n2 = 0;
        while (n2 < n) {
            vector.addElement(DigestAlgorithmIdentifier.getInstance(this.identifiers.getObjectAt(n2)));
            ++n2;
        }
        return vector;
    }

    private void setIdentifiers(Vector vector) {
        int n = vector.size();
        this.identifiers = new DERConstructedSet();
        int n2 = 0;
        while (n2 < n) {
            this.identifiers.addObject(DigestAlgorithmIdentifier.getInstance(vector.elementAt(n2)));
            ++n2;
        }
    }

    public DERObject getDERObject() {
        return this.identifiers;
    }
}

