/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.dao;

import com.parablu.epa.common.dao.BaseDAO;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.core.constant.StringLiterals;
import com.parablu.epa.core.dao.SyncedFilesDAO;
import com.parablu.epa.core.to.FileTO;
import java.sql.SQLException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncedFilesDaoImpl
extends BaseDAO
implements SyncedFilesDAO {
    private Logger logger = LoggerFactory.getLogger(SyncedFilesDaoImpl.class);
    private static final String SQLEXCEPTION_INSERTINGTO_SYNCFILES_TABLE = "SQLException while inserting To Synced Files Table";

    public SyncedFilesDaoImpl(String uRL) {
        super(uRL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createSyncedFilesDB() {
        SyncedFilesDaoImpl syncedFilesDaoImpl = this;
        synchronized (syncedFilesDaoImpl) {
            this.statement = null;
            boolean success = false;
            boolean gotConnection = this.getConnectionForWALMode();
            if (gotConnection) {
                try {
                    this.statement = this.conn.prepareStatement(CREATE_SYNCED_FILES_TABLE_SQL_QUERY);
                    this.statement.execute();
                    this.statement.close();
                    success = true;
                }
                catch (SQLException e) {
                    this.logger.error("sqlExeception while creating Synced Files DB" + e);
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    this.closeConnection();
                }
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean attachImageTableDataInCurrentTable(String currentImageTableName) {
        SyncedFilesDaoImpl syncedFilesDaoImpl = this;
        synchronized (syncedFilesDaoImpl) {
            boolean success = false;
            String baseFolderURL = SettingHelper.getBaseDBUrl();
            StringBuilder sb = new StringBuilder().append(baseFolderURL).append(StringLiterals.CONSTANTS_FILE_SEPARATOR).append(currentImageTableName);
            String sqlQuery = "attach database \"" + sb.toString() + "\" as " + currentImageTableName + ";";
            this.statement = null;
            boolean gotConnection = this.getConnectionForWALMode();
            if (gotConnection) {
                try {
                    this.statement = this.conn.prepareStatement(sqlQuery);
                    this.statement.execute();
                    this.statement.close();
                    success = true;
                }
                catch (SQLException e) {
                    this.closeConnection();
                    this.logger.error("SQLException while attaching Image Table" + e);
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    try {
                        if (this.statement != null) {
                            this.statement.close();
                        }
                    }
                    catch (SQLException e) {
                        this.logger.error("SQLException while closing statement object during attaching Image Table operation" + e);
                    }
                    catch (RuntimeException e) {
                        this.logger.error("Runtime Exception...", (Object)e.getMessage());
                    }
                }
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean detachImageTableDataInCurrentTable(String previousImageTableName) {
        SyncedFilesDaoImpl syncedFilesDaoImpl = this;
        synchronized (syncedFilesDaoImpl) {
            boolean success = false;
            String sqlQuery = "DETACH DATABASE " + previousImageTableName + ";";
            this.statement = null;
            try {
                this.statement = this.conn.prepareStatement(sqlQuery);
                this.statement.execute();
                this.statement.close();
                success = true;
            }
            catch (SQLException e) {
                this.logger.error("SQLException while Detaching Image Table", (Throwable)e);
            }
            catch (RuntimeException e) {
                this.logger.error("Runtime Exception...", (Object)e.getMessage());
            }
            finally {
                this.closeConnection();
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteParentFolder() {
        SyncedFilesDaoImpl syncedFilesDaoImpl = this;
        synchronized (syncedFilesDaoImpl) {
            StringBuilder sqlQueryInsert = new StringBuilder().append("DELETE FROM ").append("SyncedFiles").append(" WHERE filepath = \"\" AND filename = \"ParaBlu\")");
            this.statement = null;
            boolean success = false;
            try {
                this.statement = this.conn.prepareStatement(sqlQueryInsert.toString());
                this.statement.execute();
                this.statement.close();
                success = true;
            }
            catch (SQLException e) {
                this.logger.error(SQLEXCEPTION_INSERTINGTO_SYNCFILES_TABLE, (Throwable)e);
            }
            catch (RuntimeException e) {
                this.logger.error("Runtime Exception...", (Object)e.getMessage());
            }
            finally {
                this.closeConnection();
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertParentFolder() {
        SyncedFilesDaoImpl syncedFilesDaoImpl = this;
        synchronized (syncedFilesDaoImpl) {
            this.logger.debug("Inserting parent folder to SyncedFiles table");
            StringBuilder sqlQueryInsert = new StringBuilder().append("insert into ").append("SyncedFiles").append(" (filepath,filename) VALUES (\"ParaBlu\", \"\")");
            this.statement = null;
            if (this.getConnectionForWALMode()) {
                try {
                    this.statement = this.conn.prepareStatement(sqlQueryInsert.toString());
                    this.statement.execute();
                    this.statement.close();
                }
                catch (SQLException e) {
                    this.logger.error("SQLException while inserting parent folder  To Synced Files Table", (Throwable)e);
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    this.closeConnection();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insertFileTOListToTable(String currentImageTableName) {
        SyncedFilesDaoImpl syncedFilesDaoImpl = this;
        synchronized (syncedFilesDaoImpl) {
            StringBuilder sqlQueryDeleteDifference = new StringBuilder().append("DELETE FROM ").append("SyncedFiles").append(" WHERE NOT EXISTS ( SELECT * FROM ").append(currentImageTableName).append(" c WHERE filename = c.filename and filepath = c.filepath)");
            StringBuilder sqlQueryInsert = new StringBuilder().append("insert into ").append("SyncedFiles").append(" SELECT filepath,filename FROM ").append(currentImageTableName).append("; ");
            this.statement = null;
            boolean success = false;
            if (this.attachImageTableDataInCurrentTable(currentImageTableName)) {
                try {
                    this.statement = this.conn.prepareStatement(sqlQueryDeleteDifference.toString());
                    this.statement.execute();
                    this.statement.close();
                    this.statement = this.conn.prepareStatement(sqlQueryInsert.toString());
                    this.statement.execute();
                    this.statement.close();
                    success = true;
                }
                catch (SQLException e) {
                    this.logger.error(SQLEXCEPTION_INSERTINGTO_SYNCFILES_TABLE, (Throwable)e);
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                this.detachImageTableDataInCurrentTable(currentImageTableName);
                this.closeConnection();
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insertFileTOListToTable(List<FileTO> syncedFilesFileTOList) {
        SyncedFilesDaoImpl syncedFilesDaoImpl = this;
        synchronized (syncedFilesDaoImpl) {
            StringBuilder sqlQuery = new StringBuilder().append("insert into ").append("SyncedFiles").append(" Values(?,?);");
            this.statement = null;
            boolean success = false;
            boolean gotConnection = this.getConnectionForWALMode();
            if (gotConnection) {
                try {
                    this.statement = this.conn.prepareStatement(sqlQuery.toString());
                    int listsize = syncedFilesFileTOList.size();
                    this.conn.setAutoCommit(false);
                    for (int recordCount = 0; recordCount < listsize; ++recordCount) {
                        FileTO currentFilesTO = syncedFilesFileTOList.get(recordCount);
                        this.statement.setString(1, currentFilesTO.getAbstractFilePath());
                        this.statement.setString(2, currentFilesTO.getFileName());
                        this.statement.addBatch();
                        if (recordCount % 1000 != 0) continue;
                        this.statement.executeBatch();
                        this.statement.clearBatch();
                    }
                    this.statement.executeBatch();
                    this.statement.close();
                    this.conn.commit();
                    success = true;
                }
                catch (SQLException e) {
                    this.logger.error(SQLEXCEPTION_INSERTINGTO_SYNCFILES_TABLE, (Throwable)e);
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    this.closeConnection();
                }
            }
            return success;
        }
    }
}

