/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.common.dao;

import com.parablu.epa.common.dao.BaseDAO;
import com.parablu.epa.core.dao.FolderDAO;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FolderDaoImpl
extends BaseDAO
implements FolderDAO {
    private Logger logger = LoggerFactory.getLogger(FolderDaoImpl.class);
    private static final String TRUE = "true";

    public FolderDaoImpl(String uRL) {
        super(uRL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createFolderDB() {
        FolderDaoImpl folderDaoImpl = this;
        synchronized (folderDaoImpl) {
            this.statement = null;
            boolean success = false;
            boolean gotConnection = this.getConnectionForCreatingDatabase();
            if (gotConnection) {
                try {
                    this.statement = this.conn.prepareStatement(CREATE_FOLDER_TABLE_SQL_QUERY);
                    this.statement.execute();
                    this.statement.close();
                    success = true;
                }
                catch (SQLException e) {
                    this.logger.error("sqlExeception while creating Folder DB" + e);
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    this.closeConnection();
                }
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getFolderListForCrawl() {
        FolderDaoImpl folderDaoImpl = this;
        synchronized (folderDaoImpl) {
            String sqlQuery = new StringBuffer().append("select ").append("folderpath").append(" from ").append("FolderSync").append(" where ").append("isselected").append(" =?;").toString();
            this.statement = null;
            ResultSet selectImageTableResult = null;
            ArrayList<String> listOfFolders = null;
            boolean gotConnection = this.getConnection();
            if (gotConnection) {
                try {
                    this.statement = this.conn.prepareStatement(sqlQuery);
                    this.statement.setString(1, TRUE);
                    selectImageTableResult = this.statement.executeQuery();
                    listOfFolders = new ArrayList<String>();
                    if (selectImageTableResult != null) {
                        while (selectImageTableResult.next()) {
                            String tempFile = selectImageTableResult.getString("folderpath");
                            listOfFolders.add(tempFile);
                        }
                    }
                    this.statement.close();
                }
                catch (SQLException e) {
                    this.logger.error("SQLException while getting folder list for crawl from foldersync table", (Throwable)e);
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    if (selectImageTableResult != null) {
                        try {
                            selectImageTableResult.close();
                        }
                        catch (SQLException e) {
                            this.logger.error("SQLException while closing result set" + e);
                        }
                        catch (RuntimeException e) {
                            this.logger.error("Runtime Exception...", (Object)e.getMessage());
                        }
                    }
                    this.closeConnection();
                }
            }
            return listOfFolders;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setFolderListForCrawl(List<String> listOfFolders) {
        FolderDaoImpl folderDaoImpl = this;
        synchronized (folderDaoImpl) {
            String sqlQuery = "INSERT INTO FolderSync Values(?,?)";
            this.statement = null;
            boolean success = false;
            boolean gotConnection = this.getConnection();
            if (gotConnection) {
                try {
                    this.statement = this.conn.prepareStatement(sqlQuery);
                    int listsize = listOfFolders.size();
                    this.conn.setAutoCommit(false);
                    for (int recordCount = 0; recordCount < listsize; ++recordCount) {
                        String tempFolder = listOfFolders.get(recordCount);
                        this.statement.setString(1, tempFolder);
                        this.statement.setString(2, TRUE);
                        this.statement.addBatch();
                        if (recordCount % 1000 != 0) continue;
                        this.statement.executeBatch();
                        this.statement.clearBatch();
                    }
                    this.statement.executeBatch();
                    this.statement.close();
                    this.conn.commit();
                    success = true;
                }
                catch (SQLException e) {
                    this.logger.error("SQLException while setting FolderList For Crawl", (Throwable)e);
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    this.closeConnection();
                }
            }
            return success;
        }
    }

    public boolean updateFolderListForCrawl(List<String> listOfFoldersFromCrawl, List<String> listOfFoldersFromDodTable) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deselectAllFolders() {
        FolderDaoImpl folderDaoImpl = this;
        synchronized (folderDaoImpl) {
            String sqlQuery = "delete from FolderSync";
            this.statement = null;
            boolean success = false;
            boolean gotConnection = this.getConnection();
            if (gotConnection) {
                try {
                    this.statement = this.conn.prepareStatement(sqlQuery);
                    this.statement.execute();
                    this.statement.close();
                    success = true;
                }
                catch (SQLException e) {
                    this.logger.error("SQLException while deleting All Folders from Folder sync table", (Throwable)e);
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    this.closeConnection();
                }
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean applySelectedFolders(List<String> listOfFolders) {
        FolderDaoImpl folderDaoImpl = this;
        synchronized (folderDaoImpl) {
            String sqlQueryForDelete = "delete from FolderSync";
            String sqlQueryForInsert = "INSERT INTO FolderSync Values(?,?)";
            this.statement = null;
            boolean success = false;
            boolean gotConnection = this.getConnection();
            if (gotConnection) {
                try {
                    this.conn.setAutoCommit(false);
                    this.statement = this.conn.prepareStatement(sqlQueryForDelete);
                    this.statement.execute();
                    this.statement.close();
                    this.statement = this.conn.prepareStatement(sqlQueryForInsert);
                    for (String folder : listOfFolders) {
                        this.statement.setString(1, folder);
                        this.statement.setString(2, TRUE);
                        this.statement.addBatch();
                    }
                    this.statement.executeBatch();
                    this.conn.commit();
                    success = true;
                    this.statement.close();
                }
                catch (SQLException e) {
                    this.logger.error("SQLException while applying Selected Folders", (Throwable)e);
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    this.closeConnection();
                }
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFolderListCountForCrawl() {
        FolderDaoImpl folderDaoImpl = this;
        synchronized (folderDaoImpl) {
            int foldersCount = 0;
            String sqlQuery = new StringBuffer().append("select count(*) from ").append("FolderSync").append(" where ").append("isselected").append(" =?").toString();
            this.statement = null;
            ResultSet selectImageTableResult = null;
            boolean gotConnection = this.getConnection();
            if (gotConnection) {
                try {
                    this.statement = this.conn.prepareStatement(sqlQuery);
                    this.statement.setString(1, TRUE);
                    selectImageTableResult = this.statement.executeQuery();
                    if (selectImageTableResult != null && selectImageTableResult.next()) {
                        foldersCount = selectImageTableResult.getInt("count(*)");
                    }
                    this.statement.close();
                }
                catch (SQLException e) {
                    this.logger.error("SQLException while geting Folder List Count For Crawl", (Throwable)e);
                }
                catch (RuntimeException e) {
                    this.logger.error("Runtime Exception...", (Object)e.getMessage());
                }
                finally {
                    if (selectImageTableResult != null) {
                        try {
                            selectImageTableResult.close();
                        }
                        catch (SQLException e) {
                            this.logger.error("SQLException while closing result set" + e);
                        }
                        catch (RuntimeException e) {
                            this.logger.error("Runtime Exception...", (Object)e.getMessage());
                        }
                    }
                    this.closeConnection();
                }
            }
            return foldersCount;
        }
    }
}

