/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.CMSVersion;
import org.bouncycastle.asn1.cms.EncryptedContentInfo;
import org.bouncycastle.asn1.cms.OriginatorInfo;
import org.bouncycastle.asn1.cms.RecipientInfos;
import org.bouncycastle.asn1.cms.UnprotectedAttributes;

public class EnvelopedData
implements DEREncodable {
    private CMSVersion version;
    private OriginatorInfo originatorInfo;
    private RecipientInfos recipientInfos;
    private EncryptedContentInfo encryptedContentInfo;
    private UnprotectedAttributes unprotectedAttrs;

    public EnvelopedData(CMSVersion cMSVersion, OriginatorInfo originatorInfo, RecipientInfos recipientInfos, EncryptedContentInfo encryptedContentInfo, UnprotectedAttributes unprotectedAttributes) {
        this.setVersion(cMSVersion);
        this.setOriginatorInfo(originatorInfo);
        this.setRecipientInfos(recipientInfos);
        this.setEncryptedContentInfo(encryptedContentInfo);
        this.setUnprotectedAttrs(unprotectedAttributes);
    }

    public EnvelopedData(BERConstructedSequence bERConstructedSequence) {
        int n = 0;
        this.version = CMSVersion.getInstance(bERConstructedSequence.getObjectAt(n++));
        DEREncodable dEREncodable = bERConstructedSequence.getObjectAt(n++);
        if (dEREncodable instanceof BERTaggedObject) {
            this.originatorInfo = OriginatorInfo.getInstance(dEREncodable);
            dEREncodable = bERConstructedSequence.getObjectAt(n++);
        }
        this.recipientInfos = RecipientInfos.getInstance(dEREncodable);
        this.encryptedContentInfo = EncryptedContentInfo.getInstance(bERConstructedSequence.getObjectAt(n++));
        if (bERConstructedSequence.getSize() > n) {
            this.unprotectedAttrs = UnprotectedAttributes.getInstance(bERConstructedSequence.getObjectAt(n));
        }
    }

    public EnvelopedData(EnvelopedData envelopedData) {
        this.originatorInfo = envelopedData.originatorInfo;
        this.recipientInfos = envelopedData.recipientInfos;
        this.encryptedContentInfo = envelopedData.encryptedContentInfo;
        this.unprotectedAttrs = envelopedData.unprotectedAttrs;
    }

    public static EnvelopedData getInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof EnvelopedData) {
            return (EnvelopedData)object;
        }
        if (object instanceof BERConstructedSequence) {
            return new EnvelopedData((BERConstructedSequence)object);
        }
        if (object instanceof BERTaggedObject) {
            return EnvelopedData.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid EnvelopedData");
    }

    public static EnvelopedData newInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof EnvelopedData) {
            return new EnvelopedData((EnvelopedData)object);
        }
        if (object instanceof BERConstructedSequence) {
            return new EnvelopedData((BERConstructedSequence)object);
        }
        if (object instanceof BERTaggedObject) {
            return EnvelopedData.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid EnvelopedData");
    }

    public CMSVersion getVersion() {
        return this.version;
    }

    private void setVersion(CMSVersion cMSVersion) {
        this.version = cMSVersion;
    }

    public OriginatorInfo getOriginatorInfo() {
        return this.originatorInfo;
    }

    private void setOriginatorInfo(OriginatorInfo originatorInfo) {
        this.originatorInfo = originatorInfo;
    }

    public RecipientInfos getRecipientInfos() {
        return this.recipientInfos;
    }

    private void setRecipientInfos(RecipientInfos recipientInfos) {
        this.recipientInfos = recipientInfos;
    }

    public EncryptedContentInfo getEncryptedContentInfo() {
        return this.encryptedContentInfo;
    }

    private void setEncryptedContentInfo(EncryptedContentInfo encryptedContentInfo) {
        this.encryptedContentInfo = encryptedContentInfo;
    }

    public UnprotectedAttributes getUnprotectedAttrs() {
        return this.unprotectedAttrs;
    }

    private void setUnprotectedAttrs(UnprotectedAttributes unprotectedAttributes) {
        this.unprotectedAttrs = unprotectedAttributes;
    }

    public DERObject getDERObject() {
        BERConstructedSequence bERConstructedSequence = new BERConstructedSequence();
        bERConstructedSequence.addObject(this.version);
        if (this.originatorInfo != null) {
            bERConstructedSequence.addObject(new BERTaggedObject(false, 0, this.originatorInfo.getDERObject()));
        }
        bERConstructedSequence.addObject(this.recipientInfos);
        bERConstructedSequence.addObject(this.encryptedContentInfo);
        if (this.unprotectedAttrs != null) {
            bERConstructedSequence.addObject(new BERTaggedObject(false, 1, this.unprotectedAttrs.getDERObject()));
        }
        return bERConstructedSequence;
    }
}

