/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.nio.ByteBuffer;
import zmq.DecoderBase;
import zmq.IMsgSink;
import zmq.Msg;

public class Decoder
extends DecoderBase {
    private static final int ONE_BYTE_SIZE_READY = 0;
    private static final int EIGHT_BYTE_SIZE_READY = 1;
    private static final int FLAGS_READY = 2;
    private static final int MESSAGE_READY = 3;
    private final byte[] tmpbuf;
    private Msg inProgress;
    private final long maxmsgsize;
    private IMsgSink msgSink;

    public Decoder(int bufsize, long maxmsgsize) {
        super(bufsize);
        this.maxmsgsize = maxmsgsize;
        this.tmpbuf = new byte[8];
        this.nextStep(this.tmpbuf, 1, 0);
    }

    @Override
    public void setMsgSink(IMsgSink msgSink) {
        this.msgSink = msgSink;
    }

    @Override
    protected boolean next() {
        switch (this.state()) {
            case 0: {
                return this.oneByteSizeReady();
            }
            case 1: {
                return this.eightByteSizeReady();
            }
            case 2: {
                return this.flagsReady();
            }
            case 3: {
                return this.messageReady();
            }
        }
        return false;
    }

    private boolean oneByteSizeReady() {
        int first = this.tmpbuf[0];
        if (first == -1) {
            this.nextStep(this.tmpbuf, 8, 1);
        } else {
            if (first == 0) {
                this.decodingError();
                return false;
            }
            int size = first;
            if (size < 0) {
                size = 0xFF & first;
            }
            if (this.maxmsgsize >= 0L && (long)(size - 1) > this.maxmsgsize) {
                this.decodingError();
                return false;
            }
            this.inProgress = new Msg(size - 1);
            this.nextStep(this.tmpbuf, 1, 2);
        }
        return true;
    }

    private boolean eightByteSizeReady() {
        long payloadLength = ByteBuffer.wrap(this.tmpbuf).getLong();
        if (payloadLength <= 0L) {
            this.decodingError();
            return false;
        }
        if (this.maxmsgsize >= 0L && payloadLength - 1L > this.maxmsgsize) {
            this.decodingError();
            return false;
        }
        if (payloadLength - 1L > Integer.MAX_VALUE) {
            this.decodingError();
            return false;
        }
        int msgSize = (int)(payloadLength - 1L);
        this.inProgress = new Msg(msgSize);
        this.nextStep(this.tmpbuf, 1, 2);
        return true;
    }

    private boolean flagsReady() {
        byte first = this.tmpbuf[0];
        this.inProgress.setFlags(first & 1);
        this.nextStep(this.inProgress, 3);
        return true;
    }

    private boolean messageReady() {
        if (this.msgSink == null) {
            return false;
        }
        int rc = this.msgSink.pushMsg(this.inProgress);
        if (rc != 0) {
            return false;
        }
        this.nextStep(this.tmpbuf, 1, 0);
        return true;
    }
}

