/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import org.bouncycastle.asn1.DERConstructedSequence;
import org.bouncycastle.asn1.DERInputStream;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class PKCS10Test
implements Test {
    byte[] req = Base64.decode("MIHoMIGTAgEAMC4xDjAMBgNVBAMTBVRlc3QyMQ8wDQYDVQQKEwZBbmFUb20xCzAJBgNVBAYTAlNFMFwwDQYJKoZIhvcNAQEBBQADSwAwSAJBALlEt31Tzt2MlcOljvacJgzQVhmlMoqAOgqJ9Pgd3GuxZ7/WcIlgW4QCB7WZT21O1YoghwBhPDMcNGrHei9kHQkCAwEAAaAAMA0GCSqGSIb3DQEBBQUAA0EANDEI4ecNtJ3uHwGGlitNFq9WxcoZ0djbQJ5hABMotav6gtqlrwKXY2evaIrsNwkJtNdwwH18aQDUKCjOuBL38Q==");

    public String getName() {
        return "PKCS10";
    }

    public TestResult perform() {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.req);
            DERInputStream dERInputStream = new DERInputStream(byteArrayInputStream);
            CertificationRequest certificationRequest = new CertificationRequest((DERConstructedSequence)dERInputStream.readObject());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
            dEROutputStream.writeObject(certificationRequest.getDERObject());
            byte[] byArray = byteArrayOutputStream.toByteArray();
            if (byArray.length != this.req.length) {
                return new SimpleTestResult(false, this.getName() + ": failed length test");
            }
            int n = 0;
            while (n != this.req.length) {
                if (byArray[n] != this.req[n]) {
                    return new SimpleTestResult(false, this.getName() + ": failed comparison test");
                }
                ++n;
            }
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": Exception - " + exception.toString());
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public static void main(String[] stringArray) {
        PKCS10Test pKCS10Test = new PKCS10Test();
        TestResult testResult = pKCS10Test.perform();
        System.out.println(testResult);
    }
}

