/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.theme.DrawData;
import org.eclipse.swt.internal.theme.RangeDrawData;

public class Theme {
    Device device;

    public Theme(Device device) {
        this.device = device;
    }

    public Rectangle computeTrim(GC gC, DrawData drawData) {
        this.checkTheme();
        if (gC == null) {
            SWT.error(4);
        }
        if (drawData == null) {
            SWT.error(4);
        }
        if (gC.isDisposed()) {
            SWT.error(5);
        }
        return drawData.computeTrim(this, gC);
    }

    void checkTheme() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
    }

    public void dispose() {
        this.device = null;
    }

    public void drawBackground(GC gC, Rectangle rectangle, DrawData drawData) {
        this.checkTheme();
        if (gC == null) {
            SWT.error(4);
        }
        if (rectangle == null) {
            SWT.error(4);
        }
        if (drawData == null) {
            SWT.error(4);
        }
        if (gC.isDisposed()) {
            SWT.error(5);
        }
        drawData.draw(this, gC, rectangle);
    }

    public void drawFocus(GC gC, Rectangle rectangle, DrawData drawData) {
        this.checkTheme();
        if (gC == null) {
            SWT.error(4);
        }
        if (rectangle == null) {
            SWT.error(4);
        }
        if (drawData == null) {
            SWT.error(4);
        }
        if (gC.isDisposed()) {
            SWT.error(5);
        }
        gC.drawFocus(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void drawImage(GC gC, Rectangle rectangle, DrawData drawData, Image image, int n) {
        this.checkTheme();
        if (gC == null) {
            SWT.error(4);
        }
        if (rectangle == null) {
            SWT.error(4);
        }
        if (drawData == null) {
            SWT.error(4);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (gC.isDisposed()) {
            SWT.error(5);
        }
        drawData.drawImage(this, image, gC, rectangle);
    }

    public void drawText(GC gC, Rectangle rectangle, DrawData drawData, String string, int n) {
        this.checkTheme();
        if (gC == null) {
            SWT.error(4);
        }
        if (rectangle == null) {
            SWT.error(4);
        }
        if (drawData == null) {
            SWT.error(4);
        }
        if (string == null) {
            SWT.error(4);
        }
        if (gC.isDisposed()) {
            SWT.error(5);
        }
        drawData.drawText(this, string, n, gC, rectangle);
    }

    public Rectangle getBounds(int n, Rectangle rectangle, DrawData drawData) {
        this.checkTheme();
        if (rectangle == null) {
            SWT.error(4);
        }
        if (drawData == null) {
            SWT.error(4);
        }
        return drawData.getBounds(n, rectangle);
    }

    public int getSelection(Point point, Rectangle rectangle, RangeDrawData rangeDrawData) {
        this.checkTheme();
        if (point == null) {
            SWT.error(4);
        }
        if (rectangle == null) {
            SWT.error(4);
        }
        if (rangeDrawData == null) {
            SWT.error(4);
        }
        return rangeDrawData.getSelection(point, rectangle);
    }

    public int hitBackground(Point point, Rectangle rectangle, DrawData drawData) {
        this.checkTheme();
        if (point == null) {
            SWT.error(4);
        }
        if (rectangle == null) {
            SWT.error(4);
        }
        if (drawData == null) {
            SWT.error(4);
        }
        return drawData.hit(this, point, rectangle);
    }

    public boolean isDisposed() {
        return this.device == null;
    }

    public Rectangle measureText(GC gC, Rectangle rectangle, DrawData drawData, String string, int n) {
        this.checkTheme();
        if (gC == null) {
            SWT.error(4);
        }
        if (drawData == null) {
            SWT.error(4);
        }
        if (string == null) {
            SWT.error(4);
        }
        if (gC.isDisposed()) {
            SWT.error(5);
        }
        return drawData.measureText(this, string, n, gC, rectangle);
    }
}

