/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.CMSVersion;
import org.bouncycastle.asn1.cms.EncryptedKey;
import org.bouncycastle.asn1.cms.KEKIdentifier;
import org.bouncycastle.asn1.cms.KeyEncryptionAlgorithmIdentifier;

public class KEKRecipientInfo
implements DEREncodable {
    private CMSVersion version;
    private KEKIdentifier kekid;
    private KeyEncryptionAlgorithmIdentifier keyEncryptionAlgorithm;
    private EncryptedKey encryptedKey;

    public KEKRecipientInfo(CMSVersion cMSVersion, KEKIdentifier kEKIdentifier, KeyEncryptionAlgorithmIdentifier keyEncryptionAlgorithmIdentifier, EncryptedKey encryptedKey) {
        this.setVersion(cMSVersion);
        this.setKekid(kEKIdentifier);
        this.setKeyEncryptionAlgorithm(keyEncryptionAlgorithmIdentifier);
        this.setEncryptedKey(encryptedKey);
    }

    public KEKRecipientInfo(BERConstructedSequence bERConstructedSequence) {
        this.version = CMSVersion.getInstance(bERConstructedSequence.getObjectAt(0));
        this.kekid = KEKIdentifier.getInstance(bERConstructedSequence.getObjectAt(1));
        this.keyEncryptionAlgorithm = KeyEncryptionAlgorithmIdentifier.getInstance(bERConstructedSequence.getObjectAt(2));
        this.encryptedKey = EncryptedKey.getInstance(bERConstructedSequence.getObjectAt(3));
    }

    public KEKRecipientInfo(KEKRecipientInfo kEKRecipientInfo) {
        this.version = kEKRecipientInfo.version;
        this.kekid = kEKRecipientInfo.kekid;
        this.keyEncryptionAlgorithm = kEKRecipientInfo.keyEncryptionAlgorithm;
        this.encryptedKey = kEKRecipientInfo.encryptedKey;
    }

    public static KEKRecipientInfo getInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof KEKRecipientInfo) {
            return (KEKRecipientInfo)object;
        }
        if (object instanceof BERConstructedSequence) {
            return new KEKRecipientInfo((BERConstructedSequence)object);
        }
        if (object instanceof BERTaggedObject) {
            return KEKRecipientInfo.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid KEKRecipientInfo");
    }

    public static KEKRecipientInfo newInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof KEKRecipientInfo) {
            return new KEKRecipientInfo((KEKRecipientInfo)object);
        }
        if (object instanceof BERConstructedSequence) {
            return new KEKRecipientInfo((BERConstructedSequence)object);
        }
        if (object instanceof BERTaggedObject) {
            return KEKRecipientInfo.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid KEKRecipientInfo");
    }

    public CMSVersion getVersion() {
        return this.version;
    }

    private void setVersion(CMSVersion cMSVersion) {
        this.version = cMSVersion;
    }

    public KEKIdentifier getKekid() {
        return this.kekid;
    }

    private void setKekid(KEKIdentifier kEKIdentifier) {
        this.kekid = kEKIdentifier;
    }

    public KeyEncryptionAlgorithmIdentifier getKeyEncryptionAlgorithm() {
        return this.keyEncryptionAlgorithm;
    }

    private void setKeyEncryptionAlgorithm(KeyEncryptionAlgorithmIdentifier keyEncryptionAlgorithmIdentifier) {
        this.keyEncryptionAlgorithm = keyEncryptionAlgorithmIdentifier;
    }

    public EncryptedKey getEncryptedKey() {
        return this.encryptedKey;
    }

    private void setEncryptedKey(EncryptedKey encryptedKey) {
        this.encryptedKey = encryptedKey;
    }

    public DERObject getDERObject() {
        BERConstructedSequence bERConstructedSequence = new BERConstructedSequence();
        bERConstructedSequence.addObject(this.version);
        bERConstructedSequence.addObject(this.kekid);
        bERConstructedSequence.addObject(this.keyEncryptionAlgorithm);
        bERConstructedSequence.addObject(this.encryptedKey);
        return bERConstructedSequence;
    }
}

