/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.simpleframework.xml.core.ConstructorException;
import org.simpleframework.xml.core.ParameterMap;
import org.simpleframework.xml.core.Signature;
import org.simpleframework.xml.core.SignatureScanner;
import org.simpleframework.xml.stream.Format;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConstructorScanner {
    private List<Signature> signatures = new ArrayList<Signature>();
    private ParameterMap registry = new ParameterMap();
    private Signature primary;
    private Format format;

    public ConstructorScanner(Class type, Format format) throws Exception {
        this.format = format;
        this.scan(type);
    }

    public Signature getSignature() {
        return this.primary;
    }

    public List<Signature> getSignatures() {
        return new ArrayList<Signature>(this.signatures);
    }

    public ParameterMap getParameters() {
        return this.registry;
    }

    private void scan(Class type) throws Exception {
        Constructor<?>[] array = type.getDeclaredConstructors();
        if (!this.isInstantiable(type)) {
            throw new ConstructorException("Can not construct inner %s", type);
        }
        for (Constructor<?> factory : array) {
            if (type.isPrimitive()) continue;
            this.scan(factory);
        }
    }

    private void scan(Constructor factory) throws Exception {
        SignatureScanner scanner = new SignatureScanner(factory, this.registry, this.format);
        if (scanner.isValid()) {
            List<Signature> list = scanner.getSignatures();
            for (Signature signature : list) {
                int size = signature.size();
                if (size == 0) {
                    this.primary = signature;
                }
                this.signatures.add(signature);
            }
        }
    }

    private boolean isInstantiable(Class type) {
        int modifiers = type.getModifiers();
        if (Modifier.isStatic(modifiers)) {
            return true;
        }
        return !type.isMemberClass();
    }
}

