/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.core.service.registration;

import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceCertAuthentication {
    private static Logger logger = LoggerFactory.getLogger(DeviceCertAuthentication.class);
    private static final String WINDOWS_KEYINSTANCE = "Windows-ROOT";
    private static final String APPLE_KEYINSTANCE = "KeychainStore";
    private static final String KEYWORD_APPLE = "Apple";

    private DeviceCertAuthentication() {
    }

    public static byte[] getDeviceCertDetails(String certName) {
        KeyStore ks = null;
        byte[] keyBytes = null;
        try {
            if (System.getProperty("os.name").toLowerCase().contains("win")) {
                ks = KeyStore.getInstance(WINDOWS_KEYINSTANCE);
            } else if (System.getProperty("os.name").toLowerCase().contains("mac")) {
                ks = KeyStore.getInstance(APPLE_KEYINSTANCE, KEYWORD_APPLE);
            }
            Enumeration<String> en = null;
            if (ks != null) {
                ks.load(null, null);
                en = ks.aliases();
            }
            if (en == null) {
                return new byte[0];
            }
            while (en.hasMoreElements()) {
                String aliasKey = en.nextElement();
                Certificate c = ks.getCertificate(aliasKey);
                if (!aliasKey.equals(certName)) continue;
                logger.debug(" KEY FOUND ");
                PublicKey pk = c.getPublicKey();
                keyBytes = pk.getEncoded();
                return keyBytes;
            }
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | CertificateException e) {
            logger.trace("" + e);
            logger.error("Exception While getting Device cert Details :" + e.getMessage());
        }
        return keyBytes;
    }
}

