/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.core.helper;

import com.parablu.epa.core.constant.StringLiterals;
import com.parablu.epa.helper.utils.ParabluFileSystemUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyHelper {
    private static final Logger logger = LoggerFactory.getLogger(PropertyHelper.class);
    public static final String CLOUD_NAME = PropertyHelper.getMessageResourceString("Cloud-Name");
    private static final String WL_PROPERTIES = "WL.properties";
    public static final String REGVIEW_APPNAME = PropertyHelper.getMessageResourceString("App-Name");
    public static final String REGVIEW_CONNECT_TO_LABEL = PropertyHelper.getMessageResourceString("Connect-to-Vault");
    public static final String REGVIEW_CLOUD_DETAILS = PropertyHelper.getMessageResourceString("Cloud-details");
    public static final String REGVIEW_CLOUD_NAME = PropertyHelper.getMessageResourceString("Cloud-Name-Label");
    public static final String REGVIEWPROGRESS_CONNECTING_LABEL = PropertyHelper.getMessageResourceString("Connecting-Label");
    public static final String REGVIEWPROGRESS_SUCCESSFULL_LABEL = PropertyHelper.getMessageResourceString("Success-Label");
    public static final String REGVIEWPROGRESS_CONFIGURE_FOLDER_LABEL = PropertyHelper.getMessageResourceString("Configure-Folder-Label");
    public static final String SYSTRAY_BALLOONTIP_LABEL = PropertyHelper.getMessageResourceString("Systray-Balloon-Label");
    public static final String SYSTRAY_BALLOONTIP_BELOW_LABEL = PropertyHelper.getMessageResourceString("Systray-Balloon-Below-Label");
    public static final String SYSTRAY_TOOLTIP_LABEL = PropertyHelper.getMessageResourceString("Systray-Tooltip-Label");
    public static final String SYSTRAY_OPEN_SHORTCUT_FOLDER_LABEL = PropertyHelper.getMessageResourceString("Systray-Open-Folder-Label");
    public static final String EXIT_MSG_CONFIRMATION_LABEL = PropertyHelper.getMessageResourceString("Exit-Msg-Label");
    public static final String DECOUPLE_CONFIRMATION_LABEL = PropertyHelper.getMessageResourceString("Decouple-Msg-Label");
    public static final String NO_INTERNET_ICON = PropertyHelper.getMessageResourceString("No-Internet-Icon");
    public static final String SYS_TRAY_ICON = PropertyHelper.getMessageResourceString("Sys-Tray-Icon");
    public static final String TASK_BAR_ICON = PropertyHelper.getMessageResourceString("Task-Bar-Icon");
    public static final String REG_VIEW_SEARCH_GIF = PropertyHelper.getMessageResourceString("Reg-ViewSearch-Gif");
    public static final String REG_VIEW_VALIDATE_ICON = PropertyHelper.getMessageResourceString("Reg-View-Validate-Icon");
    public static final String SYS_TRAY_CURRENT_SYNCING_ICON = PropertyHelper.getMessageResourceString("Sys-Tray-Current-Syncing-Icon");
    public static final String SHORTCUT_FOLDER_NAME = PropertyHelper.getMessageResourceString("Shortcut-Folder-Name");
    public static final String SHORTCUT_FOLDER_IMAGE = PropertyHelper.getMessageResourceString("Shortcut-Folder-Image");
    public static final String USER_SYNC_BACK_DISABLED_ERROR_MESSAGE = PropertyHelper.getMessageResourceString("No-Permissions-Error");
    public static final String DEVICE_REGISTRATION_ERROR_MESSAGE = PropertyHelper.getMessageResourceString("Device-Registration-Error");
    public static final String DEVICE_REGISTRATION_ERROR_TITLE = PropertyHelper.getMessageResourceString("Device-Registration-Error-Title");
    public static final String HELP_LINK_SEND_MAIL = PropertyHelper.getMessageResourceString("Mail-Link");
    public static final String STATUS_CLOUD_UNREACHABLE = PropertyHelper.getMessageResourceString("Cloud-Unreachable");
    public static final String STATUS_FINISHED_SYNC = PropertyHelper.getMessageResourceString("Sync-Finished-Status");
    public static final String DEVICE_BLOCKED_FROM_ACCESS = PropertyHelper.getMessageResourceString("Device-Blocked-From-Access");
    public static final String DEVICE_LIMIT_EXCEEDED_ERROR_MESSAGE = PropertyHelper.getMessageResourceString("Device-Limit-Exceeded-Error");
    public static final String NO_CLOUDS_ATTACHED_ERROR_MESSAGE = PropertyHelper.getMessageResourceString("No-Clouds-Attached-Error");
    public static final String INSYNC_LABEL = PropertyHelper.getMessageResourceString("InSync-Label");
    public static final String USERNAME_TOOLTIP_LABEL = PropertyHelper.getMessageResourceString("UserName-Tooltip");
    public static final String CLOUD_NAME_TOOL_TIP = PropertyHelper.getMessageResourceString("CloudName-Tooltip");
    public static final String APP_WEBSITE_URL_FOR_SHELLEXT = PropertyHelper.getMessageResourceString("App-Website-Url");
    public static final String DEVICE_BLOCKED_MESSAGE_TOOLTIP = PropertyHelper.getMessageResourceString("Device-Blocked-Tooltip");
    public static final String SYNC_COMPLETE_MESSAGE_TOOLTIP = PropertyHelper.getMessageResourceString("Sync-CompleteMsg-Tooltip");
    public static final String LOGIN_CREDENTIALS_EXPIRED_MESSAGE_TOOLTIP = PropertyHelper.getMessageResourceString("Login-Credentials-Expired-Tooltip");
    public static final String BLUSYNC_VERSION_LABEL = PropertyHelper.getMessageResourceString("BluSync-Version-Label");
    public static final String MAIN_EBMS_DOMAIN = PropertyHelper.getMessageResourceString("Main-EBMS-domain");
    public static final String SUB_EBMS_DOMAIN = PropertyHelper.getMessageResourceString("Sub-EBMS-domain");
    public static final String CERT_FILE_ALIAS = PropertyHelper.getMessageResourceString("Cert-File-Alias");
    public static final String SUB_EBMS_DOMAIN_1 = PropertyHelper.getMessageResourceString("Sub-EBMS-domain-1");
    public static final String BKRYPT_DOMAIN_FOR_SYNC = PropertyHelper.getMessageResourceString("BK-domain-sync");
    public static final String BACKUP_CRAWL_LIMIT = PropertyHelper.getMessageResourceString("Backup-Crawl-Limit");
    public static final String AGENT_LISTNER_PORT = PropertyHelper.getMessageResourceString("Agent-Listner-Port");
    public static final String COMMAND_LISTNER_ENABLED = PropertyHelper.getMessageResourceString("Comand-Listner-Enabled");
    public static final String LOGIN_TYPE = PropertyHelper.getMessageResourceString("login-type");
    public static final String INSTALL_TYPE = PropertyHelper.getMessageResourceString("Install-type");
    public static final String WL_DIRECTORY_LINUX = "/opt/ParaBlu/Blusync/";
    public static final String EXCEP_STRING = "Exception getting Script Resource String :";
    private static String userHome = ParabluFileSystemUtils.getUserProfile();
    private static String wlDirectory;
    public static final String WAIT_TIME_SPARKLE_EXIT;
    public static final String MD5_CHECK_ENABLED;
    public static final String HASH_CHECK_INCLUDED;
    public static final String SYNC_CONNECTION_TIMEOUT_VALUE_IN_MILLI;
    public static final String SYNC_SOCKET_TIMEOUT_VALUE_IN_MILLI;
    public static final String PROXY_ENABLED;
    public static final String RESTORE_MAX_THREAD_COUNT;
    public static final String SSO_BROWSER_PREFERENCE;
    public static final String DEFAULT_THREAD_COUNT;
    public static final String OVERRIDE_IP_SETTINGS;
    public static final String DECOUPLED;
    public static final String NWLIST;

    private PropertyHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMessageResourceString(String key) {
        String usrHome;
        String text = "";
        userHome = usrHome = ParabluFileSystemUtils.getUserProfile();
        String osType = System.getProperty("os.name");
        ResourceBundle bundle = null;
        FileInputStream fis = null;
        try {
            if (osType.toLowerCase().contains("win")) {
                wlDirectory = userHome + StringLiterals.FILE_SEPARATOR + "AppData" + StringLiterals.FILE_SEPARATOR + "Roaming" + StringLiterals.FILE_SEPARATOR + "ParaBlu" + StringLiterals.FILE_SEPARATOR + "Blusync" + StringLiterals.FILE_SEPARATOR;
                fis = new FileInputStream(wlDirectory + WL_PROPERTIES);
                bundle = new PropertyResourceBundle(fis);
            } else if (osType.toLowerCase().contains("lin")) {
                String userHomeDir = System.getProperty("user.home");
                wlDirectory = userHomeDir + StringLiterals.FILE_SEPARATOR + ".ParaBlu" + StringLiterals.FILE_SEPARATOR + "ParaBlu" + StringLiterals.FILE_SEPARATOR + "Blusync" + StringLiterals.FILE_SEPARATOR;
                File wlFile = new File(wlDirectory + WL_PROPERTIES);
                Path optPropertyFile = Paths.get("/opt/parablu-epa/lib/app/ParaBlu/WL.properties", new String[0]);
                Path userHomePropertyFile = Paths.get(wlDirectory + WL_PROPERTIES, new String[0]);
                Path optLog4j = Paths.get("/opt/parablu-epa/lib/app/ParaBlu/ParaBlu-log4j.properties", new String[0]);
                Path userHomeLog4jFile = Paths.get(wlDirectory + "ParaBlu-log4j.properties", new String[0]);
                if (!wlFile.isFile()) {
                    Files.createDirectories(userHomePropertyFile.getParent(), new FileAttribute[0]);
                    Files.copy(optPropertyFile, userHomePropertyFile, StandardCopyOption.REPLACE_EXISTING);
                    Files.copy(optLog4j, userHomeLog4jFile, StandardCopyOption.REPLACE_EXISTING);
                } else if (wlFile.isFile() && PropertyHelper.compareVersions()) {
                    Files.copy(optPropertyFile, userHomePropertyFile, StandardCopyOption.REPLACE_EXISTING);
                    Files.copy(optLog4j, userHomeLog4jFile, StandardCopyOption.REPLACE_EXISTING);
                }
                fis = new FileInputStream(wlDirectory + WL_PROPERTIES);
                bundle = new PropertyResourceBundle(fis);
            } else if (osType.toLowerCase().contains("mac")) {
                String appDir = System.getProperty("java.library.path");
                wlDirectory = appDir + StringLiterals.CONSTANTS_FILE_SEPARATOR + "ParaBlu" + StringLiterals.CONSTANTS_FILE_SEPARATOR;
                fis = new FileInputStream(wlDirectory + WL_PROPERTIES);
                bundle = new PropertyResourceBundle(fis);
            } else {
                bundle = ResourceBundle.getBundle("WL", Locale.US);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.trace("", (Throwable)e);
            logger.error(EXCEP_STRING + e.getMessage());
        }
        try {
            if (bundle != null) {
                text = bundle.getString(key);
            }
        }
        catch (MissingResourceException e) {
            e.printStackTrace();
            logger.trace("", (Throwable)e);
            logger.error(EXCEP_STRING + e.getMessage());
            text = "";
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                logger.trace("", (Throwable)e);
                logger.error(EXCEP_STRING + e.getMessage());
            }
        }
        return text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean compareVersions() {
        boolean isNewVersionGreater = false;
        FileInputStream oldFis = null;
        FileInputStream newFis = null;
        try {
            oldFis = new FileInputStream(wlDirectory + WL_PROPERTIES);
            PropertyResourceBundle oldVersionBundle = new PropertyResourceBundle(oldFis);
            String oldVersion = oldVersionBundle.getString("BluSync-Version-Label");
            newFis = new FileInputStream("/opt/parablu-epa/lib/app/ParaBlu/WL.properties");
            PropertyResourceBundle newVersionBundle = new PropertyResourceBundle(newFis);
            String newVersion = newVersionBundle.getString("BluSync-Version-Label");
            ComparableVersion oldV = new ComparableVersion(oldVersion);
            ComparableVersion newV = new ComparableVersion(newVersion);
            if (oldV.compareTo(newV) < 0) {
                isNewVersionGreater = true;
            }
        }
        catch (IOException e) {
            logger.error("Error occurred during version comparison : " + e.getMessage());
        }
        finally {
            try {
                if (oldFis != null) {
                    oldFis.close();
                }
                if (newFis != null) {
                    newFis.close();
                }
            }
            catch (IOException e) {
                logger.error("Failed to close input streams : " + e.getMessage());
            }
        }
        return isNewVersionGreater;
    }

    public static void changeConfigProperty(String key, String value, int action) throws ConfigurationException {
        String osType = System.getProperty("os.name");
        if (osType.toLowerCase().contains("win")) {
            wlDirectory = userHome + StringLiterals.FILE_SEPARATOR + "AppData" + StringLiterals.FILE_SEPARATOR + "Roaming" + StringLiterals.FILE_SEPARATOR + "ParaBlu" + StringLiterals.FILE_SEPARATOR + "Blusync" + StringLiterals.FILE_SEPARATOR;
        } else if (osType.toLowerCase().contains("lin")) {
            String userHomeDir = System.getProperty("user.home");
            try {
                wlDirectory = userHomeDir + StringLiterals.FILE_SEPARATOR + ".ParaBlu" + StringLiterals.FILE_SEPARATOR + "ParaBlu" + StringLiterals.FILE_SEPARATOR + "Blusync" + StringLiterals.FILE_SEPARATOR;
                File wlFile = new File(wlDirectory + WL_PROPERTIES);
                Path optPropertyFile = Paths.get("/opt/parablu-epa/lib/app/ParaBlu/WL.properties", new String[0]);
                Path userHomePropertyFile = Paths.get(wlDirectory + WL_PROPERTIES, new String[0]);
                Path optLog4j = Paths.get("/opt/parablu-epa/lib/app/ParaBlu/ParaBlu-log4j.properties", new String[0]);
                Path userHomeLog4jFile = Paths.get(wlDirectory + "ParaBlu-log4j.properties", new String[0]);
                if (!wlFile.isFile()) {
                    Files.createDirectories(userHomePropertyFile.getParent(), new FileAttribute[0]);
                    Files.copy(optPropertyFile, userHomePropertyFile, StandardCopyOption.REPLACE_EXISTING);
                    Files.copy(optLog4j, userHomeLog4jFile, StandardCopyOption.REPLACE_EXISTING);
                } else if (wlFile.isFile() && PropertyHelper.compareVersions()) {
                    Files.copy(optPropertyFile, userHomePropertyFile, StandardCopyOption.REPLACE_EXISTING);
                    Files.copy(optLog4j, userHomeLog4jFile, StandardCopyOption.REPLACE_EXISTING);
                }
            }
            catch (IOException e) {
                logger.trace("", (Throwable)e);
                logger.error("Exception while changing config property : " + e.getMessage());
            }
        } else if (osType.toLowerCase().contains("mac")) {
            String appDir = System.getProperty("java.library.path");
            wlDirectory = appDir + StringLiterals.CONSTANTS_FILE_SEPARATOR + "ParaBlu" + StringLiterals.CONSTANTS_FILE_SEPARATOR;
        }
        PropertiesConfiguration config = new PropertiesConfiguration(wlDirectory + WL_PROPERTIES);
        if (action == Actions.ADD.ordinal()) {
            config.addProperty(key, (Object)value);
        }
        if (action == Actions.EDIT.ordinal()) {
            config.setProperty(key, (Object)value);
        }
        if (action == Actions.DELETE.ordinal()) {
            config.clearProperty(key);
        }
        config.save();
        logger.debug("Property changed successfully");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getScriptResourceString(String key) {
        String text = "";
        String osType = System.getProperty("os.name");
        String keyTemp = key;
        keyTemp = osType.substring(0, 3).concat(keyTemp);
        logger.debug("Script key :" + keyTemp);
        ResourceBundle bundle = null;
        FileInputStream fis = null;
        try {
            if (osType.toLowerCase().contains("win")) {
                String scDir = userHome + StringLiterals.FILE_SEPARATOR + "AppData" + StringLiterals.FILE_SEPARATOR + "Roaming" + StringLiterals.FILE_SEPARATOR + "ParaBlu" + StringLiterals.FILE_SEPARATOR + "Scripts" + StringLiterals.FILE_SEPARATOR;
                fis = new FileInputStream(scDir + "SC.properties");
                bundle = new PropertyResourceBundle(fis);
            } else if (osType.toLowerCase().contains("lin")) {
                String userHomeDir = System.getProperty("user.home");
                wlDirectory = userHomeDir + StringLiterals.FILE_SEPARATOR + ".ParaBlu" + StringLiterals.FILE_SEPARATOR + "ParaBlu" + StringLiterals.FILE_SEPARATOR + "Blusync" + StringLiterals.FILE_SEPARATOR;
                fis = new FileInputStream(wlDirectory + "SC.properties");
                bundle = new PropertyResourceBundle(fis);
            } else {
                bundle = ResourceBundle.getBundle("SC", Locale.US);
            }
        }
        catch (IOException e) {
            logger.trace("" + e);
            logger.error(EXCEP_STRING + e.getMessage());
        }
        try {
            if (bundle != null) {
                text = bundle.getString(keyTemp);
            }
        }
        catch (MissingResourceException e) {
            logger.trace("" + e);
            logger.error(EXCEP_STRING + e.getMessage());
            logger.debug("Missing Resource");
            text = "";
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                logger.trace("" + e);
                logger.error(EXCEP_STRING + e.getMessage());
            }
        }
        return text;
    }

    static {
        WAIT_TIME_SPARKLE_EXIT = PropertyHelper.getMessageResourceString("Wait-time-sparkle-exit-milli-sec");
        MD5_CHECK_ENABLED = PropertyHelper.getMessageResourceString("Md5-Check-Enabled-Restore");
        HASH_CHECK_INCLUDED = PropertyHelper.getMessageResourceString("Include-TableId");
        SYNC_CONNECTION_TIMEOUT_VALUE_IN_MILLI = PropertyHelper.getMessageResourceString("Sync-Conn-Timeout-Value-In-Milli");
        SYNC_SOCKET_TIMEOUT_VALUE_IN_MILLI = PropertyHelper.getMessageResourceString("Sync-Conn-Timeout-Value-In-Milli");
        PROXY_ENABLED = PropertyHelper.getMessageResourceString("Proxy-Enabled");
        RESTORE_MAX_THREAD_COUNT = PropertyHelper.getMessageResourceString("Restore-Max-Thread-Count");
        SSO_BROWSER_PREFERENCE = PropertyHelper.getMessageResourceString("SSO-Browser-preference");
        DEFAULT_THREAD_COUNT = PropertyHelper.getMessageResourceString("Default-Thread-Count");
        OVERRIDE_IP_SETTINGS = PropertyHelper.getMessageResourceString("Override-Ip-Settings");
        DECOUPLED = PropertyHelper.getMessageResourceString("decoupled");
        NWLIST = PropertyHelper.getMessageResourceString("NWList");
    }

    public static enum Actions {
        ADD,
        EDIT,
        DELETE;

    }
}

