/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import java.math.BigInteger;
import java.util.Enumeration;
import org.bouncycastle.asn1.DERConstructedSequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;

public class DSAParameter
implements DEREncodable {
    DERInteger p;
    DERInteger q;
    DERInteger g;

    public DSAParameter(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        this.p = new DERInteger(bigInteger);
        this.q = new DERInteger(bigInteger2);
        this.g = new DERInteger(bigInteger3);
    }

    public DSAParameter(DERConstructedSequence dERConstructedSequence) {
        Enumeration enumeration = dERConstructedSequence.getObjects();
        this.p = (DERInteger)enumeration.nextElement();
        this.q = (DERInteger)enumeration.nextElement();
        this.g = (DERInteger)enumeration.nextElement();
    }

    public BigInteger getP() {
        return this.p.getPositiveValue();
    }

    public BigInteger getQ() {
        return this.q.getPositiveValue();
    }

    public BigInteger getG() {
        return this.g.getPositiveValue();
    }

    public DERObject getDERObject() {
        DERConstructedSequence dERConstructedSequence = new DERConstructedSequence();
        dERConstructedSequence.addObject(this.p);
        dERConstructedSequence.addObject(this.q);
        dERConstructedSequence.addObject(this.g);
        return dERConstructedSequence;
    }
}

