/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.security.Security;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTestResult;
import org.bouncycastle.util.test.Test;
import org.bouncycastle.util.test.TestResult;

public class HMacTest
implements Test {
    static byte[] keyBytes = Hex.decode("0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b");
    static byte[] message = "Hi There".getBytes();
    static byte[] output1 = Hex.decode("b617318655057264e28bc0b6fb378c8ef146be00");
    static byte[] output256 = Hex.decode("b0344c61d8db38535ca8afceaf0bf12b881dc200c9833da726e9376c2e32cff7");
    static byte[] output384 = Hex.decode("0a046aaa0255e432912228f8ccda437c8a8363fb160afb0570ab5b1fd5ddc20eb1888b9ed4e5b6cb5bc034cd9ef70e40");
    static byte[] output512 = Hex.decode("9656975ee5de55e75f2976ecce9a04501060b9dc22a6eda2eaef638966280182477fe09f080b2bf564649cad42af8607a2bd8d02979df3a980f15e2326a0a22a");

    private boolean arraysEqual(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public TestResult testHMac(String string, byte[] byArray) {
        Mac mac;
        SecretKeySpec secretKeySpec = new SecretKeySpec(keyBytes, string);
        try {
            mac = Mac.getInstance(string, "BC");
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": Failed - exception " + exception.toString());
        }
        try {
            mac.init(secretKeySpec);
        }
        catch (Exception exception) {
            return new SimpleTestResult(false, this.getName() + ": Failed - exception " + exception.toString());
        }
        mac.update(message, 0, message.length);
        byte[] byArray2 = mac.doFinal();
        if (!this.arraysEqual(byArray2, byArray)) {
            return new SimpleTestResult(false, this.getName() + ": Failed - expected " + new String(Hex.encode(byArray)) + " got " + new String(Hex.encode(byArray2)));
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public TestResult perform() {
        TestResult testResult = this.testHMac("HMac-SHA1", output1);
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        testResult = this.testHMac("HMac-SHA256", output256);
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        testResult = this.testHMac("HMac-SHA384", output384);
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        testResult = this.testHMac("HMac-SHA512", output512);
        if (!testResult.isSuccessful()) {
            return testResult;
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    public String getName() {
        return "HMac";
    }

    public static void main(String[] stringArray) {
        Security.addProvider(new BouncyCastleProvider());
        HMacTest hMacTest = new HMacTest();
        TestResult testResult = hMacTest.perform();
        System.out.println(testResult.toString());
    }
}

