/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;

public class Signature
implements DEREncodable {
    private DERBitString bitString;

    public Signature(byte[] byArray) {
        this.setBitString(byArray);
    }

    public Signature(DERBitString dERBitString) {
        this.bitString = dERBitString;
    }

    public Signature(Signature signature) {
        this.bitString = signature.bitString;
    }

    public static Signature getInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Signature) {
            return (Signature)object;
        }
        if (object instanceof DERBitString) {
            return new Signature((DERBitString)object);
        }
        if (object instanceof BERTaggedObject) {
            return Signature.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid Signature");
    }

    public static Signature newInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Signature) {
            return new Signature((Signature)object);
        }
        if (object instanceof DERBitString) {
            return new Signature((DERBitString)object);
        }
        if (object instanceof BERTaggedObject) {
            return Signature.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid Signature");
    }

    public byte[] getBitString() {
        return this.bitString.getBytes();
    }

    private void setBitString(byte[] byArray) {
        this.bitString = new DERBitString(byArray);
    }

    public DERObject getDERObject() {
        return this.bitString;
    }
}

