/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.custom.Bullet;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.custom.StyledTextEvent;
import org.eclipse.swt.custom.TextChangingEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.IME;
import org.eclipse.swt.widgets.ScrollBar;

class StyledTextRenderer {
    Device device;
    StyledText styledText;
    StyledTextContent content;
    Font regularFont;
    Font boldFont;
    Font italicFont;
    Font boldItalicFont;
    int tabWidth;
    int ascent;
    int descent;
    int averageCharWidth;
    int topIndex = -1;
    TextLayout[] layouts;
    int lineCount;
    int[] lineWidth;
    int[] lineHeight;
    LineInfo[] lines;
    int maxWidth;
    int maxWidthLineIndex;
    boolean idleRunning;
    Bullet[] bullets;
    int[] bulletsIndices;
    int[] redrawLines;
    int[] ranges;
    int styleCount;
    StyleRange[] styles;
    StyleRange[] stylesSet;
    int stylesSetCount = 0;
    boolean hasLinks;
    boolean fixedPitch;
    static final int BULLET_MARGIN = 8;
    static final boolean COMPACT_STYLES = true;
    static final boolean MERGE_STYLES = true;
    static final int GROW = 32;
    static final int IDLE_TIME = 50;
    static final int CACHE_SIZE = 128;
    static final int BACKGROUND = 1;
    static final int ALIGNMENT = 2;
    static final int INDENT = 4;
    static final int JUSTIFY = 8;
    static final int SEGMENTS = 32;
    static final int TABSTOPS = 64;
    static final int WRAP_INDENT = 128;
    static final int SEGMENT_CHARS = 256;

    StyledTextRenderer(Device device, StyledText styledText) {
        this.device = device;
        this.styledText = styledText;
    }

    int addMerge(int[] nArray, StyleRange[] styleRangeArray, int n, int n2, int n3) {
        int n4;
        int n5 = this.styleCount << 1;
        StyleRange styleRange = null;
        int n6 = 0;
        int n7 = 0;
        if (n3 < n5) {
            styleRange = this.styles[n3 >> 1];
            n6 = this.ranges[n3];
            n7 = this.ranges[n3 + 1];
        }
        if (n5 + (n4 = n - (n3 - n2)) >= this.ranges.length) {
            int[] nArray2 = new int[this.ranges.length + n4 + 64];
            System.arraycopy(this.ranges, 0, nArray2, 0, n2);
            StyleRange[] styleRangeArray2 = new StyleRange[this.styles.length + (n4 >> 1) + 32];
            System.arraycopy(this.styles, 0, styleRangeArray2, 0, n2 >> 1);
            if (n5 > n3) {
                System.arraycopy(this.ranges, n3, nArray2, n2 + n, n5 - n3);
                System.arraycopy(this.styles, n3 >> 1, styleRangeArray2, n2 + n >> 1, this.styleCount - (n3 >> 1));
            }
            this.ranges = nArray2;
            this.styles = styleRangeArray2;
        } else if (n5 > n3) {
            System.arraycopy(this.ranges, n3, this.ranges, n2 + n, n5 - n3);
            System.arraycopy(this.styles, n3 >> 1, this.styles, n2 + n >> 1, this.styleCount - (n3 >> 1));
        }
        int n8 = n2;
        for (int i = 0; i < n; i += 2) {
            if (n8 > 0 && this.ranges[n8 - 2] + this.ranges[n8 - 1] == nArray[i] && styleRangeArray[i >> 1].similarTo(this.styles[n8 - 2 >> 1])) {
                int n9 = n8 - 1;
                this.ranges[n9] = this.ranges[n9] + nArray[i + 1];
                continue;
            }
            this.styles[n8 >> 1] = styleRangeArray[i >> 1];
            this.ranges[n8++] = nArray[i];
            this.ranges[n8++] = nArray[i + 1];
        }
        if (styleRange != null && this.ranges[n8 - 2] + this.ranges[n8 - 1] == n6 && styleRange.similarTo(this.styles[n8 - 2 >> 1])) {
            int n10 = n8 - 1;
            this.ranges[n10] = this.ranges[n10] + n7;
            n3 += 2;
            n += 2;
        }
        if (n5 > n3) {
            System.arraycopy(this.ranges, n2 + n, this.ranges, n8, n5 - n3);
            System.arraycopy(this.styles, n2 + n >> 1, this.styles, n8 >> 1, this.styleCount - (n3 >> 1));
        }
        n4 = n8 - n2 - (n3 - n2);
        this.styleCount += n4 >> 1;
        return n4;
    }

    int addMerge(StyleRange[] styleRangeArray, int n, int n2, int n3) {
        int n4 = n - (n3 - n2);
        StyleRange styleRange = null;
        if (n3 < this.styleCount) {
            styleRange = this.styles[n3];
        }
        if (this.styleCount + n4 >= this.styles.length) {
            StyleRange[] styleRangeArray2 = new StyleRange[this.styles.length + n4 + 32];
            System.arraycopy(this.styles, 0, styleRangeArray2, 0, n2);
            if (this.styleCount > n3) {
                System.arraycopy(this.styles, n3, styleRangeArray2, n2 + n, this.styleCount - n3);
            }
            this.styles = styleRangeArray2;
        } else if (this.styleCount > n3) {
            System.arraycopy(this.styles, n3, this.styles, n2 + n, this.styleCount - n3);
        }
        int n5 = n2;
        for (int i = 0; i < n; ++i) {
            StyleRange styleRange2 = styleRangeArray[i];
            if (n5 > 0) {
                StyleRange styleRange3 = this.styles[n5 - 1];
                if (styleRange3.start + styleRange3.length == styleRange2.start && styleRange2.similarTo(styleRange3)) {
                    styleRange3.length += styleRange2.length;
                    continue;
                }
            }
            this.styles[n5++] = styleRange2;
        }
        StyleRange styleRange4 = this.styles[n5 - 1];
        if (styleRange != null && styleRange4.start + styleRange4.length == styleRange.start && styleRange.similarTo(styleRange4)) {
            styleRange4.length += styleRange.length;
            ++n3;
            ++n;
        }
        if (this.styleCount > n3) {
            System.arraycopy(this.styles, n2 + n, this.styles, n5, this.styleCount - n3);
        }
        n4 = n5 - n2 - (n3 - n2);
        this.styleCount += n4;
        return n4;
    }

    void calculate(int n, int n2) {
        int n3 = n + n2;
        if (n < 0 || n3 > this.lineWidth.length) {
            return;
        }
        int n4 = this.styledText.leftMargin + this.styledText.rightMargin + this.styledText.getCaretWidth();
        for (int i = n; i < n3; ++i) {
            if (this.lineWidth[i] == -1 || this.lineHeight[i] == -1) {
                TextLayout textLayout = this.getTextLayout(i);
                Rectangle rectangle = textLayout.getBounds();
                this.lineWidth[i] = rectangle.width + n4;
                this.lineHeight[i] = rectangle.height;
                this.disposeTextLayout(textLayout);
            }
            if (this.lineWidth[i] <= this.maxWidth) continue;
            this.maxWidth = this.lineWidth[i];
            this.maxWidthLineIndex = i;
        }
    }

    void calculateClientArea() {
        int n = Math.max(0, this.styledText.getTopIndex());
        int n2 = this.content.getLineCount();
        int n3 = this.styledText.getClientArea().height;
        for (int i = 0; n3 > i && n2 > n && this.lineHeight.length > n; i += this.lineHeight[n++]) {
            this.calculate(n, 1);
        }
    }

    void calculateIdle() {
        if (this.idleRunning) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                int n;
                if (StyledTextRenderer.this.styledText == null) {
                    return;
                }
                long l = System.currentTimeMillis();
                for (n = 0; n < StyledTextRenderer.this.lineCount; ++n) {
                    if (StyledTextRenderer.this.lineHeight[n] != -1 && StyledTextRenderer.this.lineWidth[n] != -1) continue;
                    StyledTextRenderer.this.calculate(n, 1);
                    if (System.currentTimeMillis() - l > 50L) break;
                }
                if (n < StyledTextRenderer.this.lineCount) {
                    Display display = StyledTextRenderer.this.styledText.getDisplay();
                    display.asyncExec(this);
                } else {
                    StyledTextRenderer.this.idleRunning = false;
                    StyledTextRenderer.this.styledText.setScrollBars(true);
                    ScrollBar scrollBar = StyledTextRenderer.this.styledText.getVerticalBar();
                    if (scrollBar != null) {
                        scrollBar.setSelection(StyledTextRenderer.this.styledText.getVerticalScrollOffset());
                    }
                }
            }
        };
        Display display = this.styledText.getDisplay();
        display.asyncExec(runnable);
        this.idleRunning = true;
    }

    void clearLineBackground(int n, int n2) {
        if (this.lines == null) {
            return;
        }
        for (int i = n; i < n + n2; ++i) {
            LineInfo lineInfo = this.lines[i];
            if (lineInfo == null) continue;
            lineInfo.flags &= 0xFFFFFFFE;
            lineInfo.background = null;
            if (lineInfo.flags != 0) continue;
            this.lines[i] = null;
        }
    }

    void clearLineStyle(int n, int n2) {
        if (this.lines == null) {
            return;
        }
        for (int i = n; i < n + n2; ++i) {
            LineInfo lineInfo = this.lines[i];
            if (lineInfo == null) continue;
            lineInfo.flags &= 0xFFFFFF31;
            if (lineInfo.flags != 0) continue;
            this.lines[i] = null;
        }
    }

    void copyInto(StyledTextRenderer styledTextRenderer) {
        int n;
        Object[] objectArray;
        if (this.ranges != null) {
            styledTextRenderer.ranges = new int[this.styleCount << 1];
            objectArray = styledTextRenderer.ranges;
            System.arraycopy(this.ranges, 0, objectArray, 0, objectArray.length);
        }
        if (this.styles != null) {
            styledTextRenderer.styles = new StyleRange[this.styleCount];
            objectArray = styledTextRenderer.styles;
            for (n = 0; n < objectArray.length; ++n) {
                objectArray[n] = (int)((StyleRange)this.styles[n].clone());
            }
            styledTextRenderer.styleCount = this.styleCount;
        }
        if (this.lines != null) {
            styledTextRenderer.lines = new LineInfo[this.lineCount];
            objectArray = styledTextRenderer.lines;
            for (n = 0; n < objectArray.length; ++n) {
                objectArray[n] = (int)new LineInfo(this.lines[n]);
            }
            styledTextRenderer.lineCount = this.lineCount;
        }
    }

    void dispose() {
        if (this.boldFont != null) {
            this.boldFont.dispose();
        }
        if (this.italicFont != null) {
            this.italicFont.dispose();
        }
        if (this.boldItalicFont != null) {
            this.boldItalicFont.dispose();
        }
        this.boldItalicFont = null;
        this.italicFont = null;
        this.boldFont = null;
        this.reset();
        this.content = null;
        this.device = null;
        this.styledText = null;
    }

    void disposeTextLayout(TextLayout textLayout) {
        if (this.layouts != null) {
            for (int i = 0; i < this.layouts.length; ++i) {
                if (this.layouts[i] != textLayout) continue;
                return;
            }
        }
        textLayout.dispose();
    }

    void drawBullet(Bullet bullet, GC gC, int n, int n2, int n3, int n4, int n5) {
        Font font;
        StyleRange styleRange = bullet.style;
        GlyphMetrics glyphMetrics = styleRange.metrics;
        Color color = styleRange.foreground;
        if (color != null) {
            gC.setForeground(color);
        }
        if ((font = styleRange.font) != null) {
            gC.setFont(font);
        }
        String string = "";
        int n6 = bullet.type & 0xF;
        switch (n6) {
            case 1: {
                string = "\u2022";
                break;
            }
            case 2: {
                string = String.valueOf(n3 + 1);
                break;
            }
            case 4: {
                string = String.valueOf((char)(n3 % 26 + 97));
                break;
            }
            case 8: {
                string = String.valueOf((char)(n3 % 26 + 65));
            }
        }
        if ((bullet.type & 0x10) != 0) {
            string = string + bullet.text;
        }
        Display display = this.styledText.getDisplay();
        TextLayout textLayout = new TextLayout(display);
        textLayout.setText(string);
        textLayout.setAscent(n4);
        textLayout.setDescent(n5);
        styleRange = (StyleRange)styleRange.clone();
        styleRange.metrics = null;
        if (styleRange.font == null) {
            styleRange.font = this.getFont(styleRange.fontStyle);
        }
        textLayout.setStyle(styleRange, 0, string.length());
        int n7 = n + Math.max(0, glyphMetrics.width - textLayout.getBounds().width - 8);
        textLayout.draw(gC, n7, n2);
        textLayout.dispose();
    }

    int drawLine(int n, int n2, int n3, GC gC, Color color, Color color2) {
        int n4;
        Object object;
        Object object2;
        int n5;
        TextLayout textLayout = this.getTextLayout(n);
        String string = this.content.getLine(n);
        int n6 = this.content.getOffsetAtLine(n);
        int n7 = string.length();
        Point point = this.styledText.getSelection();
        int n8 = point.x - n6;
        int n9 = point.y - n6;
        if (this.styledText.getBlockSelection()) {
            n9 = 0;
            n8 = 0;
        }
        Rectangle rectangle = this.styledText.getClientArea();
        Color color3 = this.getLineBackground(n, null);
        StyledTextEvent styledTextEvent = this.styledText.getLineBackgroundData(n6, string);
        if (styledTextEvent != null && styledTextEvent.lineBackground != null) {
            color3 = styledTextEvent.lineBackground;
        }
        int n10 = textLayout.getBounds().height;
        if (color3 != null) {
            gC.setBackground(color3);
            gC.fillRectangle(rectangle.x, n3, rectangle.width, n10);
        } else {
            gC.setBackground(color);
            this.styledText.drawBackground(gC, rectangle.x, n3, rectangle.width, n10);
        }
        gC.setForeground(color2);
        if (n8 == n9 || n9 <= 0 && n8 > n7 - 1) {
            textLayout.draw(gC, n2, n3);
        } else {
            int n11 = Math.max(0, n8);
            n5 = Math.min(n7, n9);
            object2 = this.styledText.getSelectionForeground();
            object = this.styledText.getSelectionBackground();
            n4 = (this.styledText.getStyle() & 0x10000) != 0 ? 65536 : 131072;
            if (n8 <= n7 && n7 < n9) {
                n4 |= 0x100000;
            }
            textLayout.draw(gC, n2, n3, n11, n5 - 1, (Color)object2, (Color)object, n4);
        }
        Bullet bullet = null;
        n5 = -1;
        if (this.bullets != null) {
            if (this.bulletsIndices != null) {
                int n12 = n - this.topIndex;
                if (0 <= n12 && n12 < 128) {
                    bullet = this.bullets[n12];
                    n5 = this.bulletsIndices[n12];
                }
            } else {
                for (int i = 0; i < this.bullets.length && (n5 = (bullet = this.bullets[i]).indexOf(n)) == -1; ++i) {
                }
            }
        }
        if (n5 != -1 && bullet != null) {
            object2 = textLayout.getLineMetrics(0);
            int n13 = ((FontMetrics)object2).getAscent() + ((FontMetrics)object2).getLeading();
            if (bullet.type == 32) {
                bullet.style.start = n6;
                this.styledText.paintObject(gC, n2, n3, n13, ((FontMetrics)object2).getDescent(), bullet.style, bullet, n5);
            } else {
                this.drawBullet(bullet, gC, n2, n3, n5, n13, ((FontMetrics)object2).getDescent());
            }
        }
        object2 = textLayout.getStyles();
        object = null;
        for (n4 = 0; n4 < ((Object)object2).length; ++n4) {
            if (((TextStyle)object2[n4]).metrics == null) continue;
            if (object == null) {
                object = textLayout.getRanges();
            }
            Color color4 = object[n4 << 1];
            reference var24_28 = object[(n4 << 1) + 1] - color4 + true;
            Point point2 = textLayout.getLocation((int)color4, false);
            FontMetrics fontMetrics = textLayout.getLineMetrics(textLayout.getLineIndex((int)color4));
            StyleRange styleRange = (StyleRange)((StyleRange)object2[n4]).clone();
            styleRange.start = (int)(color4 + n6);
            styleRange.length = (int)var24_28;
            int n14 = fontMetrics.getAscent() + fontMetrics.getLeading();
            this.styledText.paintObject(gC, point2.x + n2, point2.y + n3, n14, fontMetrics.getDescent(), styleRange, null, 0);
        }
        this.disposeTextLayout(textLayout);
        return n10;
    }

    int getBaseline() {
        return this.ascent;
    }

    Font getFont(int n) {
        switch (n) {
            case 1: {
                if (this.boldFont != null) {
                    return this.boldFont;
                }
                this.boldFont = new Font(this.device, this.getFontData(n));
                return this.boldFont;
            }
            case 2: {
                if (this.italicFont != null) {
                    return this.italicFont;
                }
                this.italicFont = new Font(this.device, this.getFontData(n));
                return this.italicFont;
            }
            case 3: {
                if (this.boldItalicFont != null) {
                    return this.boldItalicFont;
                }
                this.boldItalicFont = new Font(this.device, this.getFontData(n));
                return this.boldItalicFont;
            }
        }
        return this.regularFont;
    }

    FontData[] getFontData(int n) {
        FontData[] fontDataArray = this.regularFont.getFontData();
        for (int i = 0; i < fontDataArray.length; ++i) {
            fontDataArray[i].setStyle(n);
        }
        return fontDataArray;
    }

    int getHeight() {
        int n = this.getLineHeight();
        if (this.styledText.isFixedLineHeight()) {
            return this.lineCount * n + this.styledText.topMargin + this.styledText.bottomMargin;
        }
        int n2 = 0;
        int n3 = this.styledText.getWrapWidth();
        for (int i = 0; i < this.lineCount; ++i) {
            int n4 = this.lineHeight[i];
            if (n4 == -1) {
                if (n3 > 0) {
                    int n5 = this.content.getLine(i).length();
                    n4 = (n5 * this.averageCharWidth / n3 + 1) * n;
                } else {
                    n4 = n;
                }
            }
            n2 += n4;
        }
        return n2 + this.styledText.topMargin + this.styledText.bottomMargin;
    }

    boolean hasLink(int n) {
        String string;
        if (n == -1) {
            return false;
        }
        int n2 = this.content.getLineAtOffset(n);
        int n3 = this.content.getOffsetAtLine(n2);
        StyledTextEvent styledTextEvent = this.styledText.getLineStyleData(n3, string = this.content.getLine(n2));
        if (styledTextEvent != null) {
            StyleRange[] styleRangeArray = styledTextEvent.styles;
            if (styleRangeArray != null) {
                int[] nArray = styledTextEvent.ranges;
                if (nArray != null) {
                    for (int i = 0; i < nArray.length; i += 2) {
                        if (nArray[i] > n || n >= nArray[i] + nArray[i + 1] || !styleRangeArray[i >> 1].underline || styleRangeArray[i >> 1].underlineStyle != 4) continue;
                        return true;
                    }
                } else {
                    for (int i = 0; i < styleRangeArray.length; ++i) {
                        StyleRange styleRange = styleRangeArray[i];
                        if (styleRange.start > n || n >= styleRange.start + styleRange.length || !styleRange.underline || styleRange.underlineStyle != 4) continue;
                        return true;
                    }
                }
            }
        } else if (this.ranges != null) {
            int n4 = this.styleCount << 1;
            int n5 = this.getRangeIndex(n, -1, n4);
            if (n5 >= n4) {
                return false;
            }
            int n6 = this.ranges[n5];
            int n7 = this.ranges[n5 + 1];
            StyleRange styleRange = this.styles[n5 >> 1];
            if (n6 <= n && n < n6 + n7 && styleRange.underline && styleRange.underlineStyle == 4) {
                return true;
            }
        }
        return false;
    }

    int getLineAlignment(int n, int n2) {
        if (this.lines == null) {
            return n2;
        }
        LineInfo lineInfo = this.lines[n];
        if (lineInfo != null && (lineInfo.flags & 2) != 0) {
            return lineInfo.alignment;
        }
        return n2;
    }

    Color getLineBackground(int n, Color color) {
        if (this.lines == null) {
            return color;
        }
        LineInfo lineInfo = this.lines[n];
        if (lineInfo != null && (lineInfo.flags & 1) != 0) {
            return lineInfo.background;
        }
        return color;
    }

    Bullet getLineBullet(int n, Bullet bullet) {
        if (this.bullets == null) {
            return bullet;
        }
        if (this.bulletsIndices != null) {
            return bullet;
        }
        for (int i = 0; i < this.bullets.length; ++i) {
            Bullet bullet2 = this.bullets[i];
            if (bullet2.indexOf(n) == -1) continue;
            return bullet2;
        }
        return bullet;
    }

    int getLineHeight() {
        return this.ascent + this.descent;
    }

    int getLineHeight(int n) {
        if (this.lineHeight[n] == -1) {
            this.calculate(n, 1);
        }
        return this.lineHeight[n];
    }

    int getLineIndent(int n, int n2) {
        if (this.lines == null) {
            return n2;
        }
        LineInfo lineInfo = this.lines[n];
        if (lineInfo != null && (lineInfo.flags & 4) != 0) {
            return lineInfo.indent;
        }
        return n2;
    }

    int getLineWrapIndent(int n, int n2) {
        if (this.lines == null) {
            return n2;
        }
        LineInfo lineInfo = this.lines[n];
        if (lineInfo != null && (lineInfo.flags & 0x80) != 0) {
            return lineInfo.wrapIndent;
        }
        return n2;
    }

    boolean getLineJustify(int n, boolean bl) {
        if (this.lines == null) {
            return bl;
        }
        LineInfo lineInfo = this.lines[n];
        if (lineInfo != null && (lineInfo.flags & 8) != 0) {
            return lineInfo.justify;
        }
        return bl;
    }

    int[] getLineTabStops(int n, int[] nArray) {
        if (this.lines == null) {
            return nArray;
        }
        LineInfo lineInfo = this.lines[n];
        if (lineInfo != null && (lineInfo.flags & 0x40) != 0) {
            return lineInfo.tabStops;
        }
        return nArray;
    }

    int getRangeIndex(int n, int n2, int n3) {
        if (this.styleCount == 0) {
            return 0;
        }
        if (this.ranges != null) {
            while (n3 - n2 > 2) {
                int n4 = (n3 + n2) / 2 / 2 * 2;
                int n5 = this.ranges[n4] + this.ranges[n4 + 1];
                if (n5 > n) {
                    n3 = n4;
                    continue;
                }
                n2 = n4;
            }
        } else {
            while (n3 - n2 > 1) {
                int n6 = (n3 + n2) / 2;
                int n7 = this.styles[n6].start + this.styles[n6].length;
                if (n7 > n) {
                    n3 = n6;
                    continue;
                }
                n2 = n6;
            }
        }
        return n3;
    }

    int[] getRanges(int n, int n2) {
        int[] nArray;
        if (n2 == 0) {
            return null;
        }
        int n3 = n + n2 - 1;
        if (this.ranges != null) {
            int n4 = this.styleCount << 1;
            int n5 = this.getRangeIndex(n, -1, n4);
            if (n5 >= n4) {
                return null;
            }
            if (this.ranges[n5] > n3) {
                return null;
            }
            int n6 = Math.min(n4 - 2, this.getRangeIndex(n3, n5 - 1, n4));
            if (this.ranges[n6] > n3) {
                n6 = Math.max(n5, n6 - 2);
            }
            nArray = new int[n6 - n5 + 2];
            System.arraycopy(this.ranges, n5, nArray, 0, nArray.length);
        } else {
            int n7 = this.getRangeIndex(n, -1, this.styleCount);
            if (n7 >= this.styleCount) {
                return null;
            }
            if (this.styles[n7].start > n3) {
                return null;
            }
            int n8 = Math.min(this.styleCount - 1, this.getRangeIndex(n3, n7 - 1, this.styleCount));
            if (this.styles[n8].start > n3) {
                n8 = Math.max(n7, n8 - 1);
            }
            nArray = new int[n8 - n7 + 1 << 1];
            int n9 = n7;
            int n10 = 0;
            while (n9 <= n8) {
                StyleRange styleRange = this.styles[n9];
                nArray[n10] = styleRange.start;
                nArray[n10 + 1] = styleRange.length;
                ++n9;
                n10 += 2;
            }
        }
        if (n > nArray[0]) {
            nArray[1] = nArray[0] + nArray[1] - n;
            nArray[0] = n;
        }
        if (n3 < nArray[nArray.length - 2] + nArray[nArray.length - 1] - 1) {
            nArray[nArray.length - 1] = n3 - nArray[nArray.length - 2] + 1;
        }
        return nArray;
    }

    StyleRange[] getStyleRanges(int n, int n2, boolean bl) {
        StyleRange[] styleRangeArray;
        int n3;
        if (n2 == 0) {
            return null;
        }
        int n4 = n + n2 - 1;
        if (this.ranges != null) {
            n3 = this.styleCount << 1;
            int n5 = this.getRangeIndex(n, -1, n3);
            if (n5 >= n3) {
                return null;
            }
            if (this.ranges[n5] > n4) {
                return null;
            }
            int n6 = Math.min(n3 - 2, this.getRangeIndex(n4, n5 - 1, n3));
            if (this.ranges[n6] > n4) {
                n6 = Math.max(n5, n6 - 2);
            }
            styleRangeArray = new StyleRange[(n6 - n5 >> 1) + 1];
            if (bl) {
                int n7 = n5;
                int n8 = 0;
                while (n7 <= n6) {
                    styleRangeArray[n8] = (StyleRange)this.styles[n7 >> 1].clone();
                    styleRangeArray[n8].start = this.ranges[n7];
                    styleRangeArray[n8].length = this.ranges[n7 + 1];
                    n7 += 2;
                    ++n8;
                }
            } else {
                System.arraycopy(this.styles, n5 >> 1, styleRangeArray, 0, styleRangeArray.length);
            }
        } else {
            n3 = this.getRangeIndex(n, -1, this.styleCount);
            if (n3 >= this.styleCount) {
                return null;
            }
            if (this.styles[n3].start > n4) {
                return null;
            }
            int n9 = Math.min(this.styleCount - 1, this.getRangeIndex(n4, n3 - 1, this.styleCount));
            if (this.styles[n9].start > n4) {
                n9 = Math.max(n3, n9 - 1);
            }
            styleRangeArray = new StyleRange[n9 - n3 + 1];
            System.arraycopy(this.styles, n3, styleRangeArray, 0, styleRangeArray.length);
        }
        if (bl || this.ranges == null) {
            StyleRange styleRange = styleRangeArray[0];
            if (n > styleRange.start) {
                styleRangeArray[0] = styleRange = (StyleRange)styleRange.clone();
                styleRange.length = styleRange.start + styleRange.length - n;
                styleRange.start = n;
            }
            styleRange = styleRangeArray[styleRangeArray.length - 1];
            if (n4 < styleRange.start + styleRange.length - 1) {
                styleRangeArray[styleRangeArray.length - 1] = styleRange = (StyleRange)styleRange.clone();
                styleRange.length = n4 - styleRange.start + 1;
            }
        }
        return styleRangeArray;
    }

    StyleRange getStyleRange(StyleRange styleRange) {
        if (styleRange.underline && styleRange.underlineStyle == 4) {
            this.hasLinks = true;
        }
        if (styleRange.start == 0 && styleRange.length == 0 && styleRange.fontStyle == 0) {
            return styleRange;
        }
        StyleRange styleRange2 = (StyleRange)styleRange.clone();
        styleRange2.length = 0;
        styleRange2.start = 0;
        styleRange2.fontStyle = 0;
        if (styleRange2.font == null) {
            styleRange2.font = this.getFont(styleRange.fontStyle);
        }
        return styleRange2;
    }

    TextLayout getTextLayout(int n) {
        return this.getTextLayout(n, this.styledText.getOrientation(), this.styledText.getWrapWidth(), this.styledText.lineSpacing);
    }

    TextLayout getTextLayout(int n, int n2, int n3, int n4) {
        int n5;
        IME iME;
        int n6;
        int n7;
        int n8;
        int n9;
        TextLayout textLayout = null;
        if (this.styledText != null) {
            int n10;
            int n11;
            int n12 = n11 = this.styledText.topIndex > 0 ? this.styledText.topIndex - 1 : 0;
            if (this.layouts == null || n11 != this.topIndex) {
                int n13;
                int n14;
                TextLayout[] textLayoutArray = new TextLayout[128];
                if (this.layouts != null) {
                    for (n14 = 0; n14 < this.layouts.length; ++n14) {
                        if (this.layouts[n14] == null) continue;
                        n13 = n14 + this.topIndex - n11;
                        if (0 <= n13 && n13 < textLayoutArray.length) {
                            textLayoutArray[n13] = this.layouts[n14];
                            continue;
                        }
                        this.layouts[n14].dispose();
                    }
                }
                if (this.bullets != null && this.bulletsIndices != null && n11 != this.topIndex) {
                    n14 = n11 - this.topIndex;
                    if (n14 > 0) {
                        if (n14 < this.bullets.length) {
                            System.arraycopy(this.bullets, n14, this.bullets, 0, this.bullets.length - n14);
                            System.arraycopy(this.bulletsIndices, n14, this.bulletsIndices, 0, this.bulletsIndices.length - n14);
                        }
                        for (n9 = n13 = Math.max(0, this.bullets.length - n14); n9 < this.bullets.length; ++n9) {
                            this.bullets[n9] = null;
                        }
                    } else {
                        if (-n14 < this.bullets.length) {
                            System.arraycopy(this.bullets, 0, this.bullets, -n14, this.bullets.length + n14);
                            System.arraycopy(this.bulletsIndices, 0, this.bulletsIndices, -n14, this.bulletsIndices.length + n14);
                        }
                        n13 = Math.min(this.bullets.length, -n14);
                        for (n9 = 0; n9 < n13; ++n9) {
                            this.bullets[n9] = null;
                        }
                    }
                }
                this.topIndex = n11;
                this.layouts = textLayoutArray;
            }
            if (this.layouts != null && 0 <= (n10 = n - n11) && n10 < this.layouts.length) {
                textLayout = this.layouts[n10];
                if (textLayout != null) {
                    if (this.lineWidth[n] != -1) {
                        return textLayout;
                    }
                } else {
                    textLayout = this.layouts[n10] = new TextLayout(this.device);
                }
            }
        }
        if (textLayout == null) {
            textLayout = new TextLayout(this.device);
        }
        String string = this.content.getLine(n);
        int n15 = this.content.getOffsetAtLine(n);
        int[] nArray = null;
        char[] cArray = null;
        n9 = 0;
        int n16 = 0;
        int n17 = 16384;
        int n18 = n2;
        boolean bl = false;
        int[] nArray2 = new int[]{this.tabWidth};
        Bullet bullet = null;
        int[] nArray3 = null;
        StyleRange[] styleRangeArray = null;
        int n19 = 0;
        int n20 = 0;
        StyledTextEvent styledTextEvent = null;
        if (this.styledText != null) {
            styledTextEvent = this.styledText.getBidiSegments(n15, string);
            if (styledTextEvent != null) {
                nArray = styledTextEvent.segments;
                cArray = styledTextEvent.segmentsChars;
            }
            styledTextEvent = this.styledText.getLineStyleData(n15, string);
            n9 = this.styledText.indent;
            n16 = this.styledText.wrapIndent;
            n17 = this.styledText.alignment;
            if (this.styledText.isAutoDirection()) {
                n18 = 0x6000000;
            } else if ((this.styledText.getStyle() & Integer.MIN_VALUE) != 0) {
                n18 = n2 == 0x4000000 ? 0x2000000 : 0x4000000;
            }
            bl = this.styledText.justify;
            if (this.styledText.tabs != null) {
                nArray2 = this.styledText.tabs;
            }
        }
        if (styledTextEvent != null) {
            int n21;
            n9 = styledTextEvent.indent;
            n16 = styledTextEvent.wrapIndent;
            n17 = styledTextEvent.alignment;
            bl = styledTextEvent.justify;
            bullet = styledTextEvent.bullet;
            nArray3 = styledTextEvent.ranges;
            styleRangeArray = styledTextEvent.styles;
            if (styledTextEvent.tabStops != null) {
                nArray2 = styledTextEvent.tabStops;
            }
            if (styleRangeArray != null) {
                n20 = styleRangeArray.length;
                if (this.styledText.isFixedLineHeight()) {
                    for (n21 = 0; n21 < n20; ++n21) {
                        if (!styleRangeArray[n21].isVariableHeight()) continue;
                        this.styledText.verticalScrollOffset = -1;
                        this.styledText.setVariableLineHeight();
                        this.styledText.redraw();
                        break;
                    }
                }
            }
            if (this.bullets == null || this.bulletsIndices == null) {
                this.bullets = new Bullet[128];
                this.bulletsIndices = new int[128];
            }
            if (0 <= (n21 = n - this.topIndex) && n21 < 128) {
                this.bullets[n21] = bullet;
                this.bulletsIndices[n21] = styledTextEvent.bulletIndex;
            }
        } else {
            LineInfo lineInfo;
            if (this.lines != null && (lineInfo = this.lines[n]) != null) {
                if ((lineInfo.flags & 4) != 0) {
                    n9 = lineInfo.indent;
                }
                if ((lineInfo.flags & 0x80) != 0) {
                    n16 = lineInfo.wrapIndent;
                }
                if ((lineInfo.flags & 2) != 0) {
                    n17 = lineInfo.alignment;
                }
                if ((lineInfo.flags & 8) != 0) {
                    bl = lineInfo.justify;
                }
                if ((lineInfo.flags & 0x20) != 0) {
                    nArray = lineInfo.segments;
                }
                if ((lineInfo.flags & 0x100) != 0) {
                    cArray = lineInfo.segmentsChars;
                }
                if ((lineInfo.flags & 0x40) != 0) {
                    nArray2 = lineInfo.tabStops;
                }
            }
            if (this.bulletsIndices != null) {
                this.bullets = null;
                this.bulletsIndices = null;
            }
            if (this.bullets != null) {
                for (int i = 0; i < this.bullets.length; ++i) {
                    if (this.bullets[i].indexOf(n) == -1) continue;
                    bullet = this.bullets[i];
                    break;
                }
            }
            nArray3 = this.ranges;
            styleRangeArray = this.styles;
            n20 = this.styleCount;
            n19 = nArray3 != null ? this.getRangeIndex(n15, -1, n20 << 1) : this.getRangeIndex(n15, -1, n20);
        }
        if (bullet != null) {
            StyleRange styleRange = bullet.style;
            GlyphMetrics glyphMetrics = styleRange.metrics;
            n9 += glyphMetrics.width;
        }
        textLayout.setFont(this.regularFont);
        textLayout.setAscent(this.ascent);
        textLayout.setDescent(this.descent);
        textLayout.setText(string);
        textLayout.setOrientation(n2);
        textLayout.setSegments(nArray);
        textLayout.setSegmentsChars(cArray);
        textLayout.setWidth(n3);
        textLayout.setSpacing(n4);
        textLayout.setTabs(nArray2);
        textLayout.setIndent(n9);
        textLayout.setWrapIndent(n16);
        textLayout.setAlignment(n17);
        textLayout.setJustify(bl);
        textLayout.setTextDirection(n18);
        int n22 = 0;
        int n23 = string.length();
        if (styleRangeArray != null) {
            int n24;
            if (nArray3 != null) {
                n24 = n20 << 1;
                for (n8 = n19; n8 < n24; n8 += 2) {
                    if (n15 > nArray3[n8]) {
                        n7 = 0;
                        n6 = Math.min(n23, nArray3[n8 + 1] - n15 + nArray3[n8]);
                    } else {
                        n7 = nArray3[n8] - n15;
                        n6 = Math.min(n23, n7 + nArray3[n8 + 1]);
                    }
                    if (n7 < n23) {
                        if (n22 < n7) {
                            textLayout.setStyle(null, n22, n7 - 1);
                        }
                        textLayout.setStyle(this.getStyleRange(styleRangeArray[n8 >> 1]), n7, n6);
                        n22 = Math.max(n22, n6);
                        continue;
                    }
                    break;
                }
            } else {
                for (n24 = n19; n24 < n20; ++n24) {
                    if (n15 > styleRangeArray[n24].start) {
                        n8 = 0;
                        n7 = Math.min(n23, styleRangeArray[n24].length - n15 + styleRangeArray[n24].start);
                    } else {
                        n8 = styleRangeArray[n24].start - n15;
                        n7 = Math.min(n23, n8 + styleRangeArray[n24].length);
                    }
                    if (n8 < n23) {
                        if (n22 < n8) {
                            textLayout.setStyle(null, n22, n8 - 1);
                        }
                        textLayout.setStyle(this.getStyleRange(styleRangeArray[n24]), n8, n7);
                        n22 = Math.max(n22, n7);
                        continue;
                    }
                    break;
                }
            }
        }
        if (n22 < n23) {
            textLayout.setStyle(null, n22, n23);
        }
        if (this.styledText != null && this.styledText.ime != null && (n8 = (iME = this.styledText.ime).getCompositionOffset()) != -1) {
            n7 = iME.getCommitCount();
            n6 = iME.getText().length();
            if (n6 != n7 && (n5 = this.content.getLineAtOffset(n8)) == n) {
                TextStyle textStyle;
                int n25;
                int n26;
                int[] nArray4 = iME.getRanges();
                TextStyle[] textStyleArray = iME.getStyles();
                if (nArray4.length > 0) {
                    for (n26 = 0; n26 < textStyleArray.length; ++n26) {
                        n25 = nArray4[n26 * 2] - n15;
                        int n27 = nArray4[n26 * 2 + 1] - n15;
                        textStyle = textStyleArray[n26];
                        for (int i = n25; i <= n27 && 0 <= i && i < n23; ++i) {
                            TextStyle textStyle2 = textLayout.getStyle(i);
                            if (textStyle2 == null && i > 0) {
                                textStyle2 = textLayout.getStyle(i - 1);
                            }
                            if (textStyle2 == null && i + 1 < n23) {
                                textStyle2 = textLayout.getStyle(i + 1);
                            }
                            if (textStyle2 == null) {
                                textLayout.setStyle(textStyle, i, i);
                                continue;
                            }
                            TextStyle textStyle3 = new TextStyle(textStyle);
                            if (textStyle3.font == null) {
                                textStyle3.font = textStyle2.font;
                            }
                            if (textStyle3.foreground == null) {
                                textStyle3.foreground = textStyle2.foreground;
                            }
                            if (textStyle3.background == null) {
                                textStyle3.background = textStyle2.background;
                            }
                            textLayout.setStyle(textStyle3, i, i);
                        }
                    }
                } else {
                    n26 = n8 - n15;
                    n25 = n26 + n6 - 1;
                    TextStyle textStyle4 = textLayout.getStyle(n26);
                    if (textStyle4 == null) {
                        if (n26 > 0) {
                            textStyle4 = textLayout.getStyle(n26 - 1);
                        }
                        if (textStyle4 == null && n25 + 1 < n23) {
                            textStyle4 = textLayout.getStyle(n25 + 1);
                        }
                        if (textStyle4 != null) {
                            textStyle = new TextStyle();
                            textStyle.font = textStyle4.font;
                            textStyle.foreground = textStyle4.foreground;
                            textStyle.background = textStyle4.background;
                            textLayout.setStyle(textStyle, n26, n25);
                        }
                    }
                }
            }
        }
        if (this.styledText != null && this.styledText.isFixedLineHeight()) {
            int n28 = -1;
            n8 = textLayout.getLineCount();
            n7 = this.getLineHeight();
            for (n6 = 0; n6 < n8; ++n6) {
                n5 = textLayout.getLineBounds((int)n6).height;
                if (n5 <= n7) continue;
                n7 = n5;
                n28 = n6;
            }
            if (n28 != -1) {
                FontMetrics fontMetrics = textLayout.getLineMetrics(n28);
                this.ascent = fontMetrics.getAscent() + fontMetrics.getLeading();
                this.descent = fontMetrics.getDescent();
                if (this.layouts != null) {
                    for (n5 = 0; n5 < this.layouts.length; ++n5) {
                        if (this.layouts[n5] == null || this.layouts[n5] == textLayout) continue;
                        this.layouts[n5].setAscent(this.ascent);
                        this.layouts[n5].setDescent(this.descent);
                    }
                }
                if (this.styledText.verticalScrollOffset != 0) {
                    n5 = this.styledText.topIndex;
                    int n29 = this.styledText.topIndexY;
                    int n30 = this.getLineHeight();
                    this.styledText.verticalScrollOffset = n29 >= 0 ? (n5 - 1) * n30 + n30 - n29 : n5 * n30 - n29;
                }
                this.styledText.calculateScrollBars();
                if (this.styledText.isBidiCaret()) {
                    this.styledText.createCaretBitmaps();
                }
                this.styledText.caretDirection = 0;
                this.styledText.setCaretLocation();
                this.styledText.redraw();
            }
        }
        return textLayout;
    }

    int getWidth() {
        return this.maxWidth;
    }

    void reset() {
        if (this.layouts != null) {
            for (int i = 0; i < this.layouts.length; ++i) {
                TextLayout textLayout = this.layouts[i];
                if (textLayout == null) continue;
                textLayout.dispose();
            }
            this.layouts = null;
        }
        this.topIndex = -1;
        this.lineCount = 0;
        this.styleCount = 0;
        this.stylesSetCount = 0;
        this.ranges = null;
        this.styles = null;
        this.stylesSet = null;
        this.lines = null;
        this.lineWidth = null;
        this.lineHeight = null;
        this.bullets = null;
        this.bulletsIndices = null;
        this.redrawLines = null;
        this.hasLinks = false;
    }

    void reset(int n, int n2) {
        int n3;
        int n4 = n + n2;
        if (n < 0 || n4 > this.lineWidth.length) {
            return;
        }
        for (n3 = n; n3 < n4; ++n3) {
            this.lineWidth[n3] = -1;
            this.lineHeight[n3] = -1;
        }
        if (n <= this.maxWidthLineIndex && this.maxWidthLineIndex < n4) {
            this.maxWidth = 0;
            this.maxWidthLineIndex = -1;
            if (n2 != this.lineCount) {
                for (n3 = 0; n3 < this.lineCount; ++n3) {
                    if (this.lineWidth[n3] <= this.maxWidth) continue;
                    this.maxWidth = this.lineWidth[n3];
                    this.maxWidthLineIndex = n3;
                }
            }
        }
    }

    void setContent(StyledTextContent styledTextContent) {
        this.reset();
        this.content = styledTextContent;
        this.lineCount = styledTextContent.getLineCount();
        this.lineWidth = new int[this.lineCount];
        this.lineHeight = new int[this.lineCount];
        this.maxWidth = 0;
        this.maxWidthLineIndex = -1;
        this.reset(0, this.lineCount);
    }

    void setFont(Font font, int n) {
        Object object;
        TextLayout textLayout = new TextLayout(this.device);
        textLayout.setFont(this.regularFont);
        if (font != null) {
            if (this.boldFont != null) {
                this.boldFont.dispose();
            }
            if (this.italicFont != null) {
                this.italicFont.dispose();
            }
            if (this.boldItalicFont != null) {
                this.boldItalicFont.dispose();
            }
            this.boldItalicFont = null;
            this.italicFont = null;
            this.boldFont = null;
            this.regularFont = font;
            textLayout.setText("    ");
            textLayout.setFont(font);
            textLayout.setStyle(new TextStyle(this.getFont(0), null, null), 0, 0);
            textLayout.setStyle(new TextStyle(this.getFont(1), null, null), 1, 1);
            textLayout.setStyle(new TextStyle(this.getFont(2), null, null), 2, 2);
            textLayout.setStyle(new TextStyle(this.getFont(3), null, null), 3, 3);
            object = textLayout.getLineMetrics(0);
            this.ascent = ((FontMetrics)object).getAscent() + ((FontMetrics)object).getLeading();
            this.descent = ((FontMetrics)object).getDescent();
            this.boldFont.dispose();
            this.italicFont.dispose();
            this.boldItalicFont.dispose();
            this.boldItalicFont = null;
            this.italicFont = null;
            this.boldFont = null;
        }
        textLayout.dispose();
        textLayout = new TextLayout(this.device);
        textLayout.setFont(this.regularFont);
        object = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            ((StringBuffer)object).append(' ');
        }
        textLayout.setText(((StringBuffer)object).toString());
        this.tabWidth = textLayout.getBounds().width;
        textLayout.dispose();
        if (this.styledText != null) {
            GC gC = new GC(this.styledText);
            this.averageCharWidth = gC.getFontMetrics().getAverageCharWidth();
            this.fixedPitch = gC.stringExtent((String)"l").x == gC.stringExtent((String)"W").x;
            gC.dispose();
        }
    }

    void setLineAlignment(int n, int n2, int n3) {
        if (this.lines == null) {
            this.lines = new LineInfo[this.lineCount];
        }
        for (int i = n; i < n + n2; ++i) {
            if (this.lines[i] == null) {
                this.lines[i] = new LineInfo();
            }
            this.lines[i].flags |= 2;
            this.lines[i].alignment = n3;
        }
    }

    void setLineBackground(int n, int n2, Color color) {
        if (this.lines == null) {
            this.lines = new LineInfo[this.lineCount];
        }
        for (int i = n; i < n + n2; ++i) {
            if (this.lines[i] == null) {
                this.lines[i] = new LineInfo();
            }
            this.lines[i].flags |= 1;
            this.lines[i].background = color;
        }
    }

    void setLineBullet(int n, int n2, Bullet bullet) {
        int n3;
        if (this.bulletsIndices != null) {
            this.bulletsIndices = null;
            this.bullets = null;
        }
        if (this.bullets == null) {
            if (bullet == null) {
                return;
            }
            this.bullets = new Bullet[1];
            this.bullets[0] = bullet;
        }
        for (n3 = 0; n3 < this.bullets.length && bullet != this.bullets[n3]; ++n3) {
        }
        if (bullet != null) {
            if (n3 == this.bullets.length) {
                Bullet[] bulletArray = new Bullet[this.bullets.length + 1];
                System.arraycopy(this.bullets, 0, bulletArray, 0, this.bullets.length);
                bulletArray[n3] = bullet;
                this.bullets = bulletArray;
            }
            bullet.addIndices(n, n2);
        } else {
            this.updateBullets(n, n2, 0, false);
            this.styledText.redrawLinesBullet(this.redrawLines);
            this.redrawLines = null;
        }
    }

    void setLineIndent(int n, int n2, int n3) {
        if (this.lines == null) {
            this.lines = new LineInfo[this.lineCount];
        }
        for (int i = n; i < n + n2; ++i) {
            if (this.lines[i] == null) {
                this.lines[i] = new LineInfo();
            }
            this.lines[i].flags |= 4;
            this.lines[i].indent = n3;
        }
    }

    void setLineWrapIndent(int n, int n2, int n3) {
        if (this.lines == null) {
            this.lines = new LineInfo[this.lineCount];
        }
        for (int i = n; i < n + n2; ++i) {
            if (this.lines[i] == null) {
                this.lines[i] = new LineInfo();
            }
            this.lines[i].flags |= 0x80;
            this.lines[i].wrapIndent = n3;
        }
    }

    void setLineJustify(int n, int n2, boolean bl) {
        if (this.lines == null) {
            this.lines = new LineInfo[this.lineCount];
        }
        for (int i = n; i < n + n2; ++i) {
            if (this.lines[i] == null) {
                this.lines[i] = new LineInfo();
            }
            this.lines[i].flags |= 8;
            this.lines[i].justify = bl;
        }
    }

    void setLineSegments(int n, int n2, int[] nArray) {
        if (this.lines == null) {
            this.lines = new LineInfo[this.lineCount];
        }
        for (int i = n; i < n + n2; ++i) {
            if (this.lines[i] == null) {
                this.lines[i] = new LineInfo();
            }
            this.lines[i].flags |= 0x20;
            this.lines[i].segments = nArray;
        }
    }

    void setLineSegmentChars(int n, int n2, char[] cArray) {
        if (this.lines == null) {
            this.lines = new LineInfo[this.lineCount];
        }
        for (int i = n; i < n + n2; ++i) {
            if (this.lines[i] == null) {
                this.lines[i] = new LineInfo();
            }
            this.lines[i].flags |= 0x100;
            this.lines[i].segmentsChars = cArray;
        }
    }

    void setLineTabStops(int n, int n2, int[] nArray) {
        if (this.lines == null) {
            this.lines = new LineInfo[this.lineCount];
        }
        for (int i = n; i < n + n2; ++i) {
            if (this.lines[i] == null) {
                this.lines[i] = new LineInfo();
            }
            this.lines[i].flags |= 0x40;
            this.lines[i].tabStops = nArray;
        }
    }

    void setStyleRanges(int[] nArray, StyleRange[] styleRangeArray) {
        int n;
        int n2;
        int n3;
        if (styleRangeArray == null) {
            this.styleCount = 0;
            this.stylesSetCount = 0;
            this.ranges = null;
            this.styles = null;
            this.stylesSet = null;
            this.hasLinks = false;
            return;
        }
        if (nArray == null) {
            nArray = new int[styleRangeArray.length << 1];
            StyleRange[] styleRangeArray2 = new StyleRange[styleRangeArray.length];
            if (this.stylesSet == null) {
                this.stylesSet = new StyleRange[4];
            }
            n3 = 0;
            for (n2 = 0; n2 < styleRangeArray.length; ++n2) {
                StyleRange styleRange = styleRangeArray[n2];
                nArray[n3++] = styleRange.start;
                nArray[n3++] = styleRange.length;
                for (n = 0; n < this.stylesSetCount && !this.stylesSet[n].similarTo(styleRange); ++n) {
                }
                if (n == this.stylesSetCount) {
                    if (this.stylesSetCount == this.stylesSet.length) {
                        StyleRange[] styleRangeArray3 = new StyleRange[this.stylesSetCount + 4];
                        System.arraycopy(this.stylesSet, 0, styleRangeArray3, 0, this.stylesSetCount);
                        this.stylesSet = styleRangeArray3;
                    }
                    this.stylesSet[this.stylesSetCount++] = styleRange;
                }
                styleRangeArray2[n2] = this.stylesSet[n];
            }
            styleRangeArray = styleRangeArray2;
        }
        if (this.styleCount == 0) {
            if (nArray != null) {
                this.ranges = new int[nArray.length];
                System.arraycopy(nArray, 0, this.ranges, 0, this.ranges.length);
            }
            this.styles = new StyleRange[styleRangeArray.length];
            System.arraycopy(styleRangeArray, 0, this.styles, 0, this.styles.length);
            this.styleCount = styleRangeArray.length;
            return;
        }
        if (nArray != null && this.ranges == null) {
            this.ranges = new int[this.styles.length << 1];
            n2 = 0;
            for (int i = 0; i < this.styleCount; ++i) {
                this.ranges[n2++] = this.styles[i].start;
                this.ranges[n2++] = this.styles[i].length;
            }
        }
        if (nArray == null && this.ranges != null) {
            nArray = new int[styleRangeArray.length << 1];
            n2 = 0;
            for (int i = 0; i < styleRangeArray.length; ++i) {
                nArray[n2++] = styleRangeArray[i].start;
                nArray[n2++] = styleRangeArray[i].length;
            }
        }
        if (this.ranges != null) {
            n2 = nArray[0];
            int n4 = this.styleCount << 1;
            n3 = this.getRangeIndex(n2, -1, n4);
            int n5 = n = n3 == n4 ? 1 : 0;
            if (n == 0) {
                int n6 = nArray[nArray.length - 2] + nArray[nArray.length - 1];
                int n7 = this.getRangeIndex(n6, n3 - 1, n4);
                int n8 = n = n3 == n7 && this.ranges[n3] >= n6 ? 1 : 0;
            }
            if (n != 0) {
                this.addMerge(nArray, styleRangeArray, nArray.length, n3, n3);
                return;
            }
            int n9 = n3;
            int[] nArray2 = new int[6];
            StyleRange[] styleRangeArray4 = new StyleRange[3];
            for (int i = 0; i < nArray.length; i += 2) {
                int n10 = nArray[i];
                int n11 = n10 + nArray[i + 1];
                if (n10 == n11) continue;
                int n12 = 0;
                int n13 = 0;
                while (n9 < n4) {
                    if (n10 >= this.ranges[n3] + this.ranges[n3 + 1]) {
                        n3 += 2;
                    }
                    if (this.ranges[n9] + this.ranges[n9 + 1] > n11) break;
                    n9 += 2;
                }
                if (this.ranges[n3] < n10 && n10 < this.ranges[n3] + this.ranges[n3 + 1]) {
                    styleRangeArray4[n13 >> 1] = this.styles[n3 >> 1];
                    nArray2[n13] = this.ranges[n3];
                    nArray2[n13 + 1] = n10 - this.ranges[n3];
                    n13 += 2;
                }
                styleRangeArray4[n13 >> 1] = styleRangeArray[i >> 1];
                nArray2[n13] = n10;
                nArray2[n13 + 1] = nArray[i + 1];
                n13 += 2;
                if (n9 < n4 && this.ranges[n9] < n11 && n11 < this.ranges[n9] + this.ranges[n9 + 1]) {
                    styleRangeArray4[n13 >> 1] = this.styles[n9 >> 1];
                    nArray2[n13] = n11;
                    nArray2[n13 + 1] = this.ranges[n9] + this.ranges[n9 + 1] - n11;
                    n13 += 2;
                    n12 = 2;
                }
                int n14 = this.addMerge(nArray2, styleRangeArray4, n13, n3, n9 + n12);
                n4 += n14;
                n3 = n9 += n14;
            }
        } else {
            boolean bl;
            int n15 = styleRangeArray[0].start;
            n2 = this.getRangeIndex(n15, -1, this.styleCount);
            boolean bl2 = bl = n2 == this.styleCount;
            if (!bl) {
                n = styleRangeArray[styleRangeArray.length - 1].start + styleRangeArray[styleRangeArray.length - 1].length;
                n3 = this.getRangeIndex(n, n2 - 1, this.styleCount);
                boolean bl3 = bl = n2 == n3 && this.styles[n2].start >= n;
            }
            if (bl) {
                this.addMerge(styleRangeArray, styleRangeArray.length, n2, n2);
                return;
            }
            n3 = n2;
            StyleRange[] styleRangeArray5 = new StyleRange[3];
            for (int i = 0; i < styleRangeArray.length; ++i) {
                StyleRange styleRange = styleRangeArray[i];
                int n16 = styleRange.start;
                int n17 = n16 + styleRange.length;
                if (n16 == n17) continue;
                int n18 = 0;
                int n19 = 0;
                while (n3 < this.styleCount) {
                    if (n16 >= this.styles[n2].start + this.styles[n2].length) {
                        ++n2;
                    }
                    if (this.styles[n3].start + this.styles[n3].length > n17) break;
                    ++n3;
                }
                StyleRange styleRange2 = this.styles[n2];
                if (styleRange2.start < n16 && n16 < styleRange2.start + styleRange2.length) {
                    int n20 = n19++;
                    StyleRange styleRange3 = (StyleRange)styleRange2.clone();
                    styleRangeArray5[n20] = styleRange3;
                    styleRange2 = styleRange3;
                    styleRange2.length = n16 - styleRange2.start;
                }
                styleRangeArray5[n19++] = styleRange;
                if (n3 < this.styleCount) {
                    styleRange2 = this.styles[n3];
                    if (styleRange2.start < n17 && n17 < styleRange2.start + styleRange2.length) {
                        int n21 = n19++;
                        StyleRange styleRange4 = (StyleRange)styleRange2.clone();
                        styleRangeArray5[n21] = styleRange4;
                        styleRange2 = styleRange4;
                        styleRange2.length += styleRange2.start - n17;
                        styleRange2.start = n17;
                        n18 = 1;
                    }
                }
                int n22 = this.addMerge(styleRangeArray5, n19, n2, n3 + n18);
                n2 = n3 += n22;
            }
        }
    }

    void textChanging(TextChangingEvent textChangingEvent) {
        int n = textChangingEvent.start;
        int n2 = textChangingEvent.newCharCount;
        int n3 = textChangingEvent.replaceCharCount;
        int n4 = textChangingEvent.newLineCount;
        int n5 = textChangingEvent.replaceLineCount;
        this.updateRanges(n, n3, n2);
        int n6 = this.content.getLineAtOffset(n);
        if (n3 == this.content.getCharCount()) {
            this.lines = null;
        }
        if (n5 == this.lineCount) {
            this.lineCount = n4;
            this.lineWidth = new int[this.lineCount];
            this.lineHeight = new int[this.lineCount];
            this.reset(0, this.lineCount);
        } else {
            int n7;
            int n8;
            Object[] objectArray;
            int n9 = n4 - n5;
            if (this.lineCount + n9 > this.lineWidth.length) {
                objectArray = new int[this.lineCount + n9 + 32];
                System.arraycopy(this.lineWidth, 0, objectArray, 0, this.lineCount);
                this.lineWidth = objectArray;
                int[] nArray = new int[this.lineCount + n9 + 32];
                System.arraycopy(this.lineHeight, 0, nArray, 0, this.lineCount);
                this.lineHeight = nArray;
            }
            if (this.lines != null && this.lineCount + n9 > this.lines.length) {
                objectArray = new LineInfo[this.lineCount + n9 + 32];
                System.arraycopy(this.lines, 0, objectArray, 0, this.lineCount);
                this.lines = (LineInfo[])objectArray;
            }
            int n10 = n6 + n5 + 1;
            int n11 = n6 + n4 + 1;
            System.arraycopy(this.lineWidth, n10, this.lineWidth, n11, this.lineCount - n10);
            System.arraycopy(this.lineHeight, n10, this.lineHeight, n11, this.lineCount - n10);
            for (n8 = n6; n8 < n11; ++n8) {
                this.lineHeight[n8] = -1;
                this.lineWidth[n8] = -1;
            }
            for (n8 = this.lineCount + n9; n8 < this.lineCount; ++n8) {
                this.lineHeight[n8] = -1;
                this.lineWidth[n8] = -1;
            }
            if (this.layouts != null) {
                int n12;
                n8 = n6 - this.topIndex;
                n7 = n8 + n5 + 1;
                for (n12 = n8; n12 < n7; ++n12) {
                    if (0 > n12 || n12 >= this.layouts.length) continue;
                    if (this.layouts[n12] != null) {
                        this.layouts[n12].dispose();
                    }
                    this.layouts[n12] = null;
                    if (this.bullets == null || this.bulletsIndices == null) continue;
                    this.bullets[n12] = null;
                }
                if (n9 > 0) {
                    for (n12 = this.layouts.length - 1; n12 >= n7; --n12) {
                        if (0 > n12 || n12 >= this.layouts.length) continue;
                        n11 = n12 + n9;
                        if (0 <= n11 && n11 < this.layouts.length) {
                            this.layouts[n11] = this.layouts[n12];
                            this.layouts[n12] = null;
                            if (this.bullets == null || this.bulletsIndices == null) continue;
                            this.bullets[n11] = this.bullets[n12];
                            this.bulletsIndices[n11] = this.bulletsIndices[n12];
                            this.bullets[n12] = null;
                            continue;
                        }
                        if (this.layouts[n12] != null) {
                            this.layouts[n12].dispose();
                        }
                        this.layouts[n12] = null;
                        if (this.bullets == null || this.bulletsIndices == null) continue;
                        this.bullets[n12] = null;
                    }
                } else if (n9 < 0) {
                    for (n12 = n7; n12 < this.layouts.length; ++n12) {
                        if (0 > n12 || n12 >= this.layouts.length) continue;
                        n11 = n12 + n9;
                        if (0 <= n11 && n11 < this.layouts.length) {
                            this.layouts[n11] = this.layouts[n12];
                            this.layouts[n12] = null;
                            if (this.bullets == null || this.bulletsIndices == null) continue;
                            this.bullets[n11] = this.bullets[n12];
                            this.bulletsIndices[n11] = this.bulletsIndices[n12];
                            this.bullets[n12] = null;
                            continue;
                        }
                        if (this.layouts[n12] != null) {
                            this.layouts[n12].dispose();
                        }
                        this.layouts[n12] = null;
                        if (this.bullets == null || this.bulletsIndices == null) continue;
                        this.bullets[n12] = null;
                    }
                }
            }
            if (n5 != 0 || n4 != 0) {
                n8 = this.content.getOffsetAtLine(n6);
                if (n8 != n) {
                    ++n6;
                }
                this.updateBullets(n6, n5, n4, true);
                if (this.lines != null) {
                    n10 = n6 + n5;
                    n11 = n6 + n4;
                    System.arraycopy(this.lines, n10, this.lines, n11, this.lineCount - n10);
                    for (n7 = n6; n7 < n11; ++n7) {
                        this.lines[n7] = null;
                    }
                    for (n7 = this.lineCount + n9; n7 < this.lineCount; ++n7) {
                        this.lines[n7] = null;
                    }
                }
            }
            this.lineCount += n9;
            if (this.maxWidthLineIndex != -1 && n6 <= this.maxWidthLineIndex && this.maxWidthLineIndex <= n6 + n5) {
                this.maxWidth = 0;
                this.maxWidthLineIndex = -1;
                for (n8 = 0; n8 < this.lineCount; ++n8) {
                    if (this.lineWidth[n8] <= this.maxWidth) continue;
                    this.maxWidth = this.lineWidth[n8];
                    this.maxWidthLineIndex = n8;
                }
            }
        }
    }

    void updateBullets(int n, int n2, int n3, boolean bl) {
        int n4;
        if (this.bullets == null) {
            return;
        }
        if (this.bulletsIndices != null) {
            return;
        }
        for (n4 = 0; n4 < this.bullets.length; ++n4) {
            Bullet bullet = this.bullets[n4];
            int[] nArray = bullet.removeIndices(n, n2, n3, bl);
            if (nArray == null) continue;
            if (this.redrawLines == null) {
                this.redrawLines = nArray;
                continue;
            }
            int[] nArray2 = new int[this.redrawLines.length + nArray.length];
            System.arraycopy(this.redrawLines, 0, nArray2, 0, this.redrawLines.length);
            System.arraycopy(nArray, 0, nArray2, this.redrawLines.length, nArray.length);
            this.redrawLines = nArray2;
        }
        n4 = 0;
        for (int i = 0; i < this.bullets.length; ++i) {
            if (this.bullets[i].size() != 0) continue;
            ++n4;
        }
        if (n4 > 0) {
            if (n4 == this.bullets.length) {
                this.bullets = null;
            } else {
                Bullet[] bulletArray = new Bullet[this.bullets.length - n4];
                int n5 = 0;
                for (int i = 0; i < this.bullets.length; ++i) {
                    Bullet bullet = this.bullets[i];
                    if (bullet.size() <= 0) continue;
                    bulletArray[n5++] = bullet;
                }
                this.bullets = bulletArray;
            }
        }
    }

    void updateRanges(int n, int n2, int n3) {
        if (this.styleCount == 0 || n2 == 0 && n3 == 0) {
            return;
        }
        if (this.ranges != null) {
            int n4 = this.styleCount << 1;
            int n5 = this.getRangeIndex(n, -1, n4);
            if (n5 == n4) {
                return;
            }
            int n6 = n + n2;
            int n7 = this.getRangeIndex(n6, n5 - 1, n4);
            int n8 = n3 - n2;
            if (n5 == n7 && this.ranges[n5] < n && n6 < this.ranges[n7] + this.ranges[n7 + 1]) {
                if (n3 == 0) {
                    int n9 = n5 + 1;
                    this.ranges[n9] = this.ranges[n9] - n2;
                    n7 += 2;
                } else {
                    if (n4 + 2 > this.ranges.length) {
                        int[] nArray = new int[this.ranges.length + 64];
                        System.arraycopy(this.ranges, 0, nArray, 0, n4);
                        this.ranges = nArray;
                        StyleRange[] styleRangeArray = new StyleRange[this.styles.length + 32];
                        System.arraycopy(this.styles, 0, styleRangeArray, 0, this.styleCount);
                        this.styles = styleRangeArray;
                    }
                    System.arraycopy(this.ranges, n5 + 2, this.ranges, n5 + 4, n4 - (n5 + 2));
                    System.arraycopy(this.styles, n5 + 2 >> 1, this.styles, n5 + 4 >> 1, this.styleCount - (n5 + 2 >> 1));
                    this.ranges[n5 + 3] = this.ranges[n5] + this.ranges[n5 + 1] - n6;
                    this.ranges[n5 + 2] = n + n3;
                    this.ranges[n5 + 1] = n - this.ranges[n5];
                    this.styles[(n5 >> 1) + 1] = this.styles[n5 >> 1];
                    n4 += 2;
                    ++this.styleCount;
                    n7 += 4;
                }
                if (n8 != 0) {
                    for (int i = n7; i < n4; i += 2) {
                        int n10 = i;
                        this.ranges[n10] = this.ranges[n10] + n8;
                    }
                }
            } else {
                if (this.ranges[n5] < n && n < this.ranges[n5] + this.ranges[n5 + 1]) {
                    this.ranges[n5 + 1] = n - this.ranges[n5];
                    n5 += 2;
                }
                if (n7 < n4 && this.ranges[n7] < n6 && n6 < this.ranges[n7] + this.ranges[n7 + 1]) {
                    this.ranges[n7 + 1] = this.ranges[n7] + this.ranges[n7 + 1] - n6;
                    this.ranges[n7] = n6;
                }
                if (n8 != 0) {
                    for (int i = n7; i < n4; i += 2) {
                        int n11 = i;
                        this.ranges[n11] = this.ranges[n11] + n8;
                    }
                }
                System.arraycopy(this.ranges, n7, this.ranges, n5, n4 - n7);
                System.arraycopy(this.styles, n7 >> 1, this.styles, n5 >> 1, this.styleCount - (n7 >> 1));
                this.styleCount -= n7 - n5 >> 1;
            }
        } else {
            int n12 = this.getRangeIndex(n, -1, this.styleCount);
            if (n12 == this.styleCount) {
                return;
            }
            int n13 = n + n2;
            int n14 = this.getRangeIndex(n13, n12 - 1, this.styleCount);
            int n15 = n3 - n2;
            if (n12 == n14 && this.styles[n12].start < n && n13 < this.styles[n14].start + this.styles[n14].length) {
                if (n3 == 0) {
                    this.styles[n12].length -= n2;
                    ++n14;
                } else {
                    if (this.styleCount + 1 > this.styles.length) {
                        StyleRange[] styleRangeArray = new StyleRange[this.styles.length + 32];
                        System.arraycopy(this.styles, 0, styleRangeArray, 0, this.styleCount);
                        this.styles = styleRangeArray;
                    }
                    System.arraycopy(this.styles, n12 + 1, this.styles, n12 + 2, this.styleCount - (n12 + 1));
                    this.styles[n12 + 1] = (StyleRange)this.styles[n12].clone();
                    this.styles[n12 + 1].length = this.styles[n12].start + this.styles[n12].length - n13;
                    this.styles[n12 + 1].start = n + n3;
                    this.styles[n12].length = n - this.styles[n12].start;
                    ++this.styleCount;
                    n14 += 2;
                }
                if (n15 != 0) {
                    for (int i = n14; i < this.styleCount; ++i) {
                        this.styles[i].start += n15;
                    }
                }
            } else {
                if (this.styles[n12].start < n && n < this.styles[n12].start + this.styles[n12].length) {
                    this.styles[n12].length = n - this.styles[n12].start;
                    ++n12;
                }
                if (n14 < this.styleCount && this.styles[n14].start < n13 && n13 < this.styles[n14].start + this.styles[n14].length) {
                    this.styles[n14].length = this.styles[n14].start + this.styles[n14].length - n13;
                    this.styles[n14].start = n13;
                }
                if (n15 != 0) {
                    for (int i = n14; i < this.styleCount; ++i) {
                        this.styles[i].start += n15;
                    }
                }
                System.arraycopy(this.styles, n14, this.styles, n12, this.styleCount - n14);
                this.styleCount -= n14 - n12;
            }
        }
    }

    static class LineInfo {
        int flags;
        Color background;
        int alignment;
        int indent;
        int wrapIndent;
        boolean justify;
        int[] segments;
        char[] segmentsChars;
        int[] tabStops;

        public LineInfo() {
        }

        public LineInfo(LineInfo lineInfo) {
            if (lineInfo != null) {
                this.flags = lineInfo.flags;
                this.background = lineInfo.background;
                this.alignment = lineInfo.alignment;
                this.indent = lineInfo.indent;
                this.wrapIndent = lineInfo.wrapIndent;
                this.justify = lineInfo.justify;
                this.segments = lineInfo.segments;
                this.segmentsChars = lineInfo.segmentsChars;
                this.tabStops = lineInfo.tabStops;
            }
        }
    }
}

