/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.core.service.proxy;

import com.btr.proxy.search.ProxySearch;
import com.parablu.epa.core.element.ProxyElement;
import com.parablu.epa.core.helper.PropertyHelper;
import com.parablu.epa.helper.utils.RegistryUtils;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.impl.client.DefaultHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyDetector {
    private static Logger logger = LoggerFactory.getLogger(ProxyDetector.class);

    public static boolean detectProxy() {
        boolean result = false;
        ProxyElement.setProxyHost(null);
        ProxyElement.setProxyPort(0);
        try {
            ProxySearch ps = ProxySearch.getDefaultProxySearch();
            ps.setPacCacheSettings(32, 300000L);
            if (ps.getProxySelector() == null) {
                logger.debug("Proxy type: no proxy");
                return result;
            }
            List<Proxy> l = ps.getProxySelector().select(new URI("https://" + ProxyElement.getIp()));
            for (Proxy proxy : l) {
                logger.debug("proxy type :: " + proxy.type());
                InetSocketAddress addr = (InetSocketAddress)proxy.address();
                if (addr == null) {
                    result = false;
                    logger.debug("No Proxy...");
                    continue;
                }
                result = true;
                ProxyElement.setProxyHost(addr.getHostName());
                logger.debug("proxy hostname : " + addr.getHostName());
                ProxyElement.setProxyPort(addr.getPort());
                logger.debug("proxy port :: " + addr.getPort());
                break;
            }
        }
        catch (Exception e) {
            logger.error("Error to get proxy details.....");
            e.printStackTrace();
        }
        return result;
    }

    public static void setProxyDetails(DefaultHttpClient httpclient) {
        try {
            boolean isProxyDetected;
            boolean proxyEnabled = false;
            proxyEnabled = ProxyDetector.isproxyEnabled();
            logger.debug("proxy Enabled ...." + proxyEnabled);
            if (proxyEnabled && (isProxyDetected = ProxyDetector.detectProxy())) {
                String proxyHost = ProxyElement.getProxyHost();
                int proxyPort = ProxyElement.getProxyPort();
                logger.debug(" proxy host " + proxyHost + " proxy port " + proxyPort);
                if (StringUtils.isNotEmpty((String)proxyHost) && proxyPort != 0) {
                    HttpHost proxy = new HttpHost(proxyHost, proxyPort);
                    httpclient.getParams().setParameter("http.route.default-proxy", (Object)proxy);
                }
            }
        }
        catch (Exception e) {
            logger.error("exception....." + e.getMessage());
        }
    }

    protected static boolean isproxyEnabled() {
        boolean proxyEnabled = false;
        try {
            String os = ProxyDetector.getOSName();
            if (os.toLowerCase().contains("win")) {
                String platformNo = ProxyDetector.getOsType();
                String hKeyType = "HKLM";
                String key = "ProxyEnabled";
                String regKeyPath = platformNo.equalsIgnoreCase("64bit") ? "SOFTWARE\\WOW6432Node\\ParaBlu" : "SOFTWARE\\ParaBlu";
                String proxyEnabledString = RegistryUtils.getRegistryValue((String)hKeyType, (String)regKeyPath, (String)key);
                logger.debug("before get ....");
                if (StringUtils.isNotEmpty((String)proxyEnabledString)) {
                    logger.debug("before get ...." + proxyEnabledString);
                    proxyEnabled = Boolean.parseBoolean(proxyEnabledString);
                }
            } else {
                String proxyEnabledString = PropertyHelper.getMessageResourceString("Proxy-Enabled");
                logger.debug("before get  in mac os...." + proxyEnabledString);
                if (StringUtils.isNotBlank((String)proxyEnabledString) && proxyEnabledString.equalsIgnoreCase("true")) {
                    proxyEnabled = true;
                }
            }
        }
        catch (Exception e) {
            logger.debug("error to get proxy enabled.." + e.getMessage());
        }
        return proxyEnabled;
    }

    public static String getOsType() {
        String platformNo = null;
        try {
            String arch = System.getenv("PROCESSOR_ARCHITECTURE");
            String wow64Arch = System.getenv("PROCESSOR_ARCHITEW6432");
            String realArch = arch.endsWith("64") || wow64Arch != null && wow64Arch.endsWith("64") ? "64" : "32";
            logger.debug("arch" + arch + "wow64Arch" + wow64Arch + "os architecture...:" + realArch);
            platformNo = StringUtils.isNotEmpty((String)realArch) && !realArch.contains("64") ? "32bit" : "64bit";
            return platformNo;
        }
        catch (Exception e) {
            logger.error("Error to get Os type" + e.getMessage());
            return platformNo;
        }
    }

    private static String getOSName() {
        String osType = System.getProperty("os.name");
        logger.debug("ostype.." + osType);
        if (osType.toLowerCase().contains("win")) {
            return "win";
        }
        if (osType.toLowerCase().contains("mac")) {
            return "mac";
        }
        return osType;
    }
}

