/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import java.util.Vector;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DERConstructedSet;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.RecipientInfo;

public class RecipientInfos
implements DEREncodable {
    private DERConstructedSet infos;

    public RecipientInfos(Vector vector) {
        this.setInfos(vector);
    }

    public RecipientInfos(DERConstructedSet dERConstructedSet) {
        this.infos = dERConstructedSet;
    }

    public RecipientInfos(RecipientInfos recipientInfos) {
        this.infos = recipientInfos.infos;
    }

    public static RecipientInfos getInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof RecipientInfos) {
            return (RecipientInfos)object;
        }
        if (object instanceof DERConstructedSet) {
            return new RecipientInfos((DERConstructedSet)object);
        }
        if (object instanceof BERTaggedObject) {
            return RecipientInfos.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid RecipientInfos");
    }

    public static RecipientInfos newInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof RecipientInfos) {
            return new RecipientInfos((RecipientInfos)object);
        }
        if (object instanceof DERConstructedSet) {
            return new RecipientInfos((DERConstructedSet)object);
        }
        if (object instanceof BERTaggedObject) {
            return RecipientInfos.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid RecipientInfos");
    }

    public Vector getInfos() {
        int n = this.infos.getSize();
        Vector<RecipientInfo> vector = new Vector<RecipientInfo>();
        int n2 = 0;
        while (n2 < n) {
            vector.addElement(RecipientInfo.getInstance(this.infos.getObjectAt(n2)));
            ++n2;
        }
        return vector;
    }

    private void setInfos(Vector vector) {
        int n = vector.size();
        this.infos = new DERConstructedSet();
        int n2 = 0;
        while (n2 < n) {
            this.infos.addObject(RecipientInfo.getInstance(vector.elementAt(n2)));
            ++n2;
        }
    }

    public DERObject getDERObject() {
        return this.infos;
    }
}

