/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.RecipientKeyIdentifier;

public class KeyAgreeRecipientIdentifier
implements DEREncodable {
    private DEREncodable id;

    public KeyAgreeRecipientIdentifier(IssuerAndSerialNumber issuerAndSerialNumber) {
        this.setId(issuerAndSerialNumber);
    }

    public KeyAgreeRecipientIdentifier(RecipientKeyIdentifier recipientKeyIdentifier) {
        this.setId(recipientKeyIdentifier);
    }

    public KeyAgreeRecipientIdentifier(DEREncodable dEREncodable) {
        this.id = dEREncodable instanceof BERTaggedObject ? RecipientKeyIdentifier.getInstance(((BERTaggedObject)dEREncodable).getObject()) : IssuerAndSerialNumber.getInstance(dEREncodable);
    }

    public KeyAgreeRecipientIdentifier(KeyAgreeRecipientIdentifier keyAgreeRecipientIdentifier) {
        this.id = keyAgreeRecipientIdentifier.id;
    }

    public static KeyAgreeRecipientIdentifier getInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof KeyAgreeRecipientIdentifier) {
            return (KeyAgreeRecipientIdentifier)object;
        }
        if (object instanceof DEREncodable) {
            return new KeyAgreeRecipientIdentifier((DEREncodable)object);
        }
        if (object instanceof BERTaggedObject) {
            return KeyAgreeRecipientIdentifier.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid KeyAgreeRecipientIdentifier");
    }

    public static KeyAgreeRecipientIdentifier newInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof KeyAgreeRecipientIdentifier) {
            return new KeyAgreeRecipientIdentifier((KeyAgreeRecipientIdentifier)object);
        }
        if (object instanceof DEREncodable) {
            return new KeyAgreeRecipientIdentifier((DEREncodable)object);
        }
        if (object instanceof BERTaggedObject) {
            return KeyAgreeRecipientIdentifier.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid KeyAgreeRecipientIdentifier");
    }

    public DEREncodable getId() {
        return this.id;
    }

    private void setId(IssuerAndSerialNumber issuerAndSerialNumber) {
        this.id = issuerAndSerialNumber;
    }

    private void setId(RecipientKeyIdentifier recipientKeyIdentifier) {
        this.id = recipientKeyIdentifier;
    }

    public DERObject getDERObject() {
        if (this.id instanceof IssuerAndSerialNumber) {
            return this.id.getDERObject();
        }
        return new BERTaggedObject(false, 0, this.id.getDERObject());
    }
}

