/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.BERConstructedSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.ExtendedCertificate;
import org.bouncycastle.asn1.x509.X509CertificateStructure;

public class CertificateChoices
implements DEREncodable {
    private DEREncodable cert;

    public CertificateChoices(X509CertificateStructure x509CertificateStructure) {
        this.setCertificate(x509CertificateStructure);
    }

    public CertificateChoices(ExtendedCertificate extendedCertificate) {
        this.setCertificate(extendedCertificate);
    }

    public CertificateChoices(DEREncodable dEREncodable) {
        block9: {
            block8: {
                if (!(dEREncodable instanceof BERTaggedObject)) break block8;
                BERTaggedObject bERTaggedObject = (BERTaggedObject)dEREncodable;
                switch (bERTaggedObject.getTagNo()) {
                    case 0: {
                        this.cert = ExtendedCertificate.getInstance(bERTaggedObject);
                        break block9;
                    }
                    case 1: {
                        throw new IllegalArgumentException("AttributeCertificate not supported");
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid CertificateChoices");
                    }
                }
            }
            if (dEREncodable instanceof X509CertificateStructure) {
                this.cert = dEREncodable;
            } else if (dEREncodable instanceof BERConstructedSequence) {
                this.cert = new X509CertificateStructure((BERConstructedSequence)dEREncodable);
            } else {
                throw new IllegalArgumentException("Invalid CertificateChoices");
            }
        }
    }

    public CertificateChoices(CertificateChoices certificateChoices) {
        this.cert = certificateChoices.cert;
    }

    public static CertificateChoices getInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof CertificateChoices) {
            return (CertificateChoices)object;
        }
        if (object instanceof DEREncodable) {
            return new CertificateChoices((DEREncodable)object);
        }
        if (object instanceof BERTaggedObject) {
            return CertificateChoices.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid CertificateChoices");
    }

    public static CertificateChoices newInstance(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof CertificateChoices) {
            return new CertificateChoices((CertificateChoices)object);
        }
        if (object instanceof DEREncodable) {
            return new CertificateChoices((DEREncodable)object);
        }
        if (object instanceof BERTaggedObject) {
            return CertificateChoices.getInstance(((BERTaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("Invalid CertificateChoices");
    }

    public DEREncodable getCertificate() {
        return this.cert;
    }

    private void setCertificate(X509CertificateStructure x509CertificateStructure) {
        this.cert = x509CertificateStructure;
    }

    private void setCertificate(ExtendedCertificate extendedCertificate) {
        this.cert = extendedCertificate;
    }

    public DERObject getDERObject() {
        if (this.cert instanceof ExtendedCertificate) {
            return new BERTaggedObject(false, 0, this.cert.getDERObject());
        }
        return this.cert.getDERObject();
    }
}

