/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.core.helper;

import com.parablu.epa.core.to.BackupTO;
import com.parablu.epa.core.to.FileTO;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class FileSizeBlockingQueue<T extends BackupTO> {
    private ArrayBlockingQueue<T> queue;
    private long fileSizeLimit;
    private AtomicLong currentSize = new AtomicLong();
    private final ReentrantLock lock;
    private Condition isFull;
    private Condition isEmpty;

    public FileSizeBlockingQueue(int noOfFiles, long limit) {
        this.queue = new ArrayBlockingQueue(noOfFiles);
        this.fileSizeLimit = limit;
        this.currentSize.set(0L);
        this.lock = new ReentrantLock(false);
        this.isFull = this.lock.newCondition();
        this.isEmpty = this.lock.newCondition();
    }

    public Long getCurrentSize() {
        return this.currentSize.get();
    }

    public T peek() {
        return (T)((BackupTO)this.queue.peek());
    }

    public T poll() {
        return (T)((BackupTO)this.queue.poll());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T poll(long time, TimeUnit t) throws InterruptedException {
        ReentrantLock lockPoll = this.lock;
        BackupTO fileTO = null;
        lockPoll.lockInterruptibly();
        try {
            fileTO = (BackupTO)this.queue.poll(time, t);
            if (fileTO != null) {
                long current;
                while (!this.currentSize.compareAndSet(current = this.currentSize.get(), current - fileTO.getFileSize())) {
                }
                this.isFull.signalAll();
            }
        }
        finally {
            lockPoll.unlock();
        }
        return (T)fileTO;
    }

    public void put(T e) throws InterruptedException {
        ReentrantLock lockPut = this.lock;
        lockPut.lockInterruptibly();
        try {
            while (((FileTO)e).getFileSize() + this.currentSize.get() >= this.fileSizeLimit && !this.queue.isEmpty()) {
                this.isFull.await();
            }
            this.currentSize.getAndAdd(((FileTO)e).getFileSize());
            this.queue.put(e);
            this.isEmpty.signalAll();
        }
        finally {
            lockPut.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T take() throws InterruptedException {
        ReentrantLock lockTake = this.lock;
        lockTake.lockInterruptibly();
        while (this.queue.isEmpty()) {
            this.isEmpty.await();
        }
        BackupTO fileTO = (BackupTO)this.queue.take();
        try {
            long current;
            while (!this.currentSize.compareAndSet(current = this.currentSize.get(), current - fileTO.getFileSize())) {
            }
            this.isFull.signalAll();
            BackupTO backupTO = fileTO;
            return (T)backupTO;
        }
        finally {
            lockTake.unlock();
        }
    }

    public int size() {
        return this.queue.size();
    }
}

