/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DNDEvent;
import org.eclipse.swt.dnd.DNDListener;
import org.eclipse.swt.dnd.DropTargetEffect;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TableDropTargetEffect;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.dnd.TreeDropTargetEffect;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.COMObject;
import org.eclipse.swt.internal.ole.win32.FORMATETC;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IDataObject;
import org.eclipse.swt.internal.ole.win32.IEnumFORMATETC;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class DropTarget
extends Widget {
    Control control;
    Listener controlListener;
    Transfer[] transferAgents = new Transfer[0];
    DropTargetEffect dropEffect;
    TransferData selectedDataType;
    int selectedOperation;
    int keyOperation = -1;
    IDataObject iDataObject;
    COMObject iDropTarget;
    int refCount;
    static final String DEFAULT_DROP_TARGET_EFFECT = "DEFAULT_DROP_TARGET_EFFECT";

    public DropTarget(Control control, int n) {
        super(control, DropTarget.checkStyle(n));
        this.control = control;
        if (control.getData("DropTarget") != null) {
            DND.error(2001);
        }
        control.setData("DropTarget", this);
        this.createCOMInterfaces();
        this.AddRef();
        if (COM.CoLockObjectExternal(this.iDropTarget.getAddress(), true, true) != 0) {
            DND.error(2001);
        }
        if (COM.RegisterDragDrop(control.handle, this.iDropTarget.getAddress()) != 0) {
            DND.error(2001);
        }
        this.controlListener = new Listener(){

            @Override
            public void handleEvent(Event event) {
                if (!DropTarget.this.isDisposed()) {
                    DropTarget.this.dispose();
                }
            }
        };
        control.addListener(12, this.controlListener);
        this.addListener(12, new Listener(){

            @Override
            public void handleEvent(Event event) {
                DropTarget.this.onDispose();
            }
        });
        Object object = control.getData(DEFAULT_DROP_TARGET_EFFECT);
        if (object instanceof DropTargetEffect) {
            this.dropEffect = (DropTargetEffect)object;
        } else if (control instanceof Table) {
            this.dropEffect = new TableDropTargetEffect((Table)control);
        } else if (control instanceof Tree) {
            this.dropEffect = new TreeDropTargetEffect((Tree)control);
        }
    }

    static int checkStyle(int n) {
        if (n == 0) {
            return 2;
        }
        return n;
    }

    public void addDropListener(DropTargetListener dropTargetListener) {
        if (dropTargetListener == null) {
            DND.error(4);
        }
        DNDListener dNDListener = new DNDListener(dropTargetListener);
        dNDListener.dndWidget = this;
        this.addListener(2002, dNDListener);
        this.addListener(2003, dNDListener);
        this.addListener(2004, dNDListener);
        this.addListener(2005, dNDListener);
        this.addListener(2006, dNDListener);
        this.addListener(2007, dNDListener);
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    @Override
    protected void checkSubclass() {
        String string = this.getClass().getName();
        String string2 = DropTarget.class.getName();
        if (!string2.equals(string)) {
            DND.error(43);
        }
    }

    void createCOMInterfaces() {
        boolean bl = C.PTR_SIZEOF == 4;
        this.iDropTarget = new COMObject(new int[]{2, 0, 0, bl ? 5 : 4, bl ? 4 : 3, 0, bl ? 5 : 4}){

            @Override
            public int method0(int[] nArray) {
                return DropTarget.this.QueryInterface(nArray[0], nArray[1]);
            }

            @Override
            public int method1(int[] nArray) {
                return DropTarget.this.AddRef();
            }

            @Override
            public int method2(int[] nArray) {
                return DropTarget.this.Release();
            }

            @Override
            public int method3(int[] nArray) {
                if (nArray.length == 5) {
                    return DropTarget.this.DragEnter(nArray[0], nArray[1], nArray[2], nArray[3], nArray[4]);
                }
                return DropTarget.this.DragEnter_64(nArray[0], nArray[1], nArray[2], nArray[3]);
            }

            @Override
            public int method4(int[] nArray) {
                if (nArray.length == 4) {
                    return DropTarget.this.DragOver(nArray[0], nArray[1], nArray[2], nArray[3]);
                }
                return DropTarget.this.DragOver_64(nArray[0], nArray[1], nArray[2]);
            }

            @Override
            public int method5(int[] nArray) {
                return DropTarget.this.DragLeave();
            }

            @Override
            public int method6(int[] nArray) {
                if (nArray.length == 5) {
                    return DropTarget.this.Drop(nArray[0], nArray[1], nArray[2], nArray[3], nArray[4]);
                }
                return DropTarget.this.Drop_64(nArray[0], nArray[1], nArray[2], nArray[3]);
            }
        };
    }

    void disposeCOMInterfaces() {
        if (this.iDropTarget != null) {
            this.iDropTarget.dispose();
        }
        this.iDropTarget = null;
    }

    int DragEnter_64(int n, int n2, long l, int n3) {
        POINT pOINT = new POINT();
        OS.MoveMemory(pOINT, new long[]{l}, 8);
        return this.DragEnter(n, n2, pOINT.x, pOINT.y, n3);
    }

    int DragEnter(int n, int n2, int n3, int n4, int n5) {
        n3 = DPIUtil.autoScaleDown(n3);
        n4 = DPIUtil.autoScaleDown(n4);
        this.selectedDataType = null;
        this.selectedOperation = 0;
        if (this.iDataObject != null) {
            this.iDataObject.Release();
        }
        this.iDataObject = null;
        DNDEvent dNDEvent = new DNDEvent();
        if (!this.setEventData(dNDEvent, n, n2, n3, n4, n5)) {
            OS.MoveMemory(n5, new int[]{0}, 4);
            return 1;
        }
        this.iDataObject = new IDataObject(n);
        this.iDataObject.AddRef();
        int n6 = dNDEvent.operations;
        TransferData[] transferDataArray = new TransferData[dNDEvent.dataTypes.length];
        System.arraycopy(dNDEvent.dataTypes, 0, transferDataArray, 0, transferDataArray.length);
        this.notifyListeners(2002, dNDEvent);
        this.refresh();
        if (dNDEvent.detail == 16) {
            dNDEvent.detail = (n6 & 2) != 0 ? 2 : 0;
        }
        this.selectedDataType = null;
        for (int i = 0; i < transferDataArray.length; ++i) {
            if (!TransferData.sameType(transferDataArray[i], dNDEvent.dataType)) continue;
            this.selectedDataType = transferDataArray[i];
            break;
        }
        this.selectedOperation = 0;
        if (this.selectedDataType != null && (n6 & dNDEvent.detail) != 0) {
            this.selectedOperation = dNDEvent.detail;
        }
        OS.MoveMemory(n5, new int[]{this.opToOs(this.selectedOperation)}, 4);
        return 0;
    }

    int DragLeave() {
        this.keyOperation = -1;
        if (this.iDataObject == null) {
            return 1;
        }
        DNDEvent dNDEvent = new DNDEvent();
        dNDEvent.widget = this;
        dNDEvent.time = OS.GetMessageTime();
        dNDEvent.detail = 0;
        this.notifyListeners(2003, dNDEvent);
        this.refresh();
        this.iDataObject.Release();
        this.iDataObject = null;
        return 0;
    }

    int DragOver_64(int n, long l, int n2) {
        POINT pOINT = new POINT();
        OS.MoveMemory(pOINT, new long[]{l}, 8);
        return this.DragOver(n, pOINT.x, pOINT.y, n2);
    }

    int DragOver(int n, int n2, int n3, int n4) {
        n2 = DPIUtil.autoScaleDown(n2);
        n3 = DPIUtil.autoScaleDown(n3);
        if (this.iDataObject == null) {
            return 1;
        }
        int n5 = this.keyOperation;
        DNDEvent dNDEvent = new DNDEvent();
        if (!this.setEventData(dNDEvent, this.iDataObject.getAddress(), n, n2, n3, n4)) {
            this.keyOperation = -1;
            OS.MoveMemory(n4, new int[]{0}, 4);
            return 1;
        }
        int n6 = dNDEvent.operations;
        TransferData[] transferDataArray = new TransferData[dNDEvent.dataTypes.length];
        System.arraycopy(dNDEvent.dataTypes, 0, transferDataArray, 0, transferDataArray.length);
        if (this.keyOperation == n5) {
            dNDEvent.type = 2004;
            dNDEvent.dataType = this.selectedDataType;
            dNDEvent.detail = this.selectedOperation;
        } else {
            dNDEvent.type = 2005;
            dNDEvent.dataType = this.selectedDataType;
        }
        this.notifyListeners(dNDEvent.type, dNDEvent);
        this.refresh();
        if (dNDEvent.detail == 16) {
            dNDEvent.detail = (n6 & 2) != 0 ? 2 : 0;
        }
        this.selectedDataType = null;
        for (int i = 0; i < transferDataArray.length; ++i) {
            if (!TransferData.sameType(transferDataArray[i], dNDEvent.dataType)) continue;
            this.selectedDataType = transferDataArray[i];
            break;
        }
        this.selectedOperation = 0;
        if (this.selectedDataType != null && (n6 & dNDEvent.detail) == dNDEvent.detail) {
            this.selectedOperation = dNDEvent.detail;
        }
        OS.MoveMemory(n4, new int[]{this.opToOs(this.selectedOperation)}, 4);
        return 0;
    }

    int Drop_64(int n, int n2, long l, int n3) {
        POINT pOINT = new POINT();
        OS.MoveMemory(pOINT, new long[]{l}, 8);
        return this.Drop(n, n2, pOINT.x, pOINT.y, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int Drop(int n, int n2, int n3, int n4, int n5) {
        n3 = DPIUtil.autoScaleDown(n3);
        n4 = DPIUtil.autoScaleDown(n4);
        DNDEvent dNDEvent = new DNDEvent();
        dNDEvent.widget = this;
        dNDEvent.time = OS.GetMessageTime();
        if (this.dropEffect != null) {
            dNDEvent.item = this.dropEffect.getItem(n3, n4);
        }
        dNDEvent.detail = 0;
        this.notifyListeners(2003, dNDEvent);
        this.refresh();
        dNDEvent = new DNDEvent();
        if (!this.setEventData(dNDEvent, n, n2, n3, n4, n5)) {
            this.keyOperation = -1;
            OS.MoveMemory(n5, new int[]{0}, 4);
            return 1;
        }
        this.keyOperation = -1;
        int n6 = dNDEvent.operations;
        TransferData[] transferDataArray = new TransferData[dNDEvent.dataTypes.length];
        System.arraycopy(dNDEvent.dataTypes, 0, transferDataArray, 0, transferDataArray.length);
        dNDEvent.dataType = this.selectedDataType;
        dNDEvent.detail = this.selectedOperation;
        this.notifyListeners(2007, dNDEvent);
        this.refresh();
        this.selectedDataType = null;
        for (int i = 0; i < transferDataArray.length; ++i) {
            if (!TransferData.sameType(transferDataArray[i], dNDEvent.dataType)) continue;
            this.selectedDataType = transferDataArray[i];
            break;
        }
        this.selectedOperation = 0;
        if (this.selectedDataType != null && (n6 & dNDEvent.detail) == dNDEvent.detail) {
            this.selectedOperation = dNDEvent.detail;
        }
        if (this.selectedOperation == 0) {
            OS.MoveMemory(n5, new int[]{0}, 4);
            return 0;
        }
        Object object = null;
        for (int i = 0; i < this.transferAgents.length; ++i) {
            Transfer transfer = this.transferAgents[i];
            if (transfer == null || !transfer.isSupportedType(this.selectedDataType)) continue;
            object = transfer.nativeToJava(this.selectedDataType);
            break;
        }
        if (object == null) {
            this.selectedOperation = 0;
        }
        dNDEvent.detail = this.selectedOperation;
        dNDEvent.dataType = this.selectedDataType;
        dNDEvent.data = object;
        OS.ImageList_DragShowNolock(false);
        try {
            this.notifyListeners(2006, dNDEvent);
        }
        finally {
            OS.ImageList_DragShowNolock(true);
        }
        this.refresh();
        this.selectedOperation = 0;
        if ((n6 & dNDEvent.detail) == dNDEvent.detail) {
            this.selectedOperation = dNDEvent.detail;
        }
        OS.MoveMemory(n5, new int[]{this.opToOs(this.selectedOperation)}, 4);
        return 0;
    }

    public Control getControl() {
        return this.control;
    }

    public DropTargetListener[] getDropListeners() {
        Listener[] listenerArray = this.getListeners(2002);
        int n = listenerArray.length;
        DropTargetListener[] dropTargetListenerArray = new DropTargetListener[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Listener listener = listenerArray[i];
            if (!(listener instanceof DNDListener)) continue;
            dropTargetListenerArray[n2] = (DropTargetListener)((DNDListener)listener).getEventListener();
            ++n2;
        }
        if (n2 == n) {
            return dropTargetListenerArray;
        }
        DropTargetListener[] dropTargetListenerArray2 = new DropTargetListener[n2];
        System.arraycopy(dropTargetListenerArray, 0, dropTargetListenerArray2, 0, n2);
        return dropTargetListenerArray2;
    }

    public DropTargetEffect getDropTargetEffect() {
        return this.dropEffect;
    }

    int getOperationFromKeyState(int n) {
        boolean bl;
        boolean bl2 = (n & 8) != 0;
        boolean bl3 = (n & 4) != 0;
        boolean bl4 = bl = (n & 0x20) != 0;
        if (bl) {
            if (bl2 || bl3) {
                return 16;
            }
            return 4;
        }
        if (bl2 && bl3) {
            return 4;
        }
        if (bl2) {
            return 1;
        }
        if (bl3) {
            return 2;
        }
        return 16;
    }

    public Transfer[] getTransfer() {
        return this.transferAgents;
    }

    void onDispose() {
        if (this.control == null) {
            return;
        }
        COM.RevokeDragDrop(this.control.handle);
        if (this.controlListener != null) {
            this.control.removeListener(12, this.controlListener);
        }
        this.controlListener = null;
        this.control.setData("DropTarget", null);
        this.transferAgents = null;
        this.control = null;
        COM.CoLockObjectExternal(this.iDropTarget.getAddress(), false, true);
        this.Release();
        if (this.iDataObject != null) {
            this.iDataObject.Release();
        }
        this.iDataObject = null;
        if (COM.FreeUnusedLibraries) {
            COM.CoFreeUnusedLibraries();
        }
    }

    int opToOs(int n) {
        int n2 = 0;
        if ((n & 1) != 0) {
            n2 |= 1;
        }
        if ((n & 4) != 0) {
            n2 |= 4;
        }
        if ((n & 2) != 0) {
            n2 |= 2;
        }
        return n2;
    }

    int osToOp(int n) {
        int n2 = 0;
        if ((n & 1) != 0) {
            n2 |= 1;
        }
        if ((n & 4) != 0) {
            n2 |= 4;
        }
        if ((n & 2) != 0) {
            n2 |= 2;
        }
        return n2;
    }

    int QueryInterface(int n, int n2) {
        if (n == 0 || n2 == 0) {
            return -2147024809;
        }
        GUID gUID = new GUID();
        COM.MoveMemory(gUID, n, GUID.sizeof);
        if (COM.IsEqualGUID(gUID, COM.IIDIUnknown) || COM.IsEqualGUID(gUID, COM.IIDIDropTarget)) {
            COM.MoveMemory(n2, new int[]{this.iDropTarget.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        COM.MoveMemory(n2, new int[]{0}, OS.PTR_SIZEOF);
        return -2147467262;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
            if (COM.FreeUnusedLibraries) {
                COM.CoFreeUnusedLibraries();
            }
        }
        return this.refCount;
    }

    void refresh() {
        if (this.control == null || this.control.isDisposed()) {
            return;
        }
        int n = this.control.handle;
        RECT rECT = new RECT();
        if (OS.GetUpdateRect(n, rECT, false)) {
            OS.ImageList_DragShowNolock(false);
            OS.RedrawWindow(n, rECT, 0, 257);
            OS.ImageList_DragShowNolock(true);
        }
    }

    public void removeDropListener(DropTargetListener dropTargetListener) {
        if (dropTargetListener == null) {
            DND.error(4);
        }
        this.removeListener(2002, dropTargetListener);
        this.removeListener(2003, dropTargetListener);
        this.removeListener(2004, dropTargetListener);
        this.removeListener(2005, dropTargetListener);
        this.removeListener(2006, dropTargetListener);
        this.removeListener(2007, dropTargetListener);
    }

    public void setDropTargetEffect(DropTargetEffect dropTargetEffect) {
        this.dropEffect = dropTargetEffect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setEventData(DNDEvent dNDEvent, int n, int n2, int n3, int n4, int n5) {
        int n6;
        if (n == 0 || n5 == 0) {
            return false;
        }
        int n7 = this.getStyle();
        int[] nArray = new int[1];
        OS.MoveMemory(nArray, n5, 4);
        nArray[0] = this.osToOp(nArray[0]) & n7;
        if (nArray[0] == 0) {
            return false;
        }
        this.keyOperation = n6 = this.getOperationFromKeyState(n2);
        if (n6 == 16) {
            if ((n7 & 0x10) == 0) {
                n6 = (nArray[0] & 2) != 0 ? 2 : 0;
            }
        } else if ((n6 & nArray[0]) == 0) {
            n6 = 0;
        }
        TransferData[] transferDataArray = new TransferData[]{};
        IDataObject iDataObject = new IDataObject(n);
        iDataObject.AddRef();
        try {
            int[] nArray2 = new int[1];
            if (iDataObject.EnumFormatEtc(1, nArray2) != 0) {
                boolean bl = false;
                return bl;
            }
            IEnumFORMATETC iEnumFORMATETC = new IEnumFORMATETC(nArray2[0]);
            try {
                int n8 = OS.GlobalAlloc(64, FORMATETC.sizeof);
                try {
                    int[] nArray3 = new int[1];
                    iEnumFORMATETC.Reset();
                    block10: while (iEnumFORMATETC.Next(1, n8, nArray3) == 0 && nArray3[0] == 1) {
                        TransferData transferData = new TransferData();
                        transferData.formatetc = new FORMATETC();
                        COM.MoveMemory(transferData.formatetc, n8, FORMATETC.sizeof);
                        transferData.type = transferData.formatetc.cfFormat;
                        transferData.pIDataObject = n;
                        for (int i = 0; i < this.transferAgents.length; ++i) {
                            Transfer transfer = this.transferAgents[i];
                            if (transfer == null || !transfer.isSupportedType(transferData)) continue;
                            TransferData[] transferDataArray2 = new TransferData[transferDataArray.length + 1];
                            System.arraycopy(transferDataArray, 0, transferDataArray2, 0, transferDataArray.length);
                            transferDataArray2[transferDataArray.length] = transferData;
                            transferDataArray = transferDataArray2;
                            continue block10;
                        }
                    }
                }
                finally {
                    OS.GlobalFree(n8);
                }
            }
            finally {
                iEnumFORMATETC.Release();
            }
        }
        finally {
            iDataObject.Release();
        }
        if (transferDataArray.length == 0) {
            return false;
        }
        dNDEvent.widget = this;
        dNDEvent.x = n3;
        dNDEvent.y = n4;
        dNDEvent.time = OS.GetMessageTime();
        dNDEvent.feedback = 1;
        dNDEvent.dataTypes = transferDataArray;
        dNDEvent.dataType = transferDataArray[0];
        if (this.dropEffect != null) {
            dNDEvent.item = this.dropEffect.getItem(n3, n4);
        }
        dNDEvent.operations = nArray[0];
        dNDEvent.detail = n6;
        return true;
    }

    public void setTransfer(Transfer[] transferArray) {
        if (transferArray == null) {
            DND.error(4);
        }
        this.transferAgents = transferArray;
    }
}

