/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import zmq.Clock;
import zmq.IPollEvents;
import zmq.MultiMap;

abstract class PollerBase {
    private final AtomicInteger load = new AtomicInteger(0);
    private final Map<Long, TimerInfo> timers = new MultiMap<Long, TimerInfo>();
    private final Map<Long, TimerInfo> addingTimers = new MultiMap<Long, TimerInfo>();

    protected PollerBase() {
    }

    public final int getLoad() {
        return this.load.get();
    }

    protected void adjustLoad(int amount) {
        this.load.addAndGet(amount);
    }

    public void addTimer(long timeout, IPollEvents sink, int id) {
        long expiration = Clock.nowMS() + timeout;
        TimerInfo info = new TimerInfo(sink, id);
        this.addingTimers.put(expiration, info);
    }

    public void cancelTimer(IPollEvents sink, int id) {
        if (!this.addingTimers.isEmpty()) {
            this.timers.putAll(this.addingTimers);
            this.addingTimers.clear();
        }
        Iterator<Map.Entry<Long, TimerInfo>> it = this.timers.entrySet().iterator();
        while (it.hasNext()) {
            TimerInfo v = it.next().getValue();
            if (v.sink != sink || v.id != id) continue;
            it.remove();
            return;
        }
        assert (false);
    }

    protected long executeTimers() {
        if (!this.addingTimers.isEmpty()) {
            this.timers.putAll(this.addingTimers);
            this.addingTimers.clear();
        }
        if (this.timers.isEmpty()) {
            return 0L;
        }
        long current = Clock.nowMS();
        Iterator<Map.Entry<Long, TimerInfo>> it = this.timers.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Long, TimerInfo> o = it.next();
            if (o.getKey() > current) {
                return o.getKey() - current;
            }
            o.getValue().sink.timerEvent(o.getValue().id);
            it.remove();
        }
        if (!this.addingTimers.isEmpty()) {
            return this.executeTimers();
        }
        return 0L;
    }

    private final class TimerInfo {
        IPollEvents sink;
        int id;

        public TimerInfo(IPollEvents sink, int id) {
            this.sink = sink;
            this.id = id;
        }
    }
}

