/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.view;

import com.parablu.epa.common.constants.SyncConstants;
import com.parablu.epa.common.view.BaseView;
import com.parablu.epa.core.helper.PropertyHelper;
import com.parablu.epa.service.settings.MacSettingsHelper;
import com.parablu.epa.view.FontsManager;
import java.io.IOException;
import org.apache.commons.configuration.ConfigurationException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxySettingsView
extends BaseView {
    public Shell shell = null;
    private static final int COLOR255 = 255;
    private Color whiteColor = new Color((Device)Display.getCurrent(), 255, 255, 255);
    FontsManager fontsManager;
    private ImageData shellImageData = null;
    private Image shellImage = null;
    private static final int IMAGE_X_SCALE_SIZE = 72;
    private static final int IMAGE_Y_SCALE_SIZE = 72;
    private Color uiBackgroundColor = new Color((Device)Display.getCurrent(), 240, 240, 240);
    private static final int COLOR240 = 240;
    private Group proxyDiscriptionPanel = null;
    private Button proxyCheckBox = null;
    protected Composite centerWizardPanel = null;
    private Button okButton = null;
    private Button cancelButton = null;
    private static Logger logger = LoggerFactory.getLogger(ProxySettingsView.class);
    private static boolean uilock = false;

    ProxySettingsView() throws IOException {
        try {
            this.shell = new Shell(192);
            int xAxisLocation = this.shell.getDisplay().getClientArea().width / 2 - 150;
            int yAxisLocation = this.shell.getDisplay().getClientArea().height / 2 - 170;
            this.shell.setLocation(xAxisLocation, yAxisLocation);
            this.shell.setBackground(this.whiteColor);
            this.shell.setMinimumSize(230, 170);
        }
        catch (Exception e) {
            logger.error("Exception in UIMain constructor: " + e.getMessage());
            logger.trace("" + e);
            uilock = false;
        }
    }

    public void openShell() {
        GridLayout shellGridLayout = new GridLayout();
        shellGridLayout.marginWidth = 0;
        shellGridLayout.marginHeight = 0;
        shellGridLayout.marginBottom = 0;
        shellGridLayout.verticalSpacing = 0;
        shellGridLayout.horizontalSpacing = 0;
        shellGridLayout.numColumns = 1;
        shellGridLayout.marginRight = 0;
        this.shell.setLayout((Layout)shellGridLayout);
        this.fontsManager = new FontsManager(this.shell.getDisplay());
        this.shell.setText(PropertyHelper.REGVIEW_APPNAME);
        this.shell.setFont(this.fontsManager.getMediumNormalFont());
        this.shellImageData = new ImageData(MacSettingsHelper.baseResourceFolder + SyncConstants.PARABLU_NAMED_IMAGE);
        this.shellImage = new Image((Device)this.shell.getDisplay(), this.shellImageData.scaledTo(72, 72));
        this.shell.setImage(this.shellImage);
        this.generateUI();
        Listener listener = event -> {
            logger.debug("BluSync UI Close action called from UIMain");
            this.closeUi(true);
        };
        this.shell.addListener(21, listener);
        this.shell.pack();
        this.shell.open();
    }

    public void closeUi(boolean showApplyMessageForSettings) {
        if (this.shell == null) {
            return;
        }
        this.setImageDataObjectsToNull();
        if (this.shellImage != null && !this.shellImage.isDisposed()) {
            this.shellImage.dispose();
        }
        this.shell.setBackground(null);
        if (this.shell.getImage() != null && !this.shell.getImage().isDisposed()) {
            this.shell.getImage().dispose();
        }
        if (this.shell.getBackgroundImage() != null && !this.shell.getBackgroundImage().isDisposed()) {
            this.shell.getBackgroundImage().dispose();
        }
        this.shell.dispose();
        this.shell = null;
        if (this.uiBackgroundColor != null && !this.uiBackgroundColor.isDisposed()) {
            this.uiBackgroundColor.dispose();
        }
        if (this.whiteColor != null && !this.whiteColor.isDisposed()) {
            this.whiteColor.dispose();
        }
        logger.debug("Disposed all fields");
        uilock = false;
    }

    public static synchronized boolean isUilock() {
        return uilock;
    }

    public static synchronized void setUilock(boolean uilock) {
        ProxySettingsView.uilock = uilock;
    }

    private void setImageDataObjectsToNull() {
        this.shellImageData = null;
    }

    public void generateUI() {
        try {
            GridData proxtCheckBoxGridData = new GridData();
            GridData ProxyDetailsGridData = new GridData(768);
            GridLayout proxyDiscriptionPanelGridLayout = new GridLayout();
            this.baseGroup = new Composite((Composite)this.shell, 16);
            GridLayout proxyPanelCompositeLayout = new GridLayout();
            proxyPanelCompositeLayout.marginWidth = 10;
            proxyPanelCompositeLayout.marginRight = 10;
            proxyPanelCompositeLayout.marginLeft = 1;
            proxyPanelCompositeLayout.marginTop = 8;
            proxyPanelCompositeLayout.marginBottom = 15;
            proxyPanelCompositeLayout.marginHeight = 0;
            proxyPanelCompositeLayout.makeColumnsEqualWidth = false;
            proxyPanelCompositeLayout.horizontalSpacing = 2;
            this.baseGroup.setLayout((Layout)proxyPanelCompositeLayout);
            this.baseGroup.setLayoutData((Object)new GridData(1808));
            this.proxyDiscriptionPanel = new Group(this.baseGroup, 8);
            proxyDiscriptionPanelGridLayout.makeColumnsEqualWidth = false;
            proxyDiscriptionPanelGridLayout.marginLeft = 10;
            proxyDiscriptionPanelGridLayout.marginRight = 10;
            proxyDiscriptionPanelGridLayout.horizontalSpacing = 7;
            proxyDiscriptionPanelGridLayout.verticalSpacing = 6;
            proxyDiscriptionPanelGridLayout.marginTop = 6;
            proxyDiscriptionPanelGridLayout.marginBottom = 5;
            proxyDiscriptionPanelGridLayout.numColumns = 2;
            this.proxyDiscriptionPanel.setLayout((Layout)proxyDiscriptionPanelGridLayout);
            ProxyDetailsGridData.grabExcessHorizontalSpace = true;
            this.proxyDiscriptionPanel.setText("Proxy Details");
            this.proxyDiscriptionPanel.setFont(this.fontsManager.getSmallNormalFont());
            this.proxyDiscriptionPanel.setLayoutData((Object)ProxyDetailsGridData);
            this.proxyCheckBox = new Button((Composite)this.proxyDiscriptionPanel, 32);
            proxtCheckBoxGridData.verticalSpan = 2;
            proxtCheckBoxGridData.horizontalSpan = 2;
            this.proxyCheckBox.setLayoutData((Object)proxtCheckBoxGridData);
            this.proxyCheckBox.setFont(this.fontsManager.getMediumNormalFont());
            this.proxyCheckBox.setText("Use Proxy");
            Composite cancelcomp = new Composite(this.baseGroup, 4);
            GridLayout proxyDiscriptionPanelGridLayout1 = new GridLayout();
            proxyDiscriptionPanelGridLayout1.makeColumnsEqualWidth = false;
            proxyDiscriptionPanelGridLayout1.marginLeft = 5;
            proxyDiscriptionPanelGridLayout1.horizontalSpacing = 7;
            proxyDiscriptionPanelGridLayout1.verticalSpacing = 6;
            proxyDiscriptionPanelGridLayout1.marginTop = 10;
            proxyDiscriptionPanelGridLayout1.marginBottom = 10;
            proxyDiscriptionPanelGridLayout1.numColumns = 3;
            GridData ProxyDetailsGridData1 = new GridData(768);
            ProxyDetailsGridData1.grabExcessHorizontalSpace = true;
            cancelcomp.setLayout((Layout)proxyDiscriptionPanelGridLayout1);
            cancelcomp.setLayoutData((Object)ProxyDetailsGridData1);
            GridData saveGridData = new GridData();
            saveGridData.horizontalAlignment = 2;
            saveGridData.widthHint = 80;
            Label dummyLable = new Label(cancelcomp, 4);
            dummyLable.setText("                ");
            dummyLable.setToolTipText("");
            dummyLable.setEnabled(false);
            this.okButton = new Button(cancelcomp, 8);
            this.okButton.setText(" Save ");
            this.okButton.setBounds(20, 310, 110, 30);
            this.okButton.setLayoutData((Object)saveGridData);
            this.okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    logger.debug("inside okk..." + ProxySettingsView.this.proxyCheckBox.getSelection());
                    String value = String.valueOf(ProxySettingsView.this.proxyCheckBox.getSelection());
                    try {
                        PropertyHelper.changeConfigProperty((String)"Proxy-Enabled", (String)value, (int)1);
                        ProxySettingsView.this.shell.close();
                    }
                    catch (ConfigurationException e1) {
                        logger.error("Error to set wl properties .." + e1.getMessage());
                        e1.printStackTrace();
                    }
                }
            });
            this.cancelButton = new Button(cancelcomp, 8);
            this.cancelButton.setText(" Cancel ");
            this.cancelButton.setBounds(20, 300, 100, 30);
            this.cancelButton.setLayoutData((Object)saveGridData);
            this.cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    logger.debug("inside cancel...");
                    ProxySettingsView.this.shell.close();
                }
            });
        }
        catch (Exception e) {
            logger.error("Error to create proxy ui.." + e.getMessage());
            e.printStackTrace();
        }
    }
}

