/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.view;

import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.common.view.BaseView;
import com.parablu.epa.core.adapter.pcb.LicenseAdapter;
import com.parablu.epa.service.notifications.UIHelper;
import com.parablu.epa.view.FontsManager;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseExpiredView
extends BaseView {
    private static Logger logger = LoggerFactory.getLogger(LicenseExpiredView.class);
    LicenseAdapter adapter;
    private Composite licensePanel = null;
    private Label licenseInfoLabel = null;
    private Link webLicenseLink = null;
    private Button updateLicenseButton = null;
    private FontsManager fontsManager;
    private static boolean madeLicenseRequest = false;

    public LicenseExpiredView(Composite composite) {
        this.mainParentComposite = composite;
        this.generateUI();
        this.adapter = new LicenseAdapter(SettingHelper.getCloudName(), SettingHelper.getKeystorePath());
    }

    private void generateUI() {
        GridLayout licensePanelGridLayout = new GridLayout();
        licensePanelGridLayout.marginTop = 20;
        licensePanelGridLayout.marginLeft = 20;
        licensePanelGridLayout.verticalSpacing = 30;
        licensePanelGridLayout.numColumns = 1;
        Display display = this.mainParentComposite.getDisplay();
        this.fontsManager = new FontsManager(display);
        this.baseGroup = new Composite(this.mainParentComposite, 16);
        this.baseGroup.setLayout((Layout)new GridLayout());
        this.baseGroup.setLayoutData((Object)new GridData(1808));
        this.baseGroup.setSize(100, 100);
        this.licensePanel = new Composite(this.baseGroup, 2048);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 80;
        this.licensePanel.setLayoutData((Object)gridData);
        this.licensePanel.setLayout((Layout)licensePanelGridLayout);
        this.licenseInfoLabel = new Label(this.licensePanel, 320);
        GridData licenseInfoLabelGridData = new GridData(512);
        this.licenseInfoLabel.setLayoutData((Object)licenseInfoLabelGridData);
        this.licenseInfoLabel.setText("The license for your Parablu installation has expired.\nPlease contact your Administrator.");
        this.licenseInfoLabel.setFont(this.fontsManager.getMediumNormalFont());
        Listener listener = event -> Program.launch((String)"http://www.parablusys.com");
        this.webLicenseLink.addListener(13, listener);
    }

    public void disposeAllLicenseViewFields() {
        this.fontsManager.disposeFonts();
        this.disposeAllLicenseViewPanelFields();
        if (this.licensePanel != null && !this.licensePanel.isDisposed()) {
            this.licensePanel.dispose();
        }
        this.licensePanel = null;
    }

    private void disposeAllLicenseViewPanelFields() {
        if (this.licenseInfoLabel != null && !this.licenseInfoLabel.isDisposed()) {
            this.licenseInfoLabel.dispose();
        }
        if (this.webLicenseLink != null && !this.webLicenseLink.isDisposed()) {
            this.webLicenseLink.dispose();
        }
        this.licenseInfoLabel = null;
        this.webLicenseLink = null;
    }

    class LicenseCheckListener
    implements Listener {
        LicenseCheckListener() {
        }

        public void handleEvent(Event event) {
            LicenseExpiredView.this.updateLicenseButton.setText("Updating");
            LicenseExpiredView.this.updateLicenseButton.setEnabled(false);
            if (!madeLicenseRequest) {
                new Thread(new LicenseUpdaterRunnable()).start();
                madeLicenseRequest = true;
            }
        }
    }

    class LicenseUpdaterRunnable
    implements Runnable {
        LicenseUpdaterRunnable() {
        }

        @Override
        public void run() {
            logger.info("running LicenseUpdaterRunnable");
            int responseCode = LicenseExpiredView.this.adapter.isCloudLicenseValid(SettingHelper.getCurrentCloudIpAddress(), null, SettingHelper.getCloudName());
            logger.debug("responseCode " + responseCode);
            switch (responseCode) {
                case 1003: {
                    this.handleLicenseActive();
                    break;
                }
                case 1005: {
                    this.handleLicenseExpired();
                    break;
                }
                case 1000: {
                    this.handleLicenseCheckFailed();
                    break;
                }
            }
        }

        private void handleLicenseCheckFailed() {
            madeLicenseRequest = false;
            if (LicenseExpiredView.this.mainParentComposite == null || LicenseExpiredView.this.mainParentComposite.isDisposed()) {
                return;
            }
            Runnable runnable = () -> {
                if (LicenseExpiredView.this.mainParentComposite != null && !LicenseExpiredView.this.mainParentComposite.isDisposed()) {
                    MessageBox box = new MessageBox(LicenseExpiredView.this.mainParentComposite.getShell(), 1);
                    box.setText("License Update Failed");
                    box.setMessage("Cloud not reachable");
                    box.open();
                }
                if (LicenseExpiredView.this.updateLicenseButton != null && !LicenseExpiredView.this.updateLicenseButton.isDisposed()) {
                    LicenseExpiredView.this.updateLicenseButton.setText("Rescan License Information");
                    LicenseExpiredView.this.updateLicenseButton.setEnabled(true);
                }
            };
            LicenseExpiredView.this.mainParentComposite.getDisplay().asyncExec(runnable);
        }

        private void handleLicenseExpired() {
            madeLicenseRequest = false;
            if (LicenseExpiredView.this.mainParentComposite == null || LicenseExpiredView.this.mainParentComposite.isDisposed()) {
                return;
            }
            Runnable runnable = () -> {
                if (LicenseExpiredView.this.mainParentComposite != null && !LicenseExpiredView.this.mainParentComposite.isDisposed()) {
                    MessageBox box = new MessageBox(LicenseExpiredView.this.mainParentComposite.getShell(), 2);
                    box.setText("License Expired");
                    box.setMessage("The cloud license has expired");
                    box.open();
                }
                if (LicenseExpiredView.this.updateLicenseButton != null && !LicenseExpiredView.this.updateLicenseButton.isDisposed()) {
                    LicenseExpiredView.this.updateLicenseButton.setText("Rescan License Information");
                    LicenseExpiredView.this.updateLicenseButton.setEnabled(true);
                }
            };
            LicenseExpiredView.this.mainParentComposite.getDisplay().asyncExec(runnable);
        }

        private void handleLicenseActive() {
            madeLicenseRequest = false;
            if (LicenseExpiredView.this.mainParentComposite != null && !LicenseExpiredView.this.mainParentComposite.isDisposed()) {
                Runnable runnable = () -> {
                    if (LicenseExpiredView.this.mainParentComposite != null && !LicenseExpiredView.this.mainParentComposite.isDisposed()) {
                        MessageBox box = new MessageBox(LicenseExpiredView.this.mainParentComposite.getShell(), 2);
                        box.setText("Server license reactivated");
                        box.setMessage("Your Parablu Installation license has been renewed. Blusync will now configure your new settings");
                        box.open();
                    }
                    if (LicenseExpiredView.this.updateLicenseButton != null && !LicenseExpiredView.this.updateLicenseButton.isDisposed()) {
                        LicenseExpiredView.this.updateLicenseButton.setText("Rescan License Information");
                        LicenseExpiredView.this.updateLicenseButton.setEnabled(true);
                    }
                };
                LicenseExpiredView.this.mainParentComposite.getDisplay().syncExec(runnable);
            }
            this.updateUIAndConfiguration();
        }

        private void updateUIAndConfiguration() {
            UIHelper.reactivateAccount();
        }
    }
}

