/*
 * Decompiled with CFR 0.152.
 */
package com.parablu.epa.service.notifications;

import com.parablu.epa.common.constants.SyncConstants;
import com.parablu.epa.common.service.notification.NotificationHelper;
import com.parablu.epa.common.service.settings.SettingHelper;
import com.parablu.epa.common.stringliterals.GeneralLiterals;
import com.parablu.epa.core.constant.StringLiterals;
import com.parablu.epa.service.alarm.BlusyncThreadHelper;
import com.parablu.epa.service.settings.MacSettingsHelper;
import com.parablu.epa.view.BluSyncLauncher;
import com.parablu.epa.view.SystemTrayUI;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ToolTip;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UIHelper {
    private static SystemTrayUI systemTrayUI = null;
    private static Display display = null;
    private static Logger logger = LoggerFactory.getLogger(UIHelper.class);
    private static int imageNumber = 0;
    private static ImageLoader loader = null;
    private static Image imageForSyncing = null;
    private static Thread gifUpdaterThread = null;

    private UIHelper() {
    }

    public static void setSystemTrayUI(SystemTrayUI currentSystemTrayUI, Display systrayDisplay) {
        systemTrayUI = currentSystemTrayUI;
        display = systrayDisplay;
    }

    public static void deactivateAccount() {
        SettingHelper.setLicenseActive((boolean)false);
        if (systemTrayUI == null) {
            return;
        }
        if (display == null) {
            return;
        }
        Runnable runnable = () -> {
            systemTrayUI.disposeSystrayUIShells();
            systemTrayUI = null;
        };
        display.syncExec(runnable);
        BluSyncLauncher.startUI();
    }

    public static void reactivateAccount() {
        SettingHelper.setLicenseActive((boolean)true);
        if (systemTrayUI == null) {
            return;
        }
        if (display == null) {
            return;
        }
        Runnable runnable = () -> {
            if (systemTrayUI.getInstance() != null) {
                systemTrayUI.getInstance().close(false);
            }
            systemTrayUI.disposeSystrayUIShells();
            systemTrayUI = null;
        };
        display.syncExec(runnable);
        BluSyncLauncher.startUI();
    }

    public static synchronized void terminateLicense() {
        if (SettingHelper.isLicenseActive()) {
            logger.debug("licenseExpired");
            return;
        }
        SettingHelper.setLicenseActive((boolean)true);
        BlusyncThreadHelper.waitForBackupJob();
        UIHelper.deactivateAccount();
    }

    public static synchronized void reActivatelicense() {
        SettingHelper.setLicenseActive((boolean)false);
        UIHelper.reactivateAccount();
    }

    public static void disconnectFromParacloud(int status) {
        if (status == 11) {
            UIHelper.updateSystrayToolTipNotificationAndWaitForDisplay("Device Blocked By User", GeneralLiterals.DEVICE_BLOCKED_MESSAGE_TOOLTIP);
        } else {
            UIHelper.updateSystrayToolTipNotificationAndWaitForDisplay("Login Credentials Expired", GeneralLiterals.LOGIN_CREDENTIALS_EXPIRED_MESSAGE_TOOLTIP);
        }
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            logger.error("InterruptedException while thread sleep", (Throwable)e);
        }
        UIHelper.disconnectFromParacloud();
    }

    public static synchronized void blockDevice() {
        if (SettingHelper.isDeviceBlocked()) {
            logger.debug("deviceBlocked");
            return;
        }
        SettingHelper.setDeviceBlocked((boolean)true);
        UIHelper.deleteParabluFolderFiles();
        UIHelper.disconnectFromParacloud(11);
    }

    private static void deleteParabluFolderFiles() {
        File file = new File(SettingHelper.getParabluSyncFolder() + StringLiterals.CONSTANTS_FILE_SEPARATOR + "ParaBlu");
        for (File fileToDelete : file.listFiles()) {
            try {
                FileUtils.forceDelete((File)fileToDelete);
            }
            catch (IOException e) {
                logger.error(" IOException while forcedelete: " + fileToDelete.getAbsolutePath(), (Throwable)e);
            }
        }
    }

    public static void disposeSystray() {
        if (systemTrayUI == null) {
            return;
        }
        if (display == null) {
            return;
        }
        Runnable runnable = () -> {
            if (systemTrayUI.getInstance() != null) {
                systemTrayUI.getInstance().close(false);
            }
            systemTrayUI.disposeSystrayUIShells();
            systemTrayUI = null;
        };
        display.syncExec(runnable);
    }

    public static synchronized void updateSystrayToolTipNotification(String text, String message) {
        if (systemTrayUI == null) {
            return;
        }
        if (display == null) {
            return;
        }
        Runnable runnable = () -> {
            if (systemTrayUI != null && systemTrayUI.getSystrayItem() != null && systemTrayUI.getSystrayItem().getToolTip() != null && !systemTrayUI.getSystrayItem().getToolTip().getVisible()) {
                systemTrayUI.getSystrayItem().getToolTip().dispose();
                ToolTip toolTip = new ToolTip(systemTrayUI.getSystrayShell(), 4098);
                systemTrayUI.getSystrayItem().setToolTip(toolTip);
                systemTrayUI.getSystrayItem().getToolTip().setMessage(message);
                systemTrayUI.getSystrayItem().getToolTip().setText(text);
                systemTrayUI.getSystrayItem().getToolTip().setVisible(true);
                systemTrayUI.getSystrayItem().getToolTip().setAutoHide(true);
            }
        };
        display.asyncExec(runnable);
    }

    public static synchronized void updateSystrayToolTipNotificationAndWaitForDisplay(String text, String message) {
        if (systemTrayUI == null) {
            return;
        }
        if (display == null) {
            return;
        }
        Runnable runnable = () -> {
            systemTrayUI.getSystrayItem().getToolTip().dispose();
            ToolTip toolTip = new ToolTip(systemTrayUI.getSystrayShell(), 4098);
            systemTrayUI.getSystrayItem().setToolTip(toolTip);
            systemTrayUI.getSystrayItem().getToolTip().setMessage(message);
            systemTrayUI.getSystrayItem().getToolTip().setText(text);
            systemTrayUI.getSystrayItem().getToolTip().setVisible(true);
        };
        display.syncExec(runnable);
    }

    public static void disconnectFromParacloud() {
        if (systemTrayUI == null) {
            return;
        }
        if (display == null) {
            return;
        }
        Runnable runnable = () -> BluSyncLauncher.changeAccount();
        display.syncExec(runnable);
    }

    public static void updateSystrayImageAccordingToStage(String systrayImageUrl) {
        if (systemTrayUI == null) {
            return;
        }
        if (display == null) {
            return;
        }
        Runnable runnable = () -> {
            systemTrayUI.getSystrayItem().getImage().dispose();
            systemTrayUI.getSystrayItem().setImage(new Image((Device)display, new ImageData(systrayImageUrl).scaledTo(24, 24)));
            systemTrayUI.getSystrayShell().layout();
        };
        display.asyncExec(runnable);
    }

    public static void displaySyncingGif() {
        if (display == null) {
            return;
        }
        Runnable runnable = () -> {
            loader = new ImageLoader();
            try {
                loader.load((InputStream)new FileInputStream(MacSettingsHelper.baseResourceFolder + SyncConstants.CURRENTLY_SYNCING_IMAGE));
                imageForSyncing = new Image((Device)display, UIHelper.loader.data[0]);
                if (!imageForSyncing.isDisposed()) {
                    systemTrayUI.getSystrayItem().setImage(imageForSyncing);
                }
                imageForSyncing.dispose();
                gifUpdaterThread = new Thread(new GIFRunnableForSyncing());
                gifUpdaterThread.start();
            }
            catch (FileNotFoundException e) {
                logger.error("FileNotFoundException for PARABLU_SEARCHING_GIF in systray: ", (Throwable)e);
            }
        };
        display.asyncExec(runnable);
    }

    static class GIFRunnableForSyncing
    implements Runnable {
        GIFRunnableForSyncing() {
        }

        @Override
        public void run() {
            Runnable runnable;
            long delayTime;
            if (display == null) {
                logger.debug("display is null");
                return;
            }
            while (NotificationHelper.getMainStatus() == 101) {
                delayTime = UIHelper.loader.data[UIHelper.imageNumber].delayTime;
                try {
                    Thread.sleep(delayTime * 20L);
                }
                catch (InterruptedException e1) {
                    logger.error("Thread Interrupted " + e1);
                }
                if (NotificationHelper.getMainStatus() != 101) {
                    return;
                }
                runnable = () -> {
                    try {
                        int n = imageNumber = imageNumber == UIHelper.loader.data.length - 1 ? 0 : imageNumber + 1;
                        if (!display.isDisposed()) {
                            imageForSyncing.dispose();
                            imageForSyncing = new Image((Device)display, UIHelper.loader.data[imageNumber]);
                            systemTrayUI.getSystrayItem().setImage(imageForSyncing);
                        }
                    }
                    catch (Exception e) {
                        logger.error("Exception in canvas/compositeForGif: ", (Throwable)e);
                    }
                };
                display.asyncExec(runnable);
            }
            while (NotificationHelper.backUpStarted) {
                delayTime = UIHelper.loader.data[UIHelper.imageNumber].delayTime;
                try {
                    Thread.sleep(delayTime * 40L);
                }
                catch (InterruptedException e1) {
                    logger.error("Thread Interrupted " + e1);
                }
                if (!NotificationHelper.backUpStarted) {
                    return;
                }
                runnable = () -> {
                    try {
                        int n = imageNumber = imageNumber == UIHelper.loader.data.length - 1 ? 0 : imageNumber + 1;
                        if (!display.isDisposed()) {
                            imageForSyncing.dispose();
                            imageForSyncing = new Image((Device)display, UIHelper.loader.data[imageNumber]);
                            systemTrayUI.getSystrayItem().setImage(imageForSyncing);
                        }
                    }
                    catch (Exception e) {
                        logger.error("Exception in canvas/compositeForGif: ", (Throwable)e);
                    }
                };
                display.asyncExec(runnable);
            }
        }
    }
}

